/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import jp.sourceforge.concierge.framework.AbstractDocumentUIPlugin;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.plugin.labnote.CategoryManager;
import jp.sourceforge.concierge.plugin.labnote.LabNoteDocumentImpl;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.BundleContext;
import org.w3c.dom.Document;

public class LabNotePlugin
extends AbstractDocumentUIPlugin {
    private static final String BUNDLE_NAME = "jp.sourceforge.concierge.plugin.labnote.messages";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("jp.sourceforge.concierge.plugin.labnote.messages");
    public static final String PLUGIN_ID = "jp.sourceforge.concierge.plugin.labnote";
    public static final String TYPE_NAME = "Note";
    private static LabNotePlugin plugin;
    private CategoryManager cmanager = new CategoryManager();

    public static String getString(String key) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return String.valueOf('!') + key + '!';
        }
    }

    public static String getLabNoteSrcDirectory() {
        return String.valueOf(FrameworkPlugin.getLocalDatabaseDirectory()) + File.separator + PLUGIN_ID;
    }

    public static String getLabNoteImageDirectory() {
        return String.valueOf(FrameworkPlugin.getLocalDatabaseDirectory()) + File.separator + PLUGIN_ID + File.separator + "Images";
    }

    public LabNotePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        String labimgdir;
        File lid;
        super.start(context);
        this.cmanager.initialize();
        String labsrcdir = LabNotePlugin.getLabNoteSrcDirectory();
        File ld = new File(labsrcdir);
        if (!ld.exists()) {
            ld.mkdir();
        }
        if (!(lid = new File(labimgdir = LabNotePlugin.getLabNoteImageDirectory())).exists()) {
            lid.mkdir();
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static LabNotePlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return LabNotePlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static String importImageFile(String srcfile, long id) {
        try {
            File sf = new File(srcfile);
            File idir = new File(LabNotePlugin.getLabNoteImageDirectory());
            if (sf.getParentFile().equals(idir)) {
                return srcfile;
            }
            String ext = FilenameUtils.getExtension((String)srcfile);
            String dstfile = null;
            dstfile = id > 0L ? String.valueOf(LabNotePlugin.getLabNoteImageDirectory()) + File.separator + "doc" + String.valueOf(id) + "." + ext : String.valueOf(LabNotePlugin.getLabNoteImageDirectory()) + File.separator + "nodoc" + String.valueOf(DomImpl.getUniqueID()) + "." + ext;
            File df = new File(dstfile);
            FileUtils.copyFile((File)sf, (File)df, (boolean)true);
            return dstfile;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void removeImageFile(long id) {
        File imdir = new File(LabNotePlugin.getLabNoteImageDirectory());
        File[] files = imdir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].getName().startsWith("doc" + String.valueOf(id))) {
                files[i].delete();
            }
            ++i;
        }
    }

    public static void removeImageFile(String file) {
        File f = new File(file);
        File idir = new File(LabNotePlugin.getLabNoteImageDirectory());
        if (!f.getParentFile().equals(idir)) {
            return;
        }
        f.delete();
    }

    public static void removeImageFiles(ArrayList<String> files) {
        int i = 0;
        while (i < files.size()) {
            LabNotePlugin.removeImageFile(files.get(i));
            ++i;
        }
    }

    public void updateDocumentsUpdatingCategory(String oldcat, String newcat) {
    }

    public void updateDocumentsDeletingCategory(String category) {
    }

    private static ArrayList<Document> getLabNoteDocuments() {
        String xpath = "/mdata/data[@name='Note']";
        Request r = new Request(4, (Object)xpath, "data");
        return FrameworkPlugin.getDocumentsOfQuery((Request)r);
    }

    private void sendDocumentRequest(Document doc, String col, int type, Object sender) {
        ArrayList<Request> reqs = new ArrayList<Request>();
        Request req = new Request(type, (Object)doc, col);
        reqs.add(req);
        FrameworkPlugin.updateDocuments(reqs, (Object)sender);
    }

    public void addDocument(Document doc, boolean dbupdate, Object sender) {
        if (sender == null) {
            sender = plugin.getBundle().getSymbolicName();
        }
        if (dbupdate) {
            this.sendDocumentRequest(doc, "data", 1, sender);
        }
    }

    public void updateDocument(Document doc, Object sender) {
        if (sender == null) {
            sender = plugin.getBundle().getSymbolicName();
        }
        this.sendDocumentRequest(doc, "data", 3, sender);
    }

    public void deleteDocument(Document doc, boolean dbupdate, Object sender) {
        if (sender == null) {
            sender = plugin.getBundle().getSymbolicName();
        }
        if (dbupdate) {
            this.sendDocumentRequest(doc, "data", 2, sender);
        }
    }

    public static void setLocalConfiguration(String key, String val) {
        plugin.getPreferenceStore().setValue(key, val);
    }

    public static String getLocalConfiguration(String key) {
        return plugin.getPreferenceStore().getString(key);
    }

    public static void showMessage(Shell parent, String message) {
        MessageDialog.openInformation((Shell)parent, (String)"LabNote", (String)message);
    }

    public static boolean showConfirm(Shell parent, String message) {
        return MessageDialog.openConfirm((Shell)parent, (String)"LabNote", (String)message);
    }

    public static String getXPath(int year, int month, int day) {
        String dateval = String.format("%04d-%02d-%02d", year, month, day);
        String xpath = "/mdata/data[@name='Note' and Date='" + dateval + "']";
        return xpath;
    }

    public static ArrayList<Document> getDocuments(int year, int month, int day) {
        ArrayList<Document> rdocs = new ArrayList<Document>();
        String dateval = String.format("%04d-%02d-%02d", year, month, day);
        ArrayList<Document> docs = LabNotePlugin.getLabNoteDocuments();
        int i = 0;
        while (i < docs.size()) {
            String dv = LabNoteDocumentImpl.getDate(docs.get(i));
            if (dv.equals(dateval)) {
                rdocs.add(docs.get(i));
            }
            ++i;
        }
        return rdocs;
    }

    public static ArrayList<Document> updateLabNoteDocuments(String oldname, String newname) {
        ArrayList<Document> docs = LabNotePlugin.getLabNoteDocuments();
        ArrayList<Document> upddocs = new ArrayList<Document>();
        int i = 0;
        while (i < docs.size()) {
            Document doc = docs.get(i);
            String cat = LabNoteDocumentImpl.getCategory(doc);
            if (cat.equals(oldname)) {
                if (newname == null) {
                    LabNoteDocumentImpl.setCategory(doc, "<Unknown>");
                } else {
                    LabNoteDocumentImpl.setCategory(doc, newname);
                }
                upddocs.add(doc);
            }
            ++i;
        }
        Request nr = new Request(3, upddocs, "data");
        ArrayList<Request> nrl = new ArrayList<Request>();
        nrl.add(nr);
        if (FrameworkPlugin.updateDocuments(nrl, (Object)PLUGIN_ID)) {
            return upddocs;
        }
        return null;
    }

    public static CategoryManager getCategoryManager() {
        return LabNotePlugin.plugin.cmanager;
    }
}

