/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import org.eclipse.core.internal.indexing.Buffer;
import org.eclipse.core.internal.indexing.Field;
import org.eclipse.core.internal.indexing.IndexedStoreObject;
import org.eclipse.core.internal.indexing.ObjectAddress;
import org.eclipse.core.internal.indexing.ObjectStore;
import org.eclipse.core.internal.indexing.ObjectStoreException;

class BinarySmallObject
extends IndexedStoreObject {
    public static final int TYPE = 5;
    public static final int VALUE_OFFSET = 2;
    protected byte[] value;

    public BinarySmallObject(byte[] value) {
        this.value = new Buffer(value).get();
    }

    public BinarySmallObject(Field f, ObjectStore store, ObjectAddress address) throws ObjectStoreException {
        super(f, store, address);
    }

    @Override
    protected void insertValues(Field f) {
        super.insertValues(f);
        f.subfield(2).put(this.value);
    }

    @Override
    protected void extractValues(Field f) throws ObjectStoreException {
        super.extractValues(f);
        this.value = f.subfield(2).get();
    }

    @Override
    protected int getMaximumSize() {
        return 6002;
    }

    @Override
    protected int length() {
        return this.value.length + 2;
    }

    @Override
    protected int getMinimumSize() {
        return 2;
    }

    @Override
    protected int getRequiredType() {
        return 5;
    }

    public byte[] getValue() {
        return new Field(this.value).get();
    }

    @Override
    public String toString() {
        int n = 10;
        StringBuffer b = new StringBuffer();
        b.append("BSOB(");
        b.append(this.value.length);
        b.append(" [");
        int i = 0;
        while (i < this.value.length) {
            if (i > 0) {
                b.append(" ");
            }
            if (i == n) break;
            b.append(this.value[i]);
            ++i;
        }
        if (this.value.length > n) {
            b.append(" ...");
        }
        b.append("])");
        return b.toString();
    }
}

