/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.quickaccess.CommandElement;
import org.eclipse.ui.internal.quickaccess.QuickAccessElement;
import org.eclipse.ui.internal.quickaccess.QuickAccessMessages;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;

public class CommandProvider
extends QuickAccessProvider {
    private Map idToElement;
    private IEvaluationContext contextSnapshot;
    private IHandlerService handlerService;

    public CommandProvider() {
        this.saveApplicationContext();
        this.getElements();
    }

    @Override
    public String getId() {
        return "org.eclipse.ui.commands";
    }

    @Override
    public QuickAccessElement getElementForId(String id) {
        this.getElements();
        return (CommandElement)this.idToElement.get(id);
    }

    @Override
    public QuickAccessElement[] getElements() {
        if (this.idToElement == null) {
            this.idToElement = new HashMap();
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Collection commandIds = commandService.getDefinedCommandIds();
            for (String currentCommandId : commandIds) {
                Command command = commandService.getCommand(currentCommandId);
                if (command == null || !command.isHandled() || !command.isEnabled()) continue;
                try {
                    Collection combinations = ParameterizedCommand.generateCombinations((Command)command);
                    for (ParameterizedCommand pc : combinations) {
                        String id = pc.serialize();
                        this.idToElement.put(id, new CommandElement(pc, id, this));
                    }
                }
                catch (NotDefinedException notDefinedException) {}
            }
        }
        return this.idToElement.values().toArray(new QuickAccessElement[this.idToElement.values().size()]);
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return WorkbenchImages.getImageDescriptor("IMG_OBJ_NODE");
    }

    @Override
    public String getName() {
        return QuickAccessMessages.QuickAccess_Commands;
    }

    private void saveApplicationContext() {
        this.handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        this.contextSnapshot = this.handlerService.createContextSnapshot(true);
    }

    IHandlerService getHandlerService() {
        return this.handlerService;
    }

    IEvaluationContext getContextSnapshot() {
        return this.contextSnapshot;
    }
}

