/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.ibooks;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.plugin.iBooksPlugin;
import jp.sourceforge.concierge.plugin.ibooks.BookRegister;
import org.eclipse.core.runtime.IProgressMonitor;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AmazonXmlSAX
extends DefaultHandler {
    private String elementpath = null;
    private int totalPages_ = 0;
    private int totalResults_ = 0;
    private ArrayList<BookRegister> list = null;
    private BookRegister br = null;
    private String rootTag = null;
    private IProgressMonitor monitor = null;

    public AmazonXmlSAX() {
    }

    public AmazonXmlSAX(IProgressMonitor monitor) {
        this.rootTag = "ItemSearchResponse";
        this.monitor = monitor;
    }

    public AmazonXmlSAX(String rootTag, IProgressMonitor monitor) {
        this.rootTag = rootTag;
        this.monitor = monitor;
    }

    public int getTotalPages() {
        return this.totalPages_;
    }

    public int getTotalResults() {
        return this.totalResults_;
    }

    @Override
    public void startDocument() {
        System.out.println("iBooks ===>startDocument");
        this.list = new ArrayList();
    }

    public ArrayList<BookRegister> getList() {
        return this.list;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        this.elementpath = this.elementpath == null ? qName : String.valueOf(this.elementpath) + "/" + qName;
        if (this.elementpath.equalsIgnoreCase(String.valueOf(this.rootTag) + "/Items/Item")) {
            this.br = new BookRegister();
            if (this.monitor != null) {
                this.monitor.worked(0);
            }
        }
        if (this.monitor != null) {
            this.monitor.worked(0);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.elementpath.equalsIgnoreCase(String.valueOf(this.rootTag) + "/Items/TotalResults")) {
            String value = new String(ch, start, length);
            this.totalResults_ = Integer.valueOf(value);
        } else if (this.elementpath.equalsIgnoreCase(String.valueOf(this.rootTag) + "/Items/TotalPages")) {
            String value = new String(ch, start, length);
            this.totalPages_ = Integer.valueOf(value);
        } else if (this.elementpath.equalsIgnoreCase(String.valueOf(this.rootTag) + "/Items/Item/MediumImage/URL")) {
            String value = this.br.getIMAGEURL();
            value = String.valueOf(value) + new String(ch, start, length);
            this.br.setIMAGEURL(value);
        } else if (this.elementpath.equalsIgnoreCase(String.valueOf(this.rootTag) + "/Items/Item/ASIN")) {
            String value = this.br.getISBN();
            value = String.valueOf(value) + new String(ch, start, length);
            this.br.setISBN(value);
        } else if (this.elementpath.equalsIgnoreCase(String.valueOf(this.rootTag) + "/Items/Item/DetailPageURL")) {
            String value = this.br.getURL();
            value = String.valueOf(value) + new String(ch, start, length);
            this.br.setURL(value);
        } else if (this.elementpath.startsWith(String.valueOf(this.rootTag) + "/Items/Item/ItemAttributes")) {
            if (this.elementpath.equalsIgnoreCase(String.valueOf(this.rootTag) + "/Items/Item/ItemAttributes/Title")) {
                String value = this.br.getTitle();
                value = String.valueOf(value) + new String(ch, start, length);
                this.br.setTitle(value);
                if (this.monitor != null) {
                    this.monitor.subTask(value);
                }
            } else if (this.elementpath.equalsIgnoreCase(String.valueOf(this.rootTag) + "/Items/Item/ItemAttributes/Author")) {
                String value = this.br.getAuthor();
                value = value.length() == 0 ? new String(ch, start, length) : String.valueOf(value) + ", " + new String(ch, start, length);
                this.br.setAuthor(value);
            } else if (this.elementpath.equalsIgnoreCase(String.valueOf(this.rootTag) + "/Items/Item/ItemAttributes/Publisher")) {
                String value = this.br.getPublisher();
                value = String.valueOf(value) + new String(ch, start, length);
                this.br.setPublisher(value);
            } else if (this.elementpath.equalsIgnoreCase(String.valueOf(this.rootTag) + "/Items/Item/ItemAttributes/PublicationDate")) {
                String value = this.br.getYear();
                value = String.valueOf(value) + new String(ch, start, length);
                this.br.setYear(value);
            } else if (!this.elementpath.equalsIgnoreCase(String.valueOf(this.rootTag) + "/Items/Item/ItemAttributes/ISBN")) {
                if (this.elementpath.equalsIgnoreCase(String.valueOf(this.rootTag) + "/Items/Item/ItemAttributes/Binding")) {
                    String value = this.br.getCategory();
                    value = String.valueOf(value) + new String(ch, start, length);
                    this.br.setCategory(value);
                } else if (this.elementpath.equalsIgnoreCase(String.valueOf(this.rootTag) + "/Items/Item/ItemAttributes/ListPrice/Amount")) {
                    String value = this.br.getPrice();
                    value = String.valueOf(value) + new String(ch, start, length);
                    this.br.setPrice(value);
                }
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) {
        if (this.elementpath.equalsIgnoreCase(String.valueOf(this.rootTag) + "/Items/Item")) {
            if (this.br != null && !this.br.isEmpty()) {
                boolean hasBook = this.hasBookDataIntoConciergeDatabase(this.br.getISBN());
                this.br.setRegist(hasBook);
                this.list.add(this.br);
            }
            this.br = null;
        }
        String[] values = this.elementpath.split("/");
        this.elementpath = "";
        int i = 0;
        while (i < values.length - 1) {
            this.elementpath = this.elementpath.length() == 0 ? values[i] : String.valueOf(this.elementpath) + "/" + values[i];
            ++i;
        }
    }

    @Override
    public void endDocument() {
        System.out.println("iBooks ===>endDocument");
    }

    protected boolean hasBookDataIntoConciergeDatabase(String value) {
        String xpath = "/mdata/data[@name='Book']/ISBN[txt:body='" + value + "']";
        Request req = new Request(4, (Object)xpath, "data");
        ArrayList list = FrameworkPlugin.getDocumentsOfQuery((Request)req);
        return list != null && list.size() > 0;
    }

    public static AmazonXmlSAX SearchKeyword(String query, String baseUrlAddress, IProgressMonitor monitor, int page) {
        try {
            URL url = null;
            String en = URLEncoder.encode(query, "UTF-8");
            String urlAddress = String.valueOf(baseUrlAddress) + "onca/xml?Service=AWSECommerceService&";
            urlAddress = String.valueOf(urlAddress) + "SubscriptionId=" + iBooksPlugin.getDefault().getPreferenceStore().getString("SUBSCRIPTIONID");
            urlAddress = String.valueOf(urlAddress) + "&Operation=ItemSearch&SearchIndex=Books&Keywords=" + en;
            urlAddress = String.valueOf(urlAddress) + "&ResponseGroup=Medium";
            if (page > 0) {
                urlAddress = String.valueOf(urlAddress) + "&ItemPage=" + String.valueOf(page);
            }
            System.out.println("iBooks URL:" + urlAddress);
            if (monitor != null) {
                monitor.worked(0);
            }
            url = new URL(urlAddress);
            InputStream is = url.openStream();
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setValidating(true);
            SAXParser saxParser = saxParserFactory.newSAXParser();
            InputSource inputSource = new InputSource(is);
            AmazonXmlSAX xs = new AmazonXmlSAX(monitor);
            saxParser.parse(inputSource, (DefaultHandler)xs);
            is.close();
            return xs;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IOException iOException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {}
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AmazonXmlSAX SearchASIN(String query, String baseUrlAddress, IProgressMonitor monitor) {
        try {
            URL url = null;
            String asin = "";
            int i = 0;
            while (true) {
                if (i >= query.length()) {
                    if (asin.length() != 0) break;
                    return null;
                }
                char c = query.charAt(i);
                if ('0' <= c && c <= '9') {
                    asin = String.valueOf(asin) + c;
                } else if (c != '-') {
                    return null;
                }
                ++i;
            }
            String en = URLEncoder.encode(asin, "UTF-8");
            String urlAddress = String.valueOf(baseUrlAddress) + "onca/xml?Service=AWSECommerceService&";
            urlAddress = String.valueOf(urlAddress) + "SubscriptionId=" + iBooksPlugin.getDefault().getPreferenceStore().getString("SUBSCRIPTIONID");
            urlAddress = String.valueOf(urlAddress) + "&Operation=ItemLookup&IdType=ASIN&ItemId=" + en;
            urlAddress = String.valueOf(urlAddress) + "&ResponseGroup=Medium";
            System.out.println("iBooks URL:" + urlAddress);
            if (monitor != null) {
                monitor.worked(0);
            }
            url = new URL(urlAddress);
            InputStream is = url.openStream();
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setValidating(true);
            SAXParser saxParser = saxParserFactory.newSAXParser();
            InputSource inputSource = new InputSource(is);
            AmazonXmlSAX xs = new AmazonXmlSAX("ItemLookupResponse", monitor);
            saxParser.parse(inputSource, (DefaultHandler)xs);
            is.close();
            return xs;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return null;
        }
        catch (SAXException sAXException) {}
        return null;
    }
}

