/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.smartindexer;

import jp.sourceforge.concierge.plugin.SearcherPlugin;
import jp.sourceforge.concierge.plugin.SmartIndexer;
import jp.sourceforge.concierge.plugin.SmartIndexerPlugin;
import jp.sourceforge.concierge.plugin.searcher.data.Configure;
import jp.sourceforge.concierge.plugin.searcher.data.XPathCreator;
import jp.sourceforge.concierge.plugin.smartindexer.InternalBinder;
import jp.sourceforge.concierge.plugin.smartindexer.SmartIndexerUtils;
import jp.sourceforge.concierge.plugin.smartindexer.widget.SearchFolderInputDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Element;

public class InternalSearcher
extends InternalBinder {
    private final String strStartMenu = "Search";

    public Element getElement() {
        return this.config;
    }

    public InternalSearcher(Composite comp, SmartIndexer cls, Element elem) {
        super(comp, cls, elem);
        this.config = elem;
        ImageDescriptor imgDes = SmartIndexerPlugin.getImageDescriptor("icons/search.png");
        Image img = imgDes.createImage();
        this.folImage.setImage(img);
    }

    @Override
    protected void makeMenu() {
        super.makeMenu();
        new MenuItem(this.menu, 2);
        MenuItem item1 = new MenuItem(this.menu, 8);
        item1.setText("Search");
        item1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InternalSearcher.this.startSearch(true);
            }
        });
    }

    @Override
    protected void setMouseListener() {
        this.folImage.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                InternalSearcher.this.selectAction.run();
                InternalSearcher.this.startSearch(false);
            }

            public void mouseDoubleClick(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                InternalSearcher.this.selectAction.run();
                InternalSearcher.this.editInfo();
            }
        });
    }

    @Override
    public InternalSearcher clone() {
        Element info = Configure.copyInfo((Element)this.config);
        SearcherPlugin.addInfo((Element)info, null);
        InternalSearcher icon = new InternalSearcher(this.getParent(), this.parentClass, info);
        return icon;
    }

    @Override
    public boolean editInfo() {
        SearchFolderInputDialog dialog = new SearchFolderInputDialog(this.getShell(), 1264);
        dialog.setConfigure(this.config);
        int ret = dialog.open();
        if (ret == 0) {
            this.startSearch(true);
            this.update();
            return true;
        }
        return false;
    }

    public void startSearch(boolean showmessage) {
        String xpath = new XPathCreator().getXPath(this.config);
        SmartIndexerUtils.setDocumentsToTabulator(xpath, Configure.getName((Element)this.config));
        if (showmessage) {
            Shell shell = this.getShell();
            SmartIndexerPlugin.getDefault().showMessage(shell, "Search completed.");
        }
    }
}

