/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.provisional.service.security;

import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventListeners;
import org.eclipse.osgi.framework.eventmgr.EventManager;
import org.eclipse.osgi.framework.eventmgr.ListenerQueue;
import org.eclipse.osgi.internal.provisional.service.security.AuthorizationEvent;
import org.eclipse.osgi.internal.provisional.service.security.AuthorizationListener;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public abstract class AuthorizationEngine {
    private EventManager manager = new EventManager();
    private EventDispatcher dispatcher = new AuthEventDispatcher();
    private final ServiceTracker listenerTracker;

    public AuthorizationEngine(BundleContext context) {
        this.listenerTracker = new ServiceTracker(context, AuthorizationListener.class.getName(), null);
        this.listenerTracker.open();
    }

    public final void authorize(SignedContent content, Object context) {
        this.fireEvent(this.doAuthorize(content, context));
    }

    private void fireEvent(AuthorizationEvent event) {
        if (event == null) {
            return;
        }
        Object[] services = this.listenerTracker.getServices();
        if (services == null) {
            return;
        }
        EventListeners listeners = new EventListeners();
        int i = 0;
        while (i < services.length) {
            listeners.addListener(services[i], null);
            ++i;
        }
        ListenerQueue queue = new ListenerQueue(this.manager);
        queue.queueListeners(listeners, this.dispatcher);
        queue.dispatchEventSynchronous(0, event);
    }

    protected abstract AuthorizationEvent doAuthorize(SignedContent var1, Object var2);

    public abstract int getStatus();

    class AuthEventDispatcher
    implements EventDispatcher {
        AuthEventDispatcher() {
        }

        @Override
        public void dispatchEvent(Object eventListener, Object listenerObject, int eventAction, Object eventObject) {
            ((AuthorizationListener)eventListener).authorizationEvent((AuthorizationEvent)eventObject);
        }
    }
}

