/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.util;

import java.io.File;
import java.io.FileFilter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.WildcardFilter;

public class CCGFileUtils {
    public static boolean copy(File f1, File f2) {
        if (f1.equals(f2)) {
            return true;
        }
        try {
            if (f1.isDirectory()) {
                FileUtils.copyDirectory((File)f1, (File)f2, (boolean)true);
            } else if (f2.isDirectory()) {
                File nf2 = new File(String.valueOf(f2.getAbsolutePath()) + File.separator + f1.getName());
                FileUtils.copyFile((File)f1, (File)nf2, (boolean)true);
            } else {
                FileUtils.copyFile((File)f1, (File)f2, (boolean)true);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean delete(File f) {
        try {
            if (f.isDirectory()) {
                FileUtils.deleteDirectory((File)f);
            } else {
                f.delete();
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean importFile(String originalfile, String importdir, String importname) {
        File f1 = new File(originalfile);
        File f2 = new File(String.valueOf(importdir) + File.separator + importname);
        return CCGFileUtils.copy(f1, f2);
    }

    public static boolean deleteFile(String importdir, long id) {
        File dir = new File(importdir);
        if (!dir.exists()) {
            return true;
        }
        WildcardFilter fileFilter = new WildcardFilter(String.valueOf(id) + ".*");
        File[] files = dir.listFiles((FileFilter)fileFilter);
        int i = 0;
        while (i < files.length) {
            CCGFileUtils.delete(files[i]);
            ++i;
        }
        String path = String.valueOf(importdir) + File.separator + String.valueOf(id);
        File f = new File(path);
        if (f.exists()) {
            CCGFileUtils.delete(f);
        }
        return true;
    }

    public static String findFile(String finddir, String pattern) {
        File dir = new File(finddir);
        WildcardFilter fileFilter = new WildcardFilter(pattern);
        File[] files = dir.listFiles((FileFilter)fileFilter);
        if (files.length == 0) {
            return null;
        }
        return files[0].getAbsolutePath();
    }

    public static String getPathFromID(String importdir, long id) {
        String s = CCGFileUtils.findFile(importdir, String.valueOf(String.valueOf(id)) + "*");
        if (s != null) {
            return s;
        }
        String path = String.valueOf(importdir) + File.separator + String.valueOf(id);
        File f = new File(path);
        return f.exists() ? path : null;
    }

    public static boolean isImage(String filename) {
        String ext = FilenameUtils.getExtension((String)filename);
        return ext.compareToIgnoreCase("gif") == 0 || ext.compareToIgnoreCase("jpg") == 0 || ext.compareToIgnoreCase("jpeg") == 0 || ext.compareToIgnoreCase("png") == 0 || ext.compareToIgnoreCase("bmp") == 0 || ext.compareToIgnoreCase("tif") == 0 || ext.compareToIgnoreCase("tiff") == 0;
    }

    public static boolean isHtml(String filename) {
        String ext = FilenameUtils.getExtension((String)filename);
        return ext.compareToIgnoreCase("htm") == 0 || ext.compareToIgnoreCase("html") == 0 || ext.compareToIgnoreCase("xhtm") == 0 || ext.compareToIgnoreCase("xhtml") == 0;
    }
}

