/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.viewers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public class SelectionProviderMultipleSelectionObservableList
extends WritableList {
    protected ISelectionProvider selectionProvider;
    protected boolean handlingSelection;
    protected boolean updating;
    protected SelectionListener selectionListener = new SelectionListener();

    public SelectionProviderMultipleSelectionObservableList(Realm realm, ISelectionProvider selectionProvider, Object elementType) {
        super(realm, new ArrayList(SelectionProviderMultipleSelectionObservableList.getSelectionList(selectionProvider)), elementType);
        this.selectionProvider = selectionProvider;
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.selectionListener);
    }

    protected void fireListChange(ListDiff diff) {
        if (this.handlingSelection) {
            super.fireListChange(diff);
        } else {
            this.updating = true;
            try {
                List oldList = SelectionProviderMultipleSelectionObservableList.getSelectionList(this.selectionProvider);
                this.selectionProvider.setSelection((ISelection)new StructuredSelection(this.wrappedList));
                this.wrappedList = new ArrayList(SelectionProviderMultipleSelectionObservableList.getSelectionList(this.selectionProvider));
                super.fireListChange(Diffs.computeListDiff((List)oldList, (List)this.wrappedList));
            }
            finally {
                this.updating = false;
            }
        }
    }

    protected static List getSelectionList(ISelectionProvider selectionProvider) {
        if (selectionProvider == null) {
            throw new IllegalArgumentException();
        }
        return SelectionProviderMultipleSelectionObservableList.getSelectionList(selectionProvider.getSelection());
    }

    protected static List getSelectionList(ISelection sel) {
        if (sel instanceof IStructuredSelection) {
            return ((IStructuredSelection)sel).toList();
        }
        return Collections.EMPTY_LIST;
    }

    public synchronized void dispose() {
        this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.selectionListener);
        this.selectionProvider = null;
        super.dispose();
    }

    class SelectionListener
    implements ISelectionChangedListener {
        SelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (SelectionProviderMultipleSelectionObservableList.this.updating) {
                return;
            }
            SelectionProviderMultipleSelectionObservableList.this.handlingSelection = true;
            try {
                SelectionProviderMultipleSelectionObservableList.this.updateWrappedList(new ArrayList(SelectionProviderMultipleSelectionObservableList.getSelectionList(event.getSelection())));
            }
            finally {
                SelectionProviderMultipleSelectionObservableList.this.handlingSelection = false;
            }
        }
    }
}

