/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.labnote;

import java.util.ArrayList;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.plugin.labnote.Category;
import jp.sourceforge.concierge.util.XPathString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryManager {
    private static final String CATEGORYTAG = "category";
    private static final String CATCOLORID = "colorid";
    public static final String UNKNOWNCATEGORY = "<Unknown>";
    private Document document;
    private boolean isnewdoc;

    private ArrayList<Element> getCategoryElement(Document doc) {
        ArrayList celems = DomImpl.getElements((Element)DomImpl.getRootElement((Document)doc), (String)"Category");
        Element celem = (Element)celems.get(0);
        return DomImpl.getElements((Element)celem, (String)CATEGORYTAG);
    }

    private Document getMaxCatDocument(ArrayList<Document> docs) {
        Document lastdoc = docs.get(0);
        int catcnt = this.getCategoryElement(docs.get(0)).size();
        int i = 1;
        while (i < docs.size()) {
            int ccnt = this.getCategoryElement(docs.get(i)).size();
            if (ccnt > catcnt) {
                catcnt = ccnt;
                lastdoc = docs.get(i);
            }
            ++i;
        }
        return lastdoc;
    }

    private ArrayList<Document> getLastModDocuments(ArrayList<Document> docs) {
        ArrayList<Document> lastdocs = new ArrayList<Document>();
        lastdocs.add(docs.get(0));
        long lastmod = DomImpl.getLastModifiedTime((Document)docs.get(0));
        int i = 1;
        while (i < docs.size()) {
            long lm = DomImpl.getLastModifiedTime((Document)docs.get(i));
            if (lm > lastmod) {
                lastmod = lm;
                lastdocs.clear();
                lastdocs.add(docs.get(i));
            } else if (lm == lastmod) {
                lastdocs.add(docs.get(i));
            }
            ++i;
        }
        return lastdocs;
    }

    public void initialize() {
        Request req = new Request(4, (Object)("/ccgconfig[" + XPathString.getAttributeEqualsPredicate((String)"name", (String)"Note") + "]"), "ccgconfig");
        ArrayList docs = FrameworkPlugin.getDocumentsOfQuery((Request)req);
        if (docs == null || docs.size() == 0) {
            this.document = DomImpl.createDocument((String)"ccgconfig");
            Element docnode = DomImpl.getRootElement((Document)this.document);
            DomImpl.setAttribute((Element)docnode, (String)"name", (String)"Note");
            Element celem = DomImpl.appendElement((Element)docnode, (String)"Category");
            Element unknown = DomImpl.appendElement((Element)celem, (String)CATEGORYTAG);
            DomImpl.setElementText((Element)unknown, (String)UNKNOWNCATEGORY);
            unknown.setAttribute(CATCOLORID, "-1");
            this.isnewdoc = true;
        } else {
            ArrayList<Document> lmoddocs = this.getLastModDocuments(docs);
            this.document = this.getMaxCatDocument(lmoddocs);
            this.isnewdoc = false;
        }
    }

    public ArrayList<Category> getCategories() {
        ArrayList<Category> l = new ArrayList<Category>();
        ArrayList celems = DomImpl.getElements((Element)DomImpl.getRootElement((Document)this.document), (String)"Category");
        Element celem = (Element)celems.get(0);
        ArrayList cel = DomImpl.getElements((Element)celem, (String)CATEGORYTAG);
        int i = 0;
        while (i < cel.size()) {
            Element e = (Element)cel.get(i);
            String name = DomImpl.getElementText((Element)e);
            String colorid = DomImpl.getAttribute((Element)e, (String)CATCOLORID);
            int cid = colorid.length() > 0 ? Integer.parseInt(DomImpl.getAttribute((Element)e, (String)CATCOLORID)) : -1;
            l.add(new Category(name, cid));
            ++i;
        }
        return l;
    }

    public void updateCategories(ArrayList<Category> newcats) {
        ArrayList celems = DomImpl.getElements((Element)DomImpl.getRootElement((Document)this.document), (String)"Category");
        Element celem = (Element)celems.get(0);
        DomImpl.removeAllChildren((Element)celem);
        int i = 0;
        while (i < newcats.size()) {
            Category c = newcats.get(i);
            Element newelem = DomImpl.appendElement((Element)celem, (String)CATEGORYTAG);
            DomImpl.setElementText((Element)newelem, (String)c.name);
            DomImpl.setAttribute((Element)newelem, (String)CATCOLORID, (String)String.valueOf(c.colorid));
            ++i;
        }
    }

    public Category getCategoryByName(String name) {
        ArrayList<Category> cats = this.getCategories();
        int i = 0;
        while (i < cats.size()) {
            if (cats.get((int)i).name.equals(name)) {
                return cats.get(i);
            }
            ++i;
        }
        return null;
    }

    public Category getUnkown() {
        ArrayList<Category> cats = this.getCategories();
        int i = 0;
        while (i < cats.size()) {
            if (cats.get((int)i).name.equals(UNKNOWNCATEGORY)) {
                return cats.get(i);
            }
            ++i;
        }
        return null;
    }

    public boolean save() {
        Request r = new Request(this.isnewdoc ? 1 : 3, (Object)this.document, "ccgconfig");
        ArrayList<Request> reqs = new ArrayList<Request>();
        reqs.add(r);
        this.isnewdoc = false;
        return FrameworkPlugin.updateDocuments(reqs, (Object)"jp.sourceforge.concierge.plugin.labnote");
    }

    public static boolean isCategoryDocument(Document doc) {
        String tp = DomImpl.getAttribute((Element)DomImpl.getRootElement((Document)doc), (String)"name");
        return tp.equals("Note");
    }
}

