/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.swt;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.internal.databinding.provisional.swt.AbstractSWTObservableValue;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class TextEditableObservableValue
extends AbstractSWTObservableValue {
    private Text text;

    public TextEditableObservableValue(Text text) {
        super((Widget)text);
        this.text = text;
    }

    public TextEditableObservableValue(Realm realm, Text text) {
        super(realm, (Widget)text);
        this.text = text;
    }

    protected Object doGetValue() {
        return this.text.getEditable() ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object getValueType() {
        return Boolean.TYPE;
    }

    protected void doSetValue(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Parameter value was null.");
        }
        Boolean oldValue = new Boolean(this.text.getEditable());
        Boolean newValue = (Boolean)value;
        this.text.setEditable(newValue.booleanValue());
        if (!oldValue.equals(newValue)) {
            this.fireValueChange(Diffs.createValueDiff((Object)oldValue, (Object)newValue));
        }
    }
}

