/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.XooNIps.Preference;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.mdocument.AccountsDomImpl;
import jp.sourceforge.concierge.plugin.XooNIps.Preference.XooNIpsPlatformData;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XooNIpsPlatformPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TableViewer xooNIpsPlatformTableviewer = null;
    private Text platformName = null;
    private Text url = null;
    private Combo xoonipsVersion = null;
    private Text username = null;
    private Text passwd = null;
    private Button check = null;
    private Button autofill = null;
    private ArrayList<XooNIpsPlatformData> deleteList = null;

    public XooNIpsPlatformPreferencePage() {
        super("XooNIps Platform");
    }

    public void init(IWorkbench workbench) {
    }

    public void dispose() {
        super.dispose();
    }

    public boolean performOk() {
        this.DoSave();
        return super.performOk();
    }

    protected void performDefaults() {
    }

    protected void contributeButtons(Composite parent) {
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.numColumns = 1;
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Button myApplyButton = new Button(parent, 8);
        String[] labels = JFaceResources.getStrings((String[])new String[]{"apply"});
        myApplyButton.setText(labels[0]);
        Dialog.applyDialogFont((Control)myApplyButton);
        GridData data = new GridData(256);
        Point minButtonSize = myApplyButton.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minButtonSize.x);
        myApplyButton.setLayoutData((Object)data);
        myApplyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XooNIpsPlatformPreferencePage.this.performApply();
            }
        });
        myApplyButton.setEnabled(this.isValid());
        this.applyDialogFont(parent);
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        SashForm sf = new SashForm(parent, 512);
        sf.setLayout((Layout)new FillLayout());
        this.createPlatformComposite((Composite)sf);
        this.createAccountComposite((Composite)sf);
        sf.setWeights(new int[]{40, 60});
        sf.setLayoutData((Object)new GridData(1808));
        sf.SASH_WIDTH = 8;
        this.DoOpen();
        this.setCurrentData(null);
        return sf;
    }

    private void createPlatformComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.xooNIpsPlatformTableviewer = new TableViewer(composite, 66308);
        this.xooNIpsPlatformTableviewer.getControl().setLayoutData((Object)new GridData(1808));
        this.xooNIpsPlatformTableviewer.getTable().setLinesVisible(true);
        this.xooNIpsPlatformTableviewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.xooNIpsPlatformTableviewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection == null) {
                    return;
                }
                Object obj = selection.getFirstElement();
                if (obj != null) {
                    XooNIpsPlatformData data = (XooNIpsPlatformData)obj;
                    XooNIpsPlatformPreferencePage.this.setCurrentData(data);
                }
            }
        });
        new TableColumn(this.xooNIpsPlatformTableviewer.getTable(), 16384, 0);
        this.xooNIpsPlatformTableviewer.getControl().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = XooNIpsPlatformPreferencePage.this.xooNIpsPlatformTableviewer.getTable().getClientArea();
                TableColumn[] col = XooNIpsPlatformPreferencePage.this.xooNIpsPlatformTableviewer.getTable().getColumns();
                if (col.length > 0) {
                    col[0].setWidth(r.width);
                }
            }
        });
        Composite rightComposite = new Composite(composite, 0);
        rightComposite.setLayout((Layout)new GridLayout(1, false));
        rightComposite.setLayoutData((Object)new GridData(1040));
        Button loadButton = new Button(rightComposite, 8);
        loadButton.setText("load");
        loadButton.setLayoutData((Object)new GridData(768));
        loadButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ArrayList list = XooNIpsPlatformPreferencePage.this.LoadXooNIpsPlatforms();
                if (list != null) {
                    int i = 0;
                    while (i < list.size()) {
                        XooNIpsPlatformData srcData = (XooNIpsPlatformData)list.get(i);
                        boolean exist = false;
                        int j = 0;
                        while (j < XooNIpsPlatformPreferencePage.this.xooNIpsPlatformTableviewer.getTable().getItemCount()) {
                            XooNIpsPlatformData dstData = (XooNIpsPlatformData)XooNIpsPlatformPreferencePage.this.xooNIpsPlatformTableviewer.getElementAt(j);
                            if (dstData.getURL().equalsIgnoreCase(srcData.getURL())) {
                                exist = true;
                                break;
                            }
                            ++j;
                        }
                        if (!exist) {
                            XooNIpsPlatformPreferencePage.this.xooNIpsPlatformTableviewer.add((Object)srcData);
                        }
                        ++i;
                    }
                }
            }
        });
        Button newButton = new Button(rightComposite, 8);
        newButton.setText("new");
        newButton.setLayoutData((Object)new GridData(768));
        newButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                InputPlatformDialog dlg = new InputPlatformDialog(XooNIpsPlatformPreferencePage.this.xooNIpsPlatformTableviewer.getTable().getShell(), "", "");
                if (dlg.open() == 0) {
                    XooNIpsPlatformData data = new XooNIpsPlatformData();
                    data.setPlatformName(dlg.getName());
                    data.setURL(dlg.getUrl());
                    XooNIpsPlatformPreferencePage.this.xooNIpsPlatformTableviewer.add((Object)data);
                    XooNIpsPlatformPreferencePage.this.xooNIpsPlatformTableviewer.reveal((Object)data);
                    XooNIpsPlatformPreferencePage.this.xooNIpsPlatformTableviewer.getTable().select(XooNIpsPlatformPreferencePage.this.xooNIpsPlatformTableviewer.getTable().getItemCount() - 1);
                    XooNIpsPlatformPreferencePage.this.setCurrentData(data);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button delButton = new Button(rightComposite, 8);
        delButton.setText("delete");
        delButton.setLayoutData((Object)new GridData(768));
        delButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)XooNIpsPlatformPreferencePage.this.xooNIpsPlatformTableviewer.getSelection();
                if (selection == null) {
                    return;
                }
                Object obj = selection.getFirstElement();
                if (obj != null) {
                    XooNIpsPlatformData data = (XooNIpsPlatformData)obj;
                    if (XooNIpsPlatformPreferencePage.this.deleteList == null) {
                        XooNIpsPlatformPreferencePage.this.deleteList = new ArrayList();
                    }
                    if (data.getSTATUS() != 3) {
                        data.setSTATUS(2);
                        XooNIpsPlatformPreferencePage.this.deleteList.add(data);
                    }
                    XooNIpsPlatformPreferencePage.this.xooNIpsPlatformTableviewer.remove((Object)data);
                }
                obj = null;
                XooNIpsPlatformPreferencePage.this.setCurrentData(null);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createAccountComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText("Platform Name:");
        this.platformName = new Text(composite, 2048);
        this.platformName.setLayoutData((Object)new GridData(768));
        this.platformName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.getSource();
                IStructuredSelection selection = (IStructuredSelection)XooNIpsPlatformPreferencePage.this.xooNIpsPlatformTableviewer.getSelection();
                if (selection == null) {
                    return;
                }
                Object obj = selection.getFirstElement();
                if (obj != null) {
                    XooNIpsPlatformData data = (XooNIpsPlatformData)obj;
                    data.setPlatformName(text.getText());
                    XooNIpsPlatformPreferencePage.this.xooNIpsPlatformTableviewer.refresh((Object)data);
                }
            }
        });
        Label urlLabel = new Label(composite, 0);
        urlLabel.setText("URL:");
        this.url = new Text(composite, 2048);
        this.url.setLayoutData((Object)new GridData(768));
        this.url.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.getSource();
                IStructuredSelection selection = (IStructuredSelection)XooNIpsPlatformPreferencePage.this.xooNIpsPlatformTableviewer.getSelection();
                if (selection == null) {
                    return;
                }
                Object obj = selection.getFirstElement();
                if (obj != null) {
                    XooNIpsPlatformData data = (XooNIpsPlatformData)obj;
                    data.setURL(text.getText());
                }
            }
        });
        Label versionLabel = new Label(composite, 0);
        versionLabel.setText("Version:");
        this.xoonipsVersion = new Combo(composite, 8);
        this.xoonipsVersion.add("3.3");
        this.xoonipsVersion.add("3.4");
        this.xoonipsVersion.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)XooNIpsPlatformPreferencePage.this.xooNIpsPlatformTableviewer.getSelection();
                if (selection == null) {
                    return;
                }
                Object obj = selection.getFirstElement();
                if (obj != null) {
                    XooNIpsPlatformData data = (XooNIpsPlatformData)obj;
                    if (((Combo)e.getSource()).getSelectionIndex() == 0) {
                        data.setVersion("3.3");
                    } else if (((Combo)e.getSource()).getSelectionIndex() == 1) {
                        data.setVersion("3.4");
                    }
                }
            }
        });
        Group accountGr = new Group(composite, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        accountGr.setLayoutData((Object)gd);
        accountGr.setLayout((Layout)new GridLayout(2, false));
        Label usernameLabel = new Label((Composite)accountGr, 0);
        usernameLabel.setText("ID:");
        this.username = new Text((Composite)accountGr, 2048);
        this.username.setLayoutData((Object)new GridData(768));
        this.username.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.getSource();
                IStructuredSelection selection = (IStructuredSelection)XooNIpsPlatformPreferencePage.this.xooNIpsPlatformTableviewer.getSelection();
                if (selection == null) {
                    return;
                }
                Object obj = selection.getFirstElement();
                if (obj != null) {
                    XooNIpsPlatformData data = (XooNIpsPlatformData)obj;
                    data.setUserName(text.getText());
                }
            }
        });
        Label passwdLabel = new Label((Composite)accountGr, 0);
        passwdLabel.setText("Password:");
        this.passwd = new Text((Composite)accountGr, 2048);
        this.passwd.setEchoChar('*');
        this.passwd.setLayoutData((Object)new GridData(768));
        this.passwd.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.getSource();
                IStructuredSelection selection = (IStructuredSelection)XooNIpsPlatformPreferencePage.this.xooNIpsPlatformTableviewer.getSelection();
                if (selection == null) {
                    return;
                }
                Object obj = selection.getFirstElement();
                if (obj != null) {
                    XooNIpsPlatformData data = (XooNIpsPlatformData)obj;
                    data.setPasswd(text.getText());
                }
            }
        });
        this.check = new Button((Composite)accountGr, 32);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.check.setLayoutData((Object)gd);
        this.check.setText("Show Password");
        this.check.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (XooNIpsPlatformPreferencePage.this.check.getSelection()) {
                    XooNIpsPlatformPreferencePage.this.passwd.setEchoChar('\u0000');
                } else {
                    XooNIpsPlatformPreferencePage.this.passwd.setEchoChar('*');
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.autofill = new Button((Composite)accountGr, 32);
        this.autofill.setSelection(false);
        this.autofill.setText("AutoFill");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.autofill.setLayoutData((Object)gd);
        this.autofill.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                IStructuredSelection selection = (IStructuredSelection)XooNIpsPlatformPreferencePage.this.xooNIpsPlatformTableviewer.getSelection();
                if (selection == null) {
                    return;
                }
                Object obj = selection.getFirstElement();
                if (obj != null) {
                    XooNIpsPlatformData data = (XooNIpsPlatformData)obj;
                    data.setAutoFill(button.getSelection());
                }
            }
        });
    }

    private void setCurrentData(XooNIpsPlatformData data) {
        if (data != null) {
            this.allEnabled(this.platformName.getParent(), true, this.platformName.getParent().getDisplay().getSystemColor(2));
            this.platformName.setText(data.getPlatformName());
            this.url.setText(data.getURL());
            this.username.setText(data.getUserName());
            this.passwd.setText(data.getPasswd());
            this.autofill.setSelection(data.isAutoFill());
            if (data.getVersion().equals("3.3")) {
                this.xoonipsVersion.select(0);
            } else if (data.getVersion().equals("3.4")) {
                this.xoonipsVersion.select(1);
            } else {
                this.xoonipsVersion.deselectAll();
            }
        } else {
            this.allEnabled(this.platformName.getParent(), false, this.platformName.getParent().getDisplay().getSystemColor(15));
            this.xoonipsVersion.deselectAll();
        }
    }

    private void allEnabled(Composite parent, boolean enabled, Color color) {
        Control[] controls = parent.getChildren();
        int i = 0;
        while (i < controls.length) {
            if (controls[i] instanceof Composite) {
                this.allEnabled((Composite)controls[i], enabled, color);
            } else if (controls[i] instanceof Text) {
                Text txt;
                if (!enabled && (txt = (Text)controls[i]).getText().length() > 0) {
                    txt.setText("");
                }
            } else if (controls[i] instanceof Button) {
                if (!enabled) {
                    Button button = (Button)controls[i];
                    button.setSelection(false);
                }
            } else if (controls[i] instanceof Label) {
                controls[i].setForeground(color);
            }
            controls[i].setEnabled(enabled);
            ++i;
        }
    }

    private void DoSave() {
        ArrayList<Request> reqs = new ArrayList<Request>();
        ArrayList<Document> addDocs = new ArrayList<Document>();
        ArrayList<Document> updDocs = new ArrayList<Document>();
        int j = 0;
        while (j < this.xooNIpsPlatformTableviewer.getTable().getItemCount()) {
            XooNIpsPlatformData data = (XooNIpsPlatformData)this.xooNIpsPlatformTableviewer.getElementAt(j);
            if (data.getSTATUS() == 3) {
                addDocs.add(data.getDoc(true));
                data.setSTATUS(0);
            } else if (data.getSTATUS() == 1) {
                updDocs.add(data.getDoc(true));
                data.setSTATUS(0);
            }
            ++j;
        }
        if (addDocs.size() > 0) {
            reqs.add(new Request(1, addDocs, "account"));
        }
        if (updDocs.size() > 0) {
            reqs.add(new Request(3, updDocs, "account"));
        }
        ArrayList<Document> delDocs = new ArrayList<Document>();
        if (this.deleteList != null && this.deleteList.size() > 0) {
            int i = 0;
            while (i < this.deleteList.size()) {
                XooNIpsPlatformData data = this.deleteList.get(i);
                delDocs.add(data.getDoc(false));
                ++i;
            }
            this.deleteList.clear();
        }
        if (delDocs.size() > 0) {
            reqs.add(new Request(2, delDocs, "account"));
        }
        if (reqs.size() > 0) {
            FrameworkPlugin.updateDocuments(reqs, (boolean)true, (Object)"jp.sourceforge.concierge.plugin.XooNIps.Preference.XooNIpsPlatformPreferencePage");
        }
        reqs.clear();
        reqs = null;
    }

    private void DoOpen() {
        ArrayList al = AccountsDomImpl.getAccountDocuments((String)"xoonipsplatform");
        int i = 0;
        while (i < al.size()) {
            Document doc = (Document)al.get(i);
            XooNIpsPlatformData data = new XooNIpsPlatformData(doc);
            this.xooNIpsPlatformTableviewer.add((Object)data);
            ++i;
        }
    }

    private ArrayList<XooNIpsPlatformData> LoadXooNIpsPlatforms() {
        try {
            URL url = null;
            url = new URL("http://www.neuroinf.jp/modules/platforms/?mode=opml&ml_lang=en");
            InputStream is = url.openStream();
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setValidating(true);
            SAXParser saxParser = saxParserFactory.newSAXParser();
            InputSource inputSource = new InputSource(is);
            XooNIpsPlatformsSAX xs = new XooNIpsPlatformsSAX();
            saxParser.parse(inputSource, (DefaultHandler)xs);
            is.close();
            return xs.getPlatformList();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return null;
        }
    }

    public class InputPlatformDialog
    extends Dialog {
        private Text nameText;
        private Text urlText;
        private String name;
        private String url;

        protected InputPlatformDialog(Shell parentShell, String name, String url) {
            super(parentShell);
            this.nameText = null;
            this.urlText = null;
            this.name = null;
            this.url = null;
            this.name = name != null ? name : "";
            this.url = url != null ? url : "";
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        protected Point getInitialSize() {
            return new Point(480, 180);
        }

        protected Control createDialogArea(Composite parent) {
            parent.setLayout((Layout)new GridLayout(1, false));
            Composite composite = (Composite)super.createDialogArea(parent);
            composite.setLayout((Layout)new GridLayout(2, false));
            GridData gd = new GridData(1808);
            composite.setLayoutData((Object)gd);
            Label label1 = new Label(composite, 131072);
            label1.setText("Platform Name:");
            this.nameText = new Text(composite, 2048);
            this.nameText.setLayoutData((Object)new GridData(768));
            if (this.name != null) {
                this.nameText.setText(this.name);
            }
            Label label2 = new Label(composite, 131072);
            label2.setText("URL:");
            this.urlText = new Text(composite, 2048);
            this.urlText.setLayoutData((Object)new GridData(768));
            if (this.url != null) {
                this.urlText.setText(this.url);
            }
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 0) {
                if (this.nameText.getText().length() <= 0) {
                    this.nameText.setText(this.name);
                    return;
                }
                this.name = this.nameText.getText();
                if (this.urlText.getText().length() > 0) {
                    this.url = this.urlText.getText();
                } else {
                    this.urlText.setText(this.url);
                    return;
                }
            }
            this.setReturnCode(buttonId);
            this.close();
            super.buttonPressed(buttonId);
        }
    }

    private class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof XooNIpsPlatformData) {
                return ((XooNIpsPlatformData)obj).getPlatformName();
            }
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }

        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class XooNIpsPlatformsSAX
    extends DefaultHandler {
        private ArrayList<XooNIpsPlatformData> list = null;

        @Override
        public void startDocument() {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            if (qName.equals("outline")) {
                String isComment = atts.getValue("isComment");
                if (isComment != null && isComment.equals("true")) {
                    return;
                }
                String system = atts.getValue("system");
                if (system != null && system.startsWith("xoonips")) {
                    String text = atts.getValue("text");
                    String url = atts.getValue("url");
                    String banner = atts.getValue("banner");
                    String description = atts.getValue("description");
                    if (text == null) {
                        text = "";
                    }
                    if (url == null) {
                        url = "";
                    }
                    XooNIpsPlatformData data = new XooNIpsPlatformData();
                    data.setPlatformName(text);
                    data.setURL(url);
                    if (system.startsWith("xoonips-3.3")) {
                        data.setVersion("3.3");
                    } else if (system.startsWith("xoonips 3.3")) {
                        data.setVersion("3.3");
                    } else if (system.startsWith("xoonips-3.4")) {
                        data.setVersion("3.4");
                    }
                    data.setBanner(banner);
                    data.setDescription(description);
                    if (this.list == null) {
                        this.list = new ArrayList();
                    }
                    this.list.add(data);
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) {
        }

        @Override
        public void endDocument() {
        }

        public ArrayList<XooNIpsPlatformData> getPlatformList() {
            return this.list;
        }
    }
}

