/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin;

import java.net.URL;
import jp.sourceforge.concierge.editor.EditorDelegate;
import jp.sourceforge.concierge.editor.IConciergeDialogArea;
import jp.sourceforge.concierge.editor.IEditorPlugin;
import jp.sourceforge.concierge.framework.AbstractDocumentUIPlugin;
import jp.sourceforge.concierge.plugin.ipapers.PaperDialogArea;
import jp.sourceforge.concierge.plugin.ipapers.search.pubmed.PubMedCore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class IPapersPlugin
extends AbstractDocumentUIPlugin
implements IEditorPlugin {
    public static final Log log = LogFactory.getLog((String)"IPapersPlugin");
    public static final String IMG_UNREAD = "unread";
    public static final String IMG_CONCIERGE = "concierge";
    public static final String IMG_PDF = "icon_pdf16";
    private static IPapersPlugin plugin;
    public static final String P_IPAPERS_DB_FOLDER = "ipapers";
    public static final String P_IPAPERS_RETMAX_FROM_PUBMED = "maximul retrieved";
    public static final String P_IPAPERS_VIEW_ORIENTATION_HORIZONTAL = "orientation horizontal";
    public static final String P_IPAPERS_SUPPRESS_PROGRESS_DIALOG = "suppres dialog";
    public static final String P_IPAPERS_LANGUAGE_PUBMED = "language";
    public static final String P_IPAPERS_LANGUAGE_ENGLISH_PUBMED = "English";
    public static final String P_IPAPERS_LANGUAGE_FRENCH_PUBMED = "French";
    public static final String P_IPAPERS_LANGUAGE_GERMAN_PUBMED = "German";
    public static final String P_IPAPERS_LANGUAGE_LTALIAN_PUBMED = "Italian";
    public static final String P_IPAPERS_LANGUAGE_JAPANESE_PUBMED = "Japanese";
    public static final String P_IPAPERS_LANGUAGE_RUSSIAN_PUBMED = "Russian";
    public static final String P_IPAPERS_LANGUAGE_SPANISH_PUBMED = "Spanish";

    public IPapersPlugin() throws Exception {
        plugin = this;
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        this.registerImage(registry, IMG_UNREAD, "unread.png");
        this.registerImage(registry, IMG_CONCIERGE, "concierge.png");
        this.registerImage(registry, IMG_PDF, "icon_pdf16.gif");
    }

    private void registerImage(ImageRegistry registry, String key, String fileName) {
        try {
            Path path = new Path("icons" + System.getProperty("file.separator") + fileName);
            URL url = this.find((IPath)path);
            if (url != null) {
                ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
                registry.put(key, desc);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Job job = new Job("PubMed Search "){
            PubMedCore pubmedSearch;
            {
                this.pubmedSearch = new PubMedCore();
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    this.pubmedSearch.search("");
                    return Status.OK_STATUS;
                }
                catch (Exception exception) {
                    return Status.CANCEL_STATUS;
                }
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK() && log.isInfoEnabled()) {
                    log.info((Object)"load PubMedCore done");
                }
            }
        });
        job.setUser(false);
        job.schedule();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static IPapersPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"jp.sourceforge.concierge.plugin.ipapers", (String)path);
    }

    public static String getPluginFilePath(String path) {
        return plugin.getFilePath(path);
    }

    public EditorDelegate getDelegate() {
        return null;
    }

    public IConciergeDialogArea getDialogArea() {
        return new PaperDialogArea();
    }
}

