/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.ipapers;

import java.util.Hashtable;
import jp.sourceforge.concierge.plugin.ipapers.CacheDB;
import jp.sourceforge.concierge.plugin.ipapers.CannotGetPaperInfoException;
import jp.sourceforge.concierge.plugin.ipapers.PaperInfo;
import jp.sourceforge.concierge.plugin.ipapers.PaperInfoFactory;
import jp.sourceforge.concierge.plugin.ipapers.URLInfoFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Paper
implements Cloneable {
    private String id;
    private String idType;
    private PaperInfo info;
    private String url;
    private static PaperInfoFactory paperInfoFactory = PaperInfoFactory.getInstance();
    private static URLInfoFactory urlInfoFactory = URLInfoFactory.getInstance();
    public static final int ARTICLE_UNREAD = 0;
    public static final int ARTICLE_READ = 1;
    public static final int ARTICLE_CONCIERGE = 2;
    public static final int ARTICLE_PDF = 4;

    public Paper(String id, String idType) {
        this.id = id;
        this.idType = idType;
        this.info = null;
        this.url = null;
    }

    public Paper(String id, String idType, PaperInfo info) {
        this.id = id;
        this.idType = idType;
        this.info = info;
        this.url = null;
    }

    public String getId() {
        return this.id;
    }

    public String getIdType() {
        return this.idType;
    }

    public PaperInfo getPaperInfo() throws CannotGetPaperInfoException {
        if (this.info == null) {
            this.info = paperInfoFactory.create(this.id, this.idType);
        }
        return this.info;
    }

    public PaperInfo getPaperInfoNotDownload() {
        return this.info;
    }

    public String getURL() {
        if (this.url == null) {
            this.url = urlInfoFactory.create(this.id, this.idType);
        }
        return this.url;
    }

    public void setFlag(int flag) {
        if (flag != this.info.getFlag()) {
            this.info.setFlag(flag);
            CacheDB.getInstance().setFlag(this.id, this.idType, flag);
        }
    }

    public int getFlag() {
        return this.info.getFlag();
    }

    public Hashtable<String, String> toHashtable() throws CannotGetPaperInfoException {
        Hashtable<String, String> items = new Hashtable<String, String>();
        items.put("Year", this.getPaperInfo().getYear());
        items.put("IDs", this.info.getFormattedIDs());
        items.put("Author", this.info.getAuthor());
        items.put("Abstract", this.info.getAbstract());
        items.put("Number", this.info.getIssue());
        items.put("URL", this.getURL());
        items.put("Volume", this.info.getVolume());
        items.put("Journal", this.info.getJournal());
        items.put("Title", this.info.getTitle());
        items.put("Pages", this.info.getPages());
        return items;
    }

    public boolean equals(Object obj) {
        Paper paper;
        if (this == obj) {
            return true;
        }
        return obj != null && this.getClass() == obj.getClass() && this.id.equals((paper = (Paper)obj).getId()) && this.idType.equals(paper.getIdType());
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        return String.valueOf(this.id) + " " + this.idType;
    }
}

