/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.parser;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.parser.ITypeParser;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateParser
implements ITypeParser {
    private static final String PARSERNS = "http://concierge.sourceforge.jp/ns/date";
    private static final String PARSERNSPREFIX = "date";
    private static final String ELEMENTTAGNAME = "body";
    private static final String MESSAGE = "YYYY-MM-DDThh:mm:ss, e.g. \"2007-01-01T12:34:56\", \"2007-02-03\", \"2003\", etc.";

    @Override
    public String getParserNS() {
        return PARSERNS;
    }

    @Override
    public String getParserNSPrefix() {
        return PARSERNSPREFIX;
    }

    @Override
    public String getSingleText(Element data) {
        String strBuf = "";
        ArrayList<Element> elems = DataDomImpl.getElements(data, ELEMENTTAGNAME, PARSERNSPREFIX);
        int i = 0;
        while (i < elems.size()) {
            Element e;
            String dateString;
            String showString;
            if (i > 0) {
                strBuf = String.valueOf(strBuf) + ",";
            }
            if ((showString = this.getSingleText(dateString = DomImpl.getElementText(e = elems.get(i)))) != null && showString.length() > 0) {
                strBuf = String.valueOf(strBuf) + showString;
            } else if (dateString != null) {
                strBuf = String.valueOf(strBuf) + dateString;
            }
            ++i;
        }
        return strBuf;
    }

    private String getSingleText(String dateString) {
        String showString = null;
        Date theDate = null;
        if (dateString != null && showString == null && (theDate = this.getDateFromDateTimeFormat(dateString)) != null) {
            try {
                SimpleDateFormat mf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                showString = mf.format(theDate);
                return showString;
            }
            catch (Exception exception) {
                showString = null;
            }
        }
        if (dateString != null && (theDate = this.getDateFromDateFormat(dateString)) != null) {
            try {
                SimpleDateFormat mf = new SimpleDateFormat("yyyy-MM-dd");
                showString = mf.format(theDate);
                return showString;
            }
            catch (Exception exception) {
                showString = null;
            }
        }
        if (dateString != null && (theDate = this.getDateFromYearFormat(dateString)) != null) {
            try {
                SimpleDateFormat mf = new SimpleDateFormat("yyyy");
                showString = mf.format(theDate);
                return showString;
            }
            catch (Exception exception) {
                showString = null;
            }
        }
        return showString;
    }

    @Override
    public ArrayList<String> getMultiText(Element elem) {
        ArrayList<String> al = new ArrayList<String>();
        ArrayList<Element> elems = DomImpl.getElements(elem, ELEMENTTAGNAME, PARSERNSPREFIX);
        int i = 0;
        while (i < elems.size()) {
            Element e = elems.get(i);
            String dateString = DomImpl.getElementText(e);
            try {
                String showString = this.getSingleText(dateString);
                if (showString != null && showString.length() > 0) {
                    al.add(showString);
                } else if (dateString != null && dateString.length() > 0) {
                    al.add(dateString);
                }
            }
            catch (Exception exception) {}
            ++i;
        }
        return al;
    }

    @Override
    public ArrayList<String> getIndexValues(Element elem, String abc) {
        ArrayList<String> al = new ArrayList<String>();
        ArrayList<Element> elems = DomImpl.getElements(elem, ELEMENTTAGNAME, PARSERNSPREFIX);
        int i = 0;
        while (i < elems.size()) {
            Element e = elems.get(i);
            String dateString = DomImpl.getElementText(e);
            try {
                String showString = this.getSingleText(dateString);
                if (showString != null && showString.length() > 0) {
                    if (abc != null) {
                        if (showString.substring(0, abc.length()).compareToIgnoreCase(abc) == 0) {
                            al.add(showString);
                        }
                    } else {
                        al.add(showString);
                    }
                } else if (dateString != null && dateString.length() > 0) {
                    if (abc != null) {
                        if (dateString.substring(0, abc.length()).compareToIgnoreCase(abc) == 0) {
                            al.add(dateString);
                        }
                    } else {
                        al.add(dateString);
                    }
                }
            }
            catch (Exception exception) {}
            ++i;
        }
        return al;
    }

    @Override
    public ArrayList<String> getIndexABC(Element elem) {
        ArrayList<String> al = new ArrayList<String>();
        ArrayList<Element> elems = DomImpl.getElements(elem, ELEMENTTAGNAME, PARSERNSPREFIX);
        int i = 0;
        while (i < elems.size()) {
            Element e = elems.get(i);
            String dateString = DomImpl.getElementText(e);
            try {
                SimpleDateFormat mf = new SimpleDateFormat("yyyy");
                String showString = mf.format(dateString);
                if (showString != null && showString.length() > 0) {
                    al.add(showString);
                }
            }
            catch (Exception exception) {}
            ++i;
        }
        return al;
    }

    @Override
    public void putToElement(Element data, String str) {
        String dateString;
        if (str != null && (dateString = this.makeDateString(str)) != null) {
            DomImpl.removeAllChildren(data);
            Element elem = DomImpl.appendElement(data, ELEMENTTAGNAME, PARSERNSPREFIX);
            DomImpl.setElementText(elem, dateString.trim());
        }
    }

    @Override
    public String getMessage() {
        return MESSAGE;
    }

    protected String makeDateString(String srcStr) {
        StringBuffer strDateBuf = new StringBuffer();
        StringBuffer strTimeBuf = new StringBuffer();
        if (srcStr != null && srcStr.length() > 0) {
            int number;
            String[] YearAndDay = srcStr.split("T");
            if (YearAndDay.length > 0) {
                String yyyy = "";
                String MM = "";
                String dd = "";
                if (YearAndDay[0].length() > 0) {
                    String[] yyyyMMdd = YearAndDay[0].split("-");
                    try {
                        if (yyyyMMdd.length > 0) {
                            number = Integer.valueOf(yyyyMMdd[0]);
                            yyyy = String.valueOf(number);
                        }
                        if (yyyyMMdd.length > 1) {
                            number = Integer.valueOf(yyyyMMdd[1]);
                            if (number < 1) {
                                number = 1;
                            }
                            if (number > 12) {
                                number = 12;
                            }
                            if ((MM = String.valueOf(number)).length() == 1) {
                                MM = "0" + MM;
                            }
                        }
                        if (yyyyMMdd.length > 2) {
                            number = Integer.valueOf(yyyyMMdd[2]);
                            if (number < 1) {
                                number = 1;
                            }
                            if (number > 31) {
                                number = 31;
                            }
                            if ((dd = String.valueOf(number)).length() == 1) {
                                dd = "0" + dd;
                            }
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                    if (yyyy.length() > 0) {
                        strDateBuf.append(yyyy);
                    } else {
                        strDateBuf.append("1");
                    }
                    strDateBuf.append("-");
                    if (MM.length() > 0) {
                        strDateBuf.append(MM);
                    } else {
                        strDateBuf.append("1");
                    }
                    strDateBuf.append("-");
                    if (dd.length() > 0) {
                        strDateBuf.append(dd);
                    } else {
                        strDateBuf.append("1");
                    }
                }
            }
            if (YearAndDay.length > 1) {
                String HH = "";
                String mm = "";
                String ss = "";
                if (YearAndDay[1].length() > 0) {
                    String[] HHmmss = YearAndDay[1].split(":");
                    try {
                        if (HHmmss.length > 0) {
                            number = Integer.valueOf(HHmmss[0]);
                            if (number == 24) {
                                number = 0;
                            }
                            if (number < 0) {
                                number = 0;
                            }
                            if (number > 23) {
                                number = 23;
                            }
                            if ((HH = String.valueOf(number)).length() == 1) {
                                HH = "0" + HH;
                            }
                        }
                        if (HHmmss.length > 1) {
                            number = Integer.valueOf(HHmmss[1]);
                            if (number == 60) {
                                number = 0;
                            }
                            if (number < 0) {
                                number = 0;
                            }
                            if (number > 59) {
                                number = 59;
                            }
                            if ((mm = String.valueOf(number)).length() == 1) {
                                mm = "0" + mm;
                            }
                        }
                        if (HHmmss.length > 2) {
                            number = Integer.valueOf(HHmmss[2]);
                            if (number == 60) {
                                number = 0;
                            }
                            if (number < 0) {
                                number = 0;
                            }
                            if (number > 59) {
                                number = 59;
                            }
                            if ((ss = String.valueOf(number)).length() == 1) {
                                ss = "0" + ss;
                            }
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                    if (HH.length() > 0) {
                        strTimeBuf.append(HH);
                    } else {
                        strTimeBuf.append("0");
                    }
                    strTimeBuf.append(":");
                    if (mm.length() > 0) {
                        strTimeBuf.append(mm);
                    } else {
                        strTimeBuf.append("0");
                    }
                    strTimeBuf.append(":");
                    if (ss.length() > 0) {
                        strTimeBuf.append(ss);
                    } else {
                        strTimeBuf.append("0");
                    }
                }
            }
        }
        if (strTimeBuf.length() > 0) {
            strDateBuf.append("T");
            strDateBuf.append(strTimeBuf);
        }
        return new String(strDateBuf);
    }

    private Date getDateFromDateTimeFormat(String str) {
        if (str != null) {
            try {
                SimpleDateFormat myformat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                Date theDay = myformat.parse(str);
                return theDay;
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private Date getDateFromDateFormat(String str) {
        if (str != null) {
            try {
                SimpleDateFormat myformat = new SimpleDateFormat("yyyy-MM-dd");
                Date theDay = myformat.parse(str);
                return theDay;
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private Date getDateFromYearFormat(String str) {
        if (str != null) {
            try {
                SimpleDateFormat myformat = new SimpleDateFormat("yyyy");
                Date theDay = myformat.parse(str);
                return theDay;
            }
            catch (Exception exception) {}
        }
        return null;
    }
}

