/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.parser;

import java.util.ArrayList;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.parser.ITypeParser;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextParser
implements ITypeParser {
    private static String NAMESPACE = "http://concierge.sourceforge.jp/ns/text";
    private static String PREFIX = "txt";
    private static String TAGNAME = "body";
    private static String MESSAGE = "";

    @Override
    public String getParserNS() {
        return NAMESPACE;
    }

    @Override
    public String getParserNSPrefix() {
        return PREFIX;
    }

    @Override
    public String getSingleText(Element data) {
        ArrayList<Element> in = DataDomImpl.getElements(data, TAGNAME, PREFIX);
        String out = "";
        if (in.size() > 0) {
            Element e = in.get(0);
            out = DataDomImpl.getElementText(e);
        }
        return out;
    }

    @Override
    public ArrayList<String> getMultiText(Element data) {
        Element e;
        String str;
        ArrayList<Element> in = DataDomImpl.getElements(data, TAGNAME, PREFIX);
        ArrayList<String> out = new ArrayList<String>();
        if (in.size() > 0 && (str = DataDomImpl.getElementText(e = in.get(0))).trim().length() > 0) {
            out.add(str);
        }
        return out;
    }

    @Override
    public ArrayList<String> getIndexValues(Element data, String abc) {
        Element e;
        String str;
        ArrayList<Element> in = DataDomImpl.getElements(data, TAGNAME, PREFIX);
        ArrayList<String> out = new ArrayList<String>();
        if (in.size() > 0 && (str = DataDomImpl.getElementText(e = in.get(0))).trim().length() > 0) {
            if (abc != null) {
                if (str.substring(0, abc.length()).compareToIgnoreCase(abc) == 0) {
                    out.add(str);
                }
            } else {
                out.add(str);
            }
        }
        return out;
    }

    @Override
    public ArrayList<String> getIndexABC(Element data) {
        Element e;
        String str;
        ArrayList<Element> in = DataDomImpl.getElements(data, TAGNAME, PREFIX);
        ArrayList<String> out = new ArrayList<String>();
        if (in.size() > 0 && (str = DataDomImpl.getElementText(e = in.get(0))).trim().length() > 0) {
            String abc = str.substring(0, 1).toUpperCase();
            out.add(abc);
        }
        return out;
    }

    @Override
    public void putToElement(Element data, String str) {
        if (str != null) {
            DataDomImpl.removeAllChildren(data);
            Element e = DataDomImpl.appendElement(data, TAGNAME, PREFIX);
            DataDomImpl.setElementText(e, str.trim());
        }
    }

    @Override
    public String getMessage() {
        return MESSAGE;
    }
}

