/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.filters;

import com.lowagie.text.Document;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStream;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import jp.sourceforge.concierge.plugin.IFileFilter;
import jp.sourceforge.concierge.plugin.filters.ImageUtils;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.PlatformUI;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.util.PDFTextStripper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfFilter
implements IFileFilter {
    private PdfReader reader;
    private String filename;

    public PdfFilter(String filename) throws Exception {
        this.reader = new PdfReader(filename);
        this.filename = filename;
    }

    @Override
    public String[] getDataNames() {
        return new String[]{"Title", "Author", "Subject", "Keywords", "Creator", "Producer", "Creation Date", "Modification Date"};
    }

    @Override
    public String getData(String name) {
        HashMap map = this.reader.getInfo();
        return (String)map.get(name);
    }

    private boolean isJpeg(PdfObject img) {
        if (img instanceof PRIndirectReference) {
            try {
                Image image = Image.getInstance((PRIndirectReference)((PRIndirectReference)img));
                return image.isJpeg();
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (img instanceof PRStream) {
            PdfName nm = ((PRStream)img).getAsName(PdfName.FILTER);
            return nm != null && nm.toString().equals(PdfName.DCTDECODE.toString());
        }
        return false;
    }

    @Override
    public ArrayList<org.eclipse.swt.graphics.Image> getImages() {
        ArrayList<org.eclipse.swt.graphics.Image> imgs = new ArrayList<org.eclipse.swt.graphics.Image>();
        int i = 0;
        while (i < this.reader.getXrefSize()) {
            PdfStream pdfdict;
            PdfObject pdfsubtype;
            PdfObject pdfobj = this.reader.getPdfObject(i);
            if (pdfobj != null && pdfobj.isStream() && (pdfsubtype = (pdfdict = (PdfStream)pdfobj).get(PdfName.SUBTYPE)) != null && pdfsubtype.toString().equals(PdfName.IMAGE.toString())) {
                org.eclipse.swt.graphics.Image ii = null;
                try {
                    if (this.isJpeg((PdfObject)pdfdict)) {
                        ii = new org.eclipse.swt.graphics.Image((Device)PlatformUI.getWorkbench().getDisplay(), (InputStream)new ByteArrayInputStream(PdfReader.getStreamBytesRaw((PRStream)((PRStream)pdfdict))));
                    } else {
                        int width = pdfdict.getAsNumber(PdfName.WIDTH).intValue();
                        int height = pdfdict.getAsNumber(PdfName.HEIGHT).intValue();
                        int bpc = pdfdict.getAsNumber(PdfName.BITSPERCOMPONENT).intValue();
                        PaletteData pd = null;
                        switch (bpc) {
                            case 1: {
                                pd = new PaletteData(new RGB[]{new RGB(255, 255, 255), new RGB(0, 0, 0)});
                                break;
                            }
                            case 8: {
                                PdfObject cs = pdfdict.get(PdfName.COLORSPACE);
                                if (cs.isArray()) {
                                    PdfArray arr = (PdfArray)cs;
                                    PdfObject ind = PdfReader.getPdfObjectRelease((PdfObject)((PdfObject)arr.getArrayList().get(3)));
                                    byte[] iii = PdfReader.getStreamBytes((PRStream)((PRStream)ind));
                                    ArrayList<RGB> rgbs = new ArrayList<RGB>();
                                    int j = 0;
                                    while (j < 255) {
                                        int b;
                                        int g;
                                        int r = iii[3 * j];
                                        if (r < 0) {
                                            r += 256;
                                        }
                                        if ((g = iii[3 * j + 1]) < 0) {
                                            g += 256;
                                        }
                                        if ((b = iii[3 * j + 2]) < 0) {
                                            b += 256;
                                        }
                                        rgbs.add(new RGB(r, g, b));
                                        ++j;
                                    }
                                    pd = new PaletteData(rgbs.toArray(new RGB[0]));
                                    break;
                                }
                                if (cs.isName()) {
                                    PdfName name = (PdfName)cs;
                                    if (!name.equals((Object)PdfName.DEVICEGRAY)) break;
                                    ArrayList<RGB> rgbs = new ArrayList<RGB>();
                                    int j = 0;
                                    while (j < 255) {
                                        rgbs.add(new RGB(j, j, j));
                                        ++j;
                                    }
                                    pd = new PaletteData(rgbs.toArray(new RGB[0]));
                                    break;
                                }
                                if (!cs.isIndirect()) break;
                                cs = PdfReader.getPdfObjectRelease((PdfObject)cs);
                                cs = PdfReader.getPdfObjectRelease((PdfObject)((PdfObject)((PdfArray)cs).getArrayList().get(1)));
                                pd = new PaletteData(4, 2, 1);
                                bpc = 24;
                                cs.toString();
                            }
                        }
                        byte[] arrr = ImageUtils.convertICCToRGB(PdfReader.getStreamBytes((PRStream)((PRStream)pdfdict)));
                        ImageData imgd = new ImageData(width, height, bpc, pd, 1, arrr);
                        ii = new org.eclipse.swt.graphics.Image((Device)PlatformUI.getWorkbench().getDisplay(), imgd);
                    }
                    imgs.add(ii);
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
            ++i;
        }
        return imgs;
    }

    @Override
    public void close() {
        this.reader.close();
    }

    @Override
    public void setThumbnail(org.eclipse.swt.graphics.Image img) {
        try {
            String newfile = "/tmp/sample.pdf";
            Document document = new Document(this.reader.getPageSizeWithRotation(1));
            PdfCopy copy = new PdfCopy(document, (OutputStream)new FileOutputStream(newfile));
            document.open();
            int npage = this.reader.getNumberOfPages();
            int i = 1;
            while (i <= npage) {
                PdfImportedPage page = copy.getImportedPage(this.reader, i);
                copy.addPage(page);
                ++i;
            }
            ImageLoader loader = new ImageLoader();
            loader.data = new ImageData[]{img.getImageData()};
            loader.save("/tmp/thumbnail.bmp", 0);
            loader = null;
            copy.setThumbnail(Image.getInstance((String)"/tmp/thumbnail.bmp"));
            document.close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    @Override
    public String getText() {
        try {
            PDDocument doc = PDDocument.load((String)this.filename);
            PDFTextStripper stripper = new PDFTextStripper();
            String s = stripper.getText(doc);
            doc.close();
            return s;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

