/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.filters;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import jp.sourceforge.concierge.plugin.filters.OfficeFilter;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.extractor.WordExtractor;
import org.apache.poi.hwpf.usermodel.CharacterRun;
import org.apache.poi.hwpf.usermodel.Picture;
import org.apache.poi.hwpf.usermodel.Range;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordFilter
extends OfficeFilter {
    HWPFDocument document;

    public WordFilter(String file) throws IOException {
        super(file);
        this.document = new HWPFDocument(this.poifs);
    }

    @Override
    public ArrayList<Image> getImages() {
        ArrayList<Image> imgs = new ArrayList<Image>();
        Range rng = this.document.getRange();
        int numcr = rng.numCharacterRuns();
        int i = 0;
        while (i < numcr) {
            CharacterRun cr = rng.getCharacterRun(i);
            if (this.document.getPicturesTable().hasPicture(cr)) {
                Picture pict = this.document.getPicturesTable().extractPicture(cr, false);
                byte[] data = pict.getRawContent();
                try {
                    Image img = new Image((Device)PlatformUI.getWorkbench().getDisplay(), (InputStream)new ByteArrayInputStream(data));
                    imgs.add(img);
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
            ++i;
        }
        return imgs;
    }

    @Override
    public String getText() {
        try {
            WordExtractor ext = new WordExtractor(this.poifs);
            return ext.getText();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

