/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.imageviewer;

import jp.sourceforge.concierge.plugin.ImageUtils;
import jp.sourceforge.concierge.plugin.imageviewer.ColorSelectionListener;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ColorDialog
extends Dialog {
    private Label top = null;
    private ColorSelectionListener listener;
    private Color initcolor = null;

    public boolean close() {
        if (this.initcolor != null && !this.initcolor.isDisposed()) {
            this.initcolor.dispose();
        }
        return super.close();
    }

    private void createLabel(Composite parent, Color c) {
        Label l = new Label(parent, 0);
        l.setForeground(c);
        l.setBackground(c);
        l.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        l.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent arg0) {
            }

            public void mouseDown(MouseEvent arg0) {
                Color bg = ((Label)arg0.widget).getBackground();
                Color c = new Color((Device)arg0.widget.getDisplay(), bg.getRed(), bg.getGreen(), bg.getBlue());
                ColorDialog.this.top.setBackground(c);
                if (ColorDialog.this.listener != null) {
                    ColorDialog.this.listener.colorSelected(c);
                }
                c.dispose();
            }

            public void mouseUp(MouseEvent arg0) {
            }
        });
        c.dispose();
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.top = new Label(parent, 0);
        this.top.setLayoutData((Object)new GridData(4, 0, true, false));
        if (this.initcolor == null) {
            this.initcolor = new Color(null, 0, 0, 0);
        }
        this.top.setBackground(this.initcolor);
        Composite cc = new Composite(parent, 2048);
        cc.setLayoutData((Object)new GridData(4, 4, true, true));
        cc.setLayout((Layout)new GridLayout(4, true));
        this.createLabel(cc, ImageUtils.getBlack((Control)cc));
        this.createLabel(cc, ImageUtils.getRed((Control)cc));
        this.createLabel(cc, ImageUtils.getBlue((Control)cc));
        this.createLabel(cc, ImageUtils.getGreen((Control)cc));
        this.createLabel(cc, ImageUtils.getWhite((Control)cc));
        this.createLabel(cc, ImageUtils.getYellow((Control)cc));
        this.createLabel(cc, ImageUtils.getMagenta((Control)cc));
        this.createLabel(cc, ImageUtils.getCyan((Control)cc));
        this.getShell().setText("Select Color");
        return parent;
    }

    protected void initializeBounds() {
        this.getShell().setSize(180, 120);
    }

    public ColorDialog(Shell parentShell) {
        super(new Shell(parentShell));
        this.setShellStyle(1264);
        this.setBlockOnOpen(false);
    }

    public void setColorSelectionListener(ColorSelectionListener s) {
        this.listener = s;
    }

    public void setInitialColor(Color c) {
        this.initcolor = ImageUtils.getColorByColor(null, c);
    }
}

