/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.BibTeX;

import java.util.ArrayList;
import java.util.Hashtable;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.mdocument.TypeDomImpl;
import jp.sourceforge.concierge.mdocument.TypeManager;
import jp.sourceforge.concierge.parser.AuthorsParser;
import jp.sourceforge.concierge.parser.ITypeParser;
import jp.sourceforge.concierge.plugin.BibTeX.BibTeXMappingData;
import jp.sourceforge.concierge.plugin.ExportMappingDataDomImpl;
import jp.sourceforge.concierge.plugin.MappingField;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BibTeXMappingDataDomImpl
extends ExportMappingDataDomImpl {
    public static final String toptagname = "bibtexmappingdata";
    private static Hashtable<String, BibTeXMappingData> currentMappingDataList = null;

    public static void readCurrentMappingDataList() {
        if (currentMappingDataList != null) {
            currentMappingDataList.clear();
            currentMappingDataList = null;
        }
        currentMappingDataList = new Hashtable();
        ArrayList typedocs = TypeManager.getAllTypeDocuments((boolean)true, (boolean)true, (boolean)true);
        int i = 0;
        while (i < typedocs.size()) {
            Document typedoc = (Document)typedocs.get(i);
            BibTeXMappingData mappingData = BibTeXMappingDataDomImpl.readCurrentMappingData(typedoc);
            if (mappingData == null) {
                mappingData = new BibTeXMappingData(typedoc);
            }
            currentMappingDataList.put(TypeDomImpl.getTypeName((Document)typedoc), mappingData);
            ++i;
        }
    }

    private static BibTeXMappingData readCurrentMappingData(Document typedoc) {
        Document doc;
        Element rootElem;
        String selectString;
        String xpath = "/bibtexmappingdata[@typeid='" + DomImpl.getID((Document)typedoc) + "']";
        Request req = new Request(4, (Object)xpath, "exportmappingdata");
        ArrayList docs = FrameworkPlugin.getDocumentsOfQuery((Request)req);
        if (docs.size() > 0 && (selectString = (rootElem = (doc = (Document)docs.get(0)).getDocumentElement()).getAttribute("select")) != null && selectString.length() > 0) {
            int select = Integer.valueOf(selectString);
            int count = 0;
            Node dataNode = rootElem.getFirstChild();
            while (dataNode != null) {
                if (dataNode.getNodeType() == 1) {
                    if (count == select) {
                        ArrayList<MappingField> fieldsAL = new ArrayList<MappingField>();
                        Node fieldNode = dataNode.getFirstChild();
                        while (fieldNode != null) {
                            if (fieldNode.getNodeType() == 1) {
                                String bibtexValue = ((Element)fieldNode).getAttribute("bibtex");
                                String ccgValue = ((Element)fieldNode).getAttribute("ccg");
                                fieldsAL.add(new MappingField(bibtexValue, ccgValue));
                            }
                            fieldNode = fieldNode.getNextSibling();
                        }
                        String dataName = ((Element)dataNode).getAttribute("dataname");
                        String bibtexEntryType = ((Element)dataNode).getAttribute("bibtexentrytype");
                        String citationkey = ((Element)dataNode).getAttribute("citationkey");
                        return new BibTeXMappingData(dataName, bibtexEntryType, citationkey, fieldsAL);
                    }
                    ++count;
                }
                dataNode = dataNode.getNextSibling();
            }
        }
        return null;
    }

    public static BibTeXMappingData getCurrentMappingData(String typename) {
        if (currentMappingDataList == null) {
            BibTeXMappingDataDomImpl.readCurrentMappingDataList();
        }
        if (currentMappingDataList != null) {
            return currentMappingDataList.get(typename);
        }
        return null;
    }

    public static void setCurrentMappingData(String typename, BibTeXMappingData mappingData) {
        if (currentMappingDataList == null) {
            BibTeXMappingDataDomImpl.readCurrentMappingDataList();
        }
        currentMappingDataList.put(typename, mappingData);
    }

    public static String createString(Document datadoc, String typename) {
        return BibTeXMappingDataDomImpl.createString(datadoc, typename, null);
    }

    public static String createString(Document datadoc, String typename, String citationKey) {
        if (typename == null || typename.length() == 0) {
            typename = DataDomImpl.getDefaultType((Document)datadoc);
        }
        if (typename == null || typename.length() == 0) {
            return null;
        }
        Element dataElem = DataDomImpl.getDataOfType((Document)datadoc, (String)typename);
        BibTeXMappingData mappingData = BibTeXMappingDataDomImpl.getCurrentMappingData(typename);
        if (mappingData == null) {
            return null;
        }
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("@");
        strBuf.append(mappingData.getDstTypeName());
        strBuf.append("{ ");
        if (citationKey != null) {
            strBuf.append(citationKey);
        } else {
            strBuf.append(BibTeXMappingDataDomImpl.createCitationKey(mappingData, dataElem));
        }
        strBuf.append(",\n");
        ArrayList<MappingField> fields = mappingData.getFields();
        int i = 0;
        while (i < fields.size()) {
            MappingField field = fields.get(i);
            strBuf.append("\t");
            strBuf.append(field.getDst());
            strBuf.append(" = ");
            strBuf.append("\"");
            if (field.getDst().equalsIgnoreCase("author")) {
                strBuf.append(BibTeXMappingDataDomImpl.getAuthorTextFromDataDocument(dataElem, field.getSrc()));
            } else if (field.getDst().equalsIgnoreCase("editor")) {
                strBuf.append(BibTeXMappingDataDomImpl.getAuthorTextFromDataDocument(dataElem, field.getSrc()));
            } else if (field.getDst().equalsIgnoreCase("pages")) {
                String old = BibTeXMappingDataDomImpl.getTextFromDataDocument(dataElem, field.getSrc());
                String value = old.replaceAll("-", "--");
                strBuf.append(value);
            } else {
                strBuf.append(BibTeXMappingDataDomImpl.getTextFromDataDocument(dataElem, field.getSrc()));
            }
            strBuf.append("\"");
            if (i < fields.size() - 1) {
                strBuf.append(",\n");
            }
            ++i;
        }
        strBuf.append("\n}\n");
        return strBuf.toString();
    }

    private static String replaceSpace(StringBuffer strBuf) {
        int index = 0;
        while (index < strBuf.length()) {
            if ((index = strBuf.indexOf(" ", index)) == -1) break;
            strBuf.replace(index, index + 1, "_");
        }
        return strBuf.toString();
    }

    public static String createCitationKey(Document datadoc, String typename) {
        if (typename == null || typename.length() == 0) {
            typename = DataDomImpl.getDefaultType((Document)datadoc);
        }
        if (typename == null || typename.length() == 0) {
            return null;
        }
        Element dataElem = DataDomImpl.getDataOfType((Document)datadoc, (String)typename);
        BibTeXMappingData mappingData = BibTeXMappingDataDomImpl.getCurrentMappingData(typename);
        if (mappingData == null) {
            return null;
        }
        return BibTeXMappingDataDomImpl.createCitationKey(mappingData, dataElem);
    }

    private static String createCitationKey(BibTeXMappingData mappingData, Element dataElem) {
        StringBuffer strBuf = new StringBuffer();
        String citationKey = mappingData.getCitationKey();
        int i = 0;
        block0: while (i < citationKey.length()) {
            char c = citationKey.charAt(i);
            if (c == '%') {
                StringBuffer keyAndNum = new StringBuffer();
                int j = i + 1;
                while (j < citationKey.length()) {
                    c = citationKey.charAt(j);
                    if (c == '%') break;
                    keyAndNum.append(c);
                    ++j;
                }
                i = j + 1;
                StringBuffer key = new StringBuffer();
                StringBuffer num = new StringBuffer();
                int k = 0;
                while (k < keyAndNum.length()) {
                    c = keyAndNum.charAt(k);
                    if (c <= '0' || c <= '9') {
                        num.append(c);
                    } else {
                        key.append(c);
                    }
                    ++k;
                }
                int number = 0;
                if (num.length() > 0) {
                    number = Integer.valueOf(num.toString());
                }
                ArrayList<MappingField> fields = mappingData.getFields();
                int l = 0;
                while (l < fields.size()) {
                    MappingField field = fields.get(l);
                    String bibtexFieldName = field.getDst();
                    if (bibtexFieldName.equalsIgnoreCase(key.toString())) {
                        String value = BibTeXMappingDataDomImpl.getTextFromDataDocument(dataElem, field.getSrc());
                        if (bibtexFieldName.equalsIgnoreCase("author")) {
                            String[] values = value.split(" ");
                            value = values[0];
                            if (number > 0) {
                                if (number <= value.length()) {
                                    strBuf.append(value.substring(0, number));
                                    continue block0;
                                }
                                strBuf.append(value);
                                continue block0;
                            }
                            strBuf.append(value);
                            continue block0;
                        }
                        if (number > 0) {
                            if (number <= value.length()) {
                                strBuf.append(value.substring(0, number));
                                continue block0;
                            }
                            strBuf.append(value);
                            continue block0;
                        }
                        strBuf.append(value);
                        continue block0;
                    }
                    ++l;
                }
                continue;
            }
            strBuf.append(c);
            ++i;
        }
        return BibTeXMappingDataDomImpl.replaceSpace(strBuf);
    }

    private static String getTextFromDataDocument(Element dataElem, String elemName) {
        String parsername;
        ITypeParser p;
        StringBuffer strBuf = new StringBuffer();
        Element elem = DataDomImpl.getElement((Element)dataElem, (String)elemName);
        if (elem != null && (p = FrameworkPlugin.getParser((String)(parsername = DataDomImpl.getParserName((Element)elem)))) != null) {
            strBuf.append(p.getSingleText(elem));
        }
        return strBuf.toString();
    }

    private static String getAuthorTextFromDataDocument(Element dataElem, String elemName) {
        String parsername;
        ITypeParser p;
        StringBuffer strBuf = new StringBuffer();
        Element elem = DataDomImpl.getElement((Element)dataElem, (String)elemName);
        if (elem != null && (p = FrameworkPlugin.getParser((String)(parsername = DataDomImpl.getParserName((Element)elem)))) != null) {
            if (p instanceof AuthorsParser) {
                AuthorsParser ap = (AuthorsParser)p;
                ArrayList al = ap.getMultiText(elem);
                int i = 0;
                while (i < al.size()) {
                    if (i > 0) {
                        strBuf.append(" and ");
                    }
                    strBuf.append(((String)al.get(i)).trim());
                    ++i;
                }
            } else {
                String value = p.getSingleText(elem);
                strBuf.append(value);
            }
        }
        return strBuf.toString();
    }
}

