/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.customize;

import java.util.ArrayList;
import java.util.Hashtable;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.mdocument.TypeDomImpl;
import jp.sourceforge.concierge.mdocument.TypeManager;
import jp.sourceforge.concierge.parser.AuthorsParser;
import jp.sourceforge.concierge.parser.ITypeParser;
import jp.sourceforge.concierge.parser.IdentifiersParser;
import jp.sourceforge.concierge.plugin.ExportMappingDataDomImpl;
import jp.sourceforge.concierge.plugin.customize.ReferenceDataFormat;
import jp.sourceforge.concierge.plugin.customize.ReferenceDataFormatAuthorsElement;
import jp.sourceforge.concierge.plugin.customize.ReferenceDataFormatElement;
import jp.sourceforge.concierge.plugin.customize.ReferenceDataFormatEscapeSequenceElement;
import jp.sourceforge.concierge.plugin.customize.ReferenceDataFormatIdentifiersElement;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceDataFormatDomImpl
extends ExportMappingDataDomImpl {
    private static Hashtable<String, ReferenceDataFormat> formatlist = null;
    public static final String toptagname = "referencedataformat";

    private static ReferenceDataFormat readCurrentReferenceDataFormat(Document typedoc) {
        ReferenceDataFormat format = null;
        String xpath = "/referencedataformat[@typeid='" + DomImpl.getID((Document)typedoc) + "']";
        Request req = new Request(4, (Object)xpath, "exportmappingdata");
        ArrayList docs = FrameworkPlugin.getDocumentsOfQuery((Request)req);
        if (docs.size() > 0) {
            Document doc = (Document)docs.get(0);
            Element rootElem = doc.getDocumentElement();
            String selectString = rootElem.getAttribute("select");
            if (selectString == null || selectString.length() == 0) {
                selectString = "0";
            }
            int select = Integer.valueOf(selectString);
            int count = 0;
            Node formatNode = rootElem.getFirstChild();
            while (formatNode != null) {
                if (formatNode.getNodeType() == 1) {
                    if (count == select) {
                        format = new ReferenceDataFormat(((Element)formatNode).getAttribute("formatname"));
                        format.setFontname(((Element)formatNode).getAttribute("fontname"));
                        String fontsize = ((Element)formatNode).getAttribute("fontsize");
                        format.setFontSize(Integer.valueOf(fontsize));
                        Node elementNode = formatNode.getFirstChild();
                        while (elementNode != null) {
                            if (elementNode.getNodeType() == 1) {
                                String typeElemName;
                                Element typeElem;
                                int i;
                                ArrayList typeElems;
                                String name;
                                String classname = ((Element)elementNode).getAttribute("class");
                                if (classname.equalsIgnoreCase("ReferenceDataFormatElement")) {
                                    name = ((Element)elementNode).getAttribute("name");
                                    typeElems = TypeDomImpl.getAllElements((Document)typedoc);
                                    i = 0;
                                    while (i < typeElems.size()) {
                                        typeElem = (Element)typeElems.get(i);
                                        String typElemName = TypeDomImpl.getElementName((Element)typeElem);
                                        if (typElemName.equals(name)) {
                                            ReferenceDataFormatElement referenceDataFormatElement = new ReferenceDataFormatElement(name);
                                            referenceDataFormatElement.setBold(((Element)elementNode).getAttribute("bold").equals("true"));
                                            referenceDataFormatElement.setItalic(((Element)elementNode).getAttribute("italic").equals("true"));
                                            referenceDataFormatElement.setUnderline(((Element)elementNode).getAttribute("underline").equals("true"));
                                            format.addElement(referenceDataFormatElement);
                                            break;
                                        }
                                        ++i;
                                    }
                                } else if (classname.startsWith("ReferenceDataFormatAuthorsElement")) {
                                    name = ((Element)elementNode).getAttribute("name");
                                    typeElems = TypeDomImpl.getAllElements((Document)typedoc);
                                    i = 0;
                                    while (i < typeElems.size()) {
                                        typeElem = (Element)typeElems.get(i);
                                        typeElemName = TypeDomImpl.getElementName((Element)typeElem);
                                        if (typeElemName.equals(name)) {
                                            ReferenceDataFormatAuthorsElement referenceDataFormatAuthorsElement = new ReferenceDataFormatAuthorsElement(name);
                                            format.addElement(referenceDataFormatAuthorsElement);
                                            referenceDataFormatAuthorsElement.setBold(((Element)elementNode).getAttribute("bold").equals("true"));
                                            referenceDataFormatAuthorsElement.setItalic(((Element)elementNode).getAttribute("italic").equals("true"));
                                            referenceDataFormatAuthorsElement.setUnderline(((Element)elementNode).getAttribute("underline").equals("true"));
                                            Node node = elementNode.getFirstChild();
                                            while (node != null) {
                                                if (node.getNodeType() == 1) {
                                                    Node textnode;
                                                    String buf;
                                                    if (node.getNodeName().equals("firstauthor")) {
                                                        buf = "";
                                                        textnode = node.getFirstChild();
                                                        while (textnode != null) {
                                                            if (textnode.getNodeType() == 3) {
                                                                buf = String.valueOf(buf) + textnode.getNodeValue();
                                                            }
                                                            textnode = textnode.getNextSibling();
                                                        }
                                                        referenceDataFormatAuthorsElement.setFirstAuthor(buf);
                                                    } else if (node.getNodeName().equals("secondauthor")) {
                                                        buf = "";
                                                        textnode = node.getFirstChild();
                                                        while (textnode != null) {
                                                            if (textnode.getNodeType() == 3) {
                                                                buf = String.valueOf(buf) + textnode.getNodeValue();
                                                            }
                                                            textnode = textnode.getNextSibling();
                                                        }
                                                        referenceDataFormatAuthorsElement.setSecondAuthor(buf);
                                                    } else if (node.getNodeName().equals("lastauthor")) {
                                                        buf = "";
                                                        textnode = node.getFirstChild();
                                                        while (textnode != null) {
                                                            if (textnode.getNodeType() == 3) {
                                                                buf = String.valueOf(buf) + textnode.getNodeValue();
                                                            }
                                                            textnode = textnode.getNextSibling();
                                                        }
                                                        referenceDataFormatAuthorsElement.setLastAuthor(buf);
                                                    } else if (node.getNodeName().equals("connectionstring")) {
                                                        buf = "";
                                                        textnode = node.getFirstChild();
                                                        while (textnode != null) {
                                                            if (textnode.getNodeType() == 3) {
                                                                buf = String.valueOf(buf) + textnode.getNodeValue();
                                                            }
                                                            textnode = textnode.getNextSibling();
                                                        }
                                                        referenceDataFormatAuthorsElement.setConnectionString(buf);
                                                    } else if (node.getNodeName().equals("connectionlaststring")) {
                                                        buf = "";
                                                        textnode = node.getFirstChild();
                                                        while (textnode != null) {
                                                            if (textnode.getNodeType() == 3) {
                                                                buf = String.valueOf(buf) + textnode.getNodeValue();
                                                            }
                                                            textnode = textnode.getNextSibling();
                                                        }
                                                        referenceDataFormatAuthorsElement.setConnectionLastString(buf);
                                                    }
                                                }
                                                node = node.getNextSibling();
                                            }
                                            break;
                                        }
                                        ++i;
                                    }
                                } else if (classname.startsWith("ReferenceDataFormatIdentifiersElement")) {
                                    name = ((Element)elementNode).getAttribute("name");
                                    typeElems = TypeDomImpl.getAllElements((Document)typedoc);
                                    i = 0;
                                    while (i < typeElems.size()) {
                                        typeElem = (Element)typeElems.get(i);
                                        typeElemName = TypeDomImpl.getElementName((Element)typeElem);
                                        if (typeElemName.equals(name)) {
                                            ReferenceDataFormatIdentifiersElement referenceDataFormatIdentifiersElement = new ReferenceDataFormatIdentifiersElement(name);
                                            format.addElement(referenceDataFormatIdentifiersElement);
                                            referenceDataFormatIdentifiersElement.setBold(((Element)elementNode).getAttribute("bold").equals("true"));
                                            referenceDataFormatIdentifiersElement.setItalic(((Element)elementNode).getAttribute("italic").equals("true"));
                                            referenceDataFormatIdentifiersElement.setUnderline(((Element)elementNode).getAttribute("underline").equals("true"));
                                            String identifier = ((Element)elementNode).getAttribute("identifier");
                                            referenceDataFormatIdentifiersElement.setIdentifier(identifier);
                                            break;
                                        }
                                        ++i;
                                    }
                                } else if (classname.startsWith("ReferenceDataFormatEscapeSequenceElement")) {
                                    String escapesequence = ((Element)elementNode).getAttribute("escapesequence");
                                    ReferenceDataFormatEscapeSequenceElement referenceDataFormatEscapeSequenceElement = new ReferenceDataFormatEscapeSequenceElement(escapesequence);
                                    format.addElement(referenceDataFormatEscapeSequenceElement);
                                } else if (classname.equalsIgnoreCase("String")) {
                                    name = ((Element)elementNode).getAttribute("name");
                                    format.addElement(new String(name));
                                }
                            }
                            elementNode = elementNode.getNextSibling();
                        }
                        break;
                    }
                    ++count;
                }
                formatNode = formatNode.getNextSibling();
            }
        }
        return format;
    }

    public static void readFormatList() {
        if (formatlist != null) {
            formatlist.clear();
            formatlist = null;
        }
        formatlist = new Hashtable();
        ArrayList typedocs = TypeManager.getAllTypeDocuments((boolean)true, (boolean)true, (boolean)true);
        int i = 0;
        while (i < typedocs.size()) {
            Document typedoc = (Document)typedocs.get(i);
            ReferenceDataFormat format = ReferenceDataFormatDomImpl.readCurrentReferenceDataFormat(typedoc);
            if (format == null) {
                format = ReferenceDataFormatDomImpl.createDefaultFormat(typedoc);
            }
            formatlist.put(TypeDomImpl.getTypeName((Document)typedoc), format);
            ++i;
        }
    }

    public static void setCurrentFormat(String typename, ReferenceDataFormat format) {
        if (formatlist == null) {
            formatlist = new Hashtable();
        }
        formatlist.put(typename, format);
    }

    public static ReferenceDataFormat getCurrentFormat(String typename) {
        if (formatlist == null) {
            ReferenceDataFormatDomImpl.readFormatList();
        }
        if (formatlist != null) {
            return formatlist.get(typename);
        }
        return null;
    }

    private static ReferenceDataFormat createDefaultFormat(Document typedoc) {
        ReferenceDataFormat format = new ReferenceDataFormat("Default");
        ArrayList elems = TypeDomImpl.getAllElements((Document)typedoc);
        int i = 0;
        while (i < elems.size()) {
            if (i > 0) {
                format.addElement(new String(", "));
            }
            Element elem = (Element)elems.get(i);
            String name = TypeDomImpl.getElementName((Element)elem);
            String parser = TypeDomImpl.getParser((Element)elem);
            if (parser.equalsIgnoreCase("identifiers")) {
                format.addElement(new ReferenceDataFormatIdentifiersElement(name));
            } else if (parser.equalsIgnoreCase("authors")) {
                format.addElement(new ReferenceDataFormatAuthorsElement(name));
            } else {
                format.addElement(new ReferenceDataFormatElement(name));
            }
            ++i;
        }
        return format;
    }

    private static Font newFont(Device device, String name, int height, int styl, FontRegistry fontReg) {
        Font font = new Font(device, name, height, styl);
        FontData fd = font.getFontData()[0];
        if (fontReg.hasValueFor(fd.toString())) {
            font.dispose();
            font = fontReg.get(fd.toString());
        } else {
            fontReg.put(fd.toString(), font.getFontData());
        }
        return font;
    }

    public static void addStyledText(Document datadoc, String typename, StyledText styledText, FontRegistry fontReg) {
        if (typename == null || typename.length() == 0) {
            typename = DataDomImpl.getDefaultType((Document)datadoc);
        }
        if (typename == null || typename.length() == 0) {
            return;
        }
        Element dataElem = DataDomImpl.getDataOfType((Document)datadoc, (String)typename);
        ReferenceDataFormat format = ReferenceDataFormatDomImpl.getCurrentFormat(typename);
        if (format == null) {
            return;
        }
        ArrayList<Object> elementList = format.getElementList();
        int i = 0;
        while (i < elementList.size()) {
            int fontStyle;
            StyleRange styleRange;
            String value;
            Object obj = elementList.get(i);
            if (obj instanceof String) {
                String value2 = (String)obj;
                StyleRange styleRange2 = new StyleRange();
                styleRange2.start = styledText.getText().length();
                styleRange2.length = value2.length();
                styleRange2.font = ReferenceDataFormatDomImpl.newFont(null, format.getFontname(), format.getFontSize(), 0, fontReg);
                styledText.append(value2);
                styledText.setStyleRange(styleRange2);
            } else if (obj instanceof ReferenceDataFormatEscapeSequenceElement) {
                ReferenceDataFormatEscapeSequenceElement referenceDataFormatEscapeSequenceElement = (ReferenceDataFormatEscapeSequenceElement)obj;
                value = "";
                if (referenceDataFormatEscapeSequenceElement.getEscapeSequence().equals(ReferenceDataFormatEscapeSequenceElement.escapesequences[0])) {
                    value = "\n";
                } else if (referenceDataFormatEscapeSequenceElement.getEscapeSequence().equals(ReferenceDataFormatEscapeSequenceElement.escapesequences[1])) {
                    value = "\t";
                }
                if (value != null && value.length() > 0) {
                    styleRange = new StyleRange();
                    styleRange.start = styledText.getText().length();
                    styleRange.length = value.length();
                    styleRange.font = ReferenceDataFormatDomImpl.newFont(null, format.getFontname(), format.getFontSize(), 0, fontReg);
                    styledText.append(value);
                    styledText.setStyleRange(styleRange);
                }
            } else if (obj instanceof ReferenceDataFormatIdentifiersElement) {
                ReferenceDataFormatIdentifiersElement referenceDataFormatIdentifiersElement = (ReferenceDataFormatIdentifiersElement)obj;
                value = ReferenceDataFormatDomImpl.createIdentifiersString(dataElem, referenceDataFormatIdentifiersElement.toString(), referenceDataFormatIdentifiersElement.getIdentifier());
                if (value != null && value.length() > 0) {
                    styleRange = new StyleRange();
                    styleRange.start = styledText.getText().length();
                    styleRange.length = value.length();
                    fontStyle = 0;
                    if (referenceDataFormatIdentifiersElement.getBold()) {
                        fontStyle |= 1;
                    }
                    if (referenceDataFormatIdentifiersElement.getItalic()) {
                        fontStyle |= 2;
                    }
                    referenceDataFormatIdentifiersElement.getUnderline();
                    styleRange.font = ReferenceDataFormatDomImpl.newFont(null, format.getFontname(), format.getFontSize(), fontStyle, fontReg);
                    styledText.append(value);
                    styledText.setStyleRange(styleRange);
                }
            } else if (obj instanceof ReferenceDataFormatAuthorsElement) {
                ReferenceDataFormatAuthorsElement referenceDataFormatAuthorsElement = (ReferenceDataFormatAuthorsElement)obj;
                value = ReferenceDataFormatDomImpl.createAuthorsString(dataElem, referenceDataFormatAuthorsElement.toString(), referenceDataFormatAuthorsElement.getFirstAuthor(), referenceDataFormatAuthorsElement.getConnectionString(), referenceDataFormatAuthorsElement.getSecondAuthor(), referenceDataFormatAuthorsElement.getConnectionLastString(), referenceDataFormatAuthorsElement.getLastAuthor());
                if (value != null && value.length() > 0) {
                    styleRange = new StyleRange();
                    styleRange.start = styledText.getText().length();
                    styleRange.length = value.length();
                    fontStyle = 0;
                    if (referenceDataFormatAuthorsElement.getBold()) {
                        fontStyle |= 1;
                    }
                    if (referenceDataFormatAuthorsElement.getItalic()) {
                        fontStyle |= 2;
                    }
                    referenceDataFormatAuthorsElement.getUnderline();
                    styleRange.font = ReferenceDataFormatDomImpl.newFont(null, format.getFontname(), format.getFontSize(), fontStyle, fontReg);
                    styledText.append(value);
                    styledText.setStyleRange(styleRange);
                }
            } else if (obj instanceof ReferenceDataFormatElement) {
                ReferenceDataFormatElement referenceDataFormatElement = (ReferenceDataFormatElement)obj;
                value = ReferenceDataFormatDomImpl.createElementString(dataElem, referenceDataFormatElement.toString());
                if (referenceDataFormatElement.getName().equalsIgnoreCase("Title") && value.endsWith(".")) {
                    value = value.substring(0, value.length() - 1);
                }
                if (value != null && value.length() > 0) {
                    styleRange = new StyleRange();
                    styleRange.start = styledText.getText().length();
                    styleRange.length = value.length();
                    fontStyle = 0;
                    if (referenceDataFormatElement.getBold()) {
                        fontStyle |= 1;
                    }
                    if (referenceDataFormatElement.getItalic()) {
                        fontStyle |= 2;
                    }
                    referenceDataFormatElement.getUnderline();
                    styleRange.font = ReferenceDataFormatDomImpl.newFont(null, format.getFontname(), format.getFontSize(), fontStyle, fontReg);
                    styledText.append(value);
                    styledText.setStyleRange(styleRange);
                }
            }
            ++i;
        }
    }

    public static String createPlainText(Document datadoc, String typename) {
        if (typename == null || typename.length() == 0) {
            typename = DataDomImpl.getDefaultType((Document)datadoc);
        }
        if (typename == null || typename.length() == 0) {
            return null;
        }
        Element dataElem = DataDomImpl.getDataOfType((Document)datadoc, (String)typename);
        ReferenceDataFormat format = ReferenceDataFormatDomImpl.getCurrentFormat(typename);
        if (format == null) {
            return null;
        }
        StringBuffer strBuf = new StringBuffer();
        ArrayList<Object> elementList = format.getElementList();
        int i = 0;
        while (i < elementList.size()) {
            String value;
            Object obj = elementList.get(i);
            if (obj instanceof String) {
                String value2 = (String)obj;
                strBuf.append(value2);
            } else if (obj instanceof ReferenceDataFormatEscapeSequenceElement) {
                ReferenceDataFormatEscapeSequenceElement referenceDataFormatEscapeSequenceElement = (ReferenceDataFormatEscapeSequenceElement)obj;
                value = "";
                if (referenceDataFormatEscapeSequenceElement.getEscapeSequence().equals(ReferenceDataFormatEscapeSequenceElement.escapesequences[0])) {
                    value = "\n";
                } else if (referenceDataFormatEscapeSequenceElement.getEscapeSequence().equals(ReferenceDataFormatEscapeSequenceElement.escapesequences[1])) {
                    value = "\t";
                }
                strBuf.append(value);
            } else if (obj instanceof ReferenceDataFormatIdentifiersElement) {
                ReferenceDataFormatIdentifiersElement referenceDataFormatIdentifiersElement = (ReferenceDataFormatIdentifiersElement)obj;
                value = ReferenceDataFormatDomImpl.createIdentifiersString(dataElem, referenceDataFormatIdentifiersElement.toString(), referenceDataFormatIdentifiersElement.getIdentifier());
                strBuf.append(value);
            } else if (obj instanceof ReferenceDataFormatAuthorsElement) {
                ReferenceDataFormatAuthorsElement referenceDataFormatAuthorsElement = (ReferenceDataFormatAuthorsElement)obj;
                value = ReferenceDataFormatDomImpl.createAuthorsString(dataElem, referenceDataFormatAuthorsElement.toString(), referenceDataFormatAuthorsElement.getFirstAuthor(), referenceDataFormatAuthorsElement.getConnectionString(), referenceDataFormatAuthorsElement.getSecondAuthor(), referenceDataFormatAuthorsElement.getConnectionLastString(), referenceDataFormatAuthorsElement.getLastAuthor());
                strBuf.append(value);
            } else if (obj instanceof ReferenceDataFormatElement) {
                ReferenceDataFormatElement referenceDataFormatElement = (ReferenceDataFormatElement)obj;
                String text = ReferenceDataFormatDomImpl.createElementString(dataElem, referenceDataFormatElement.toString());
                if (referenceDataFormatElement.getName().equalsIgnoreCase("Title") && text.endsWith(".")) {
                    text = text.substring(0, text.length() - 1);
                }
                strBuf.append(text);
            }
            ++i;
        }
        return strBuf.toString();
    }

    public static String createRTFText(Document[] datadocs, String typename) {
        StringBuffer outBuf = new StringBuffer();
        StringBuffer fonttblBuf = new StringBuffer();
        ArrayList<String> fonttbl = new ArrayList<String>();
        int i = 0;
        while (i < datadocs.length) {
            Document datadoc = datadocs[i];
            if (typename == null) {
                typename = DataDomImpl.getDefaultType((Document)datadoc);
            }
            if (typename != null && typename.length() > 0) {
                Element dataElem = DataDomImpl.getDataOfType((Document)datadoc, (String)typename);
                ReferenceDataFormat format = ReferenceDataFormatDomImpl.getCurrentFormat(typename);
                if (format != null) {
                    String font = new String();
                    int index = fonttbl.indexOf(format.getFontname());
                    if (index == -1) {
                        fonttbl.add(format.getFontname());
                        index = fonttbl.size() - 1;
                    }
                    font = "\\f" + index + "\\fs" + String.valueOf(format.getFontSize() * 2);
                    StringBuffer strBuf = new StringBuffer();
                    ArrayList<Object> elementList = format.getElementList();
                    int j = 0;
                    while (j < elementList.size()) {
                        String value;
                        Object obj = elementList.get(j);
                        if (obj instanceof String) {
                            String value2 = (String)obj;
                            strBuf.append(value2);
                        } else if (obj instanceof ReferenceDataFormatIdentifiersElement) {
                            ReferenceDataFormatIdentifiersElement referenceDataFormatIdentifiersElement = (ReferenceDataFormatIdentifiersElement)obj;
                            value = new String();
                            value = String.valueOf(value) + "{";
                            value = referenceDataFormatIdentifiersElement.getBold() ? String.valueOf(value) + "\\b" : String.valueOf(value) + "\\b0";
                            value = referenceDataFormatIdentifiersElement.getItalic() ? String.valueOf(value) + "\\i" : String.valueOf(value) + "\\i0";
                            value = referenceDataFormatIdentifiersElement.getUnderline() ? String.valueOf(value) + "\\ul" : String.valueOf(value) + "\\ulnone";
                            value = String.valueOf(value) + " ";
                            value = String.valueOf(value) + ReferenceDataFormatDomImpl.rtfEncode(ReferenceDataFormatDomImpl.createIdentifiersString(dataElem, referenceDataFormatIdentifiersElement.toString(), referenceDataFormatIdentifiersElement.getIdentifier()));
                            value = String.valueOf(value) + "}";
                            strBuf.append(value);
                        } else if (obj instanceof ReferenceDataFormatAuthorsElement) {
                            ReferenceDataFormatAuthorsElement referenceDataFormatAuthorsElement = (ReferenceDataFormatAuthorsElement)obj;
                            value = new String();
                            value = String.valueOf(value) + "{";
                            value = referenceDataFormatAuthorsElement.getBold() ? String.valueOf(value) + "\\b" : String.valueOf(value) + "\\b0";
                            value = referenceDataFormatAuthorsElement.getItalic() ? String.valueOf(value) + "\\i" : String.valueOf(value) + "\\i0";
                            value = referenceDataFormatAuthorsElement.getUnderline() ? String.valueOf(value) + "\\ul" : String.valueOf(value) + "\\ulnone";
                            value = String.valueOf(value) + " ";
                            value = String.valueOf(value) + ReferenceDataFormatDomImpl.rtfEncode(ReferenceDataFormatDomImpl.createAuthorsString(dataElem, referenceDataFormatAuthorsElement.toString(), referenceDataFormatAuthorsElement.getFirstAuthor(), referenceDataFormatAuthorsElement.getConnectionString(), referenceDataFormatAuthorsElement.getSecondAuthor(), referenceDataFormatAuthorsElement.getConnectionLastString(), referenceDataFormatAuthorsElement.getLastAuthor()));
                            value = String.valueOf(value) + "}";
                            strBuf.append(value);
                        } else if (obj instanceof ReferenceDataFormatEscapeSequenceElement) {
                            ReferenceDataFormatEscapeSequenceElement referenceDataFormatEscapeSequenceElement = (ReferenceDataFormatEscapeSequenceElement)obj;
                            value = "";
                            if (referenceDataFormatEscapeSequenceElement.getEscapeSequence().equals(ReferenceDataFormatEscapeSequenceElement.escapesequences[0])) {
                                value = "\\par";
                            } else if (referenceDataFormatEscapeSequenceElement.getEscapeSequence().equals(ReferenceDataFormatEscapeSequenceElement.escapesequences[1])) {
                                value = "\\tab";
                            }
                            strBuf.append(value);
                        } else if (obj instanceof ReferenceDataFormatElement) {
                            ReferenceDataFormatElement referenceDataFormatElement = (ReferenceDataFormatElement)obj;
                            value = new String();
                            value = String.valueOf(value) + "{";
                            value = referenceDataFormatElement.getBold() ? String.valueOf(value) + "\\b" : String.valueOf(value) + "\\b0";
                            value = referenceDataFormatElement.getItalic() ? String.valueOf(value) + "\\i" : String.valueOf(value) + "\\i0";
                            value = referenceDataFormatElement.getUnderline() ? String.valueOf(value) + "\\ul" : String.valueOf(value) + "\\ulnone";
                            value = String.valueOf(value) + " ";
                            String text = ReferenceDataFormatDomImpl.createElementString(dataElem, referenceDataFormatElement.toString());
                            if (referenceDataFormatElement.getName().equalsIgnoreCase("Title") && text.endsWith(".")) {
                                text = text.substring(0, text.length() - 1);
                            }
                            value = String.valueOf(value) + ReferenceDataFormatDomImpl.rtfEncode(text);
                            value = String.valueOf(value) + "}";
                            strBuf.append(value);
                        }
                        ++j;
                    }
                    if (strBuf.length() > 0) {
                        strBuf.insert(0, "{" + font + " ");
                        strBuf.append("\\par}");
                    }
                    outBuf.append(strBuf);
                }
            }
            ++i;
        }
        if (fonttbl.size() > 0) {
            fonttblBuf.append("{\\fonttbl");
            i = 0;
            while (i < fonttbl.size()) {
                String tmpString = "{\\f" + i + "\\fnil " + (String)fonttbl.get(i) + ";}";
                fonttblBuf.append(tmpString);
                ++i;
            }
            fonttblBuf.append("}");
        }
        if (outBuf.length() > 0) {
            String head = "{\\rtf1\\ansi\\uc0\\deff0" + fonttblBuf.toString() + "{\\colortbl\\red0\\green0\\blue0;\\red255\\green255\\blue255;}";
            outBuf.insert(0, head);
            outBuf.append("}");
        }
        return outBuf.toString();
    }

    public static String createRTFText(Document datadoc, String typename) {
        if (typename == null || typename.length() == 0) {
            typename = DataDomImpl.getDefaultType((Document)datadoc);
        }
        if (typename == null || typename.length() == 0) {
            return null;
        }
        Element dataElem = DataDomImpl.getDataOfType((Document)datadoc, (String)typename);
        ReferenceDataFormat format = ReferenceDataFormatDomImpl.getCurrentFormat(typename);
        if (format == null) {
            return null;
        }
        StringBuffer outBuf = new StringBuffer();
        StringBuffer fonttblBuf = new StringBuffer();
        String font = new String();
        fonttblBuf.append("\\f0\\fnil " + format.getFontname() + ";");
        font = "\\f0\\fs" + String.valueOf(format.getFontSize() * 2);
        StringBuffer strBuf = new StringBuffer();
        ArrayList<Object> elementList = format.getElementList();
        int j = 0;
        while (j < elementList.size()) {
            String value;
            Object obj = elementList.get(j);
            if (obj instanceof String) {
                String value2 = (String)obj;
                strBuf.append(value2);
            } else if (obj instanceof ReferenceDataFormatIdentifiersElement) {
                ReferenceDataFormatIdentifiersElement referenceDataFormatIdentifiersElement = (ReferenceDataFormatIdentifiersElement)obj;
                value = new String();
                value = String.valueOf(value) + "{";
                value = referenceDataFormatIdentifiersElement.getBold() ? String.valueOf(value) + "\\b" : String.valueOf(value) + "\\b0";
                value = referenceDataFormatIdentifiersElement.getItalic() ? String.valueOf(value) + "\\i" : String.valueOf(value) + "\\i0";
                value = referenceDataFormatIdentifiersElement.getUnderline() ? String.valueOf(value) + "\\ul" : String.valueOf(value) + "\\ulnone";
                value = String.valueOf(value) + " ";
                value = String.valueOf(value) + ReferenceDataFormatDomImpl.rtfEncode(ReferenceDataFormatDomImpl.createIdentifiersString(dataElem, referenceDataFormatIdentifiersElement.toString(), referenceDataFormatIdentifiersElement.getIdentifier()));
                value = String.valueOf(value) + "}";
                strBuf.append(value);
            } else if (obj instanceof ReferenceDataFormatEscapeSequenceElement) {
                ReferenceDataFormatEscapeSequenceElement referenceDataFormatEscapeSequenceElement = (ReferenceDataFormatEscapeSequenceElement)obj;
                value = "";
                if (referenceDataFormatEscapeSequenceElement.getEscapeSequence().equals(ReferenceDataFormatEscapeSequenceElement.escapesequences[0])) {
                    value = "\\par";
                } else if (referenceDataFormatEscapeSequenceElement.getEscapeSequence().equals(ReferenceDataFormatEscapeSequenceElement.escapesequences[1])) {
                    value = "\\tabt";
                }
                strBuf.append(value);
            } else if (obj instanceof ReferenceDataFormatAuthorsElement) {
                ReferenceDataFormatAuthorsElement referenceDataFormatAuthorsElement = (ReferenceDataFormatAuthorsElement)obj;
                value = new String();
                value = String.valueOf(value) + "{";
                value = referenceDataFormatAuthorsElement.getBold() ? String.valueOf(value) + "\\b" : String.valueOf(value) + "\\b0";
                value = referenceDataFormatAuthorsElement.getItalic() ? String.valueOf(value) + "\\i" : String.valueOf(value) + "\\i0";
                value = referenceDataFormatAuthorsElement.getUnderline() ? String.valueOf(value) + "\\ul" : String.valueOf(value) + "\\ulnone";
                value = String.valueOf(value) + " ";
                value = String.valueOf(value) + ReferenceDataFormatDomImpl.rtfEncode(ReferenceDataFormatDomImpl.createAuthorsString(dataElem, referenceDataFormatAuthorsElement.toString(), referenceDataFormatAuthorsElement.getFirstAuthor(), referenceDataFormatAuthorsElement.getConnectionString(), referenceDataFormatAuthorsElement.getSecondAuthor(), referenceDataFormatAuthorsElement.getConnectionLastString(), referenceDataFormatAuthorsElement.getLastAuthor()));
                value = String.valueOf(value) + "}";
                strBuf.append(value);
            } else if (obj instanceof ReferenceDataFormatElement) {
                ReferenceDataFormatElement referenceDataFormatElement = (ReferenceDataFormatElement)obj;
                value = new String();
                value = String.valueOf(value) + "{";
                value = referenceDataFormatElement.getBold() ? String.valueOf(value) + "\\b" : String.valueOf(value) + "\\b0";
                value = referenceDataFormatElement.getItalic() ? String.valueOf(value) + "\\i" : String.valueOf(value) + "\\i0";
                value = referenceDataFormatElement.getUnderline() ? String.valueOf(value) + "\\ul" : String.valueOf(value) + "\\ulnone";
                value = String.valueOf(value) + " ";
                String text = ReferenceDataFormatDomImpl.createElementString(dataElem, referenceDataFormatElement.toString());
                if (referenceDataFormatElement.getName().equalsIgnoreCase("Title") && text.endsWith(".")) {
                    text = text.substring(0, text.length() - 1);
                }
                value = String.valueOf(value) + ReferenceDataFormatDomImpl.rtfEncode(text);
                value = String.valueOf(value) + "}";
                strBuf.append(value);
            }
            ++j;
        }
        if (strBuf.length() > 0) {
            strBuf.insert(0, "{" + font + " ");
            strBuf.append("\\par}");
        }
        outBuf.append(strBuf);
        if (fonttblBuf.length() > 0) {
            fonttblBuf.insert(0, "{\\fonttbl");
            fonttblBuf.append("}");
        }
        if (outBuf.length() > 0) {
            String head = "{\\rtf1\\ansi{\\colortbl;\\red255\\green255\\blue255;}" + fonttblBuf.toString();
            outBuf.insert(0, head);
            outBuf.append("}");
        }
        return outBuf.toString();
    }

    public static String createHTMLText(Document[] datadocs, String typename) {
        StringBuffer outBuf = new StringBuffer();
        int i = 0;
        while (i < datadocs.length) {
            Document datadoc = datadocs[i];
            if (typename == null) {
                typename = DataDomImpl.getDefaultType((Document)datadoc);
            }
            if (typename != null && typename.length() > 0) {
                Element dataElem = DataDomImpl.getDataOfType((Document)datadoc, (String)typename);
                ReferenceDataFormat format = ReferenceDataFormatDomImpl.getCurrentFormat(typename);
                if (format != null) {
                    StringBuffer strBuf = new StringBuffer();
                    ArrayList<Object> elementList = format.getElementList();
                    int j = 0;
                    while (j < elementList.size()) {
                        String value;
                        Object obj = elementList.get(j);
                        if (obj instanceof String) {
                            String value2 = (String)obj;
                            strBuf.append(value2);
                        } else if (obj instanceof ReferenceDataFormatIdentifiersElement) {
                            ReferenceDataFormatIdentifiersElement referenceDataFormatIdentifiersElement = (ReferenceDataFormatIdentifiersElement)obj;
                            value = ReferenceDataFormatDomImpl.createIdentifiersString(dataElem, referenceDataFormatIdentifiersElement.toString(), referenceDataFormatIdentifiersElement.getIdentifier());
                            if ((value = ReferenceDataFormatDomImpl.htmlEncode(value)) != null && value.length() > 0) {
                                if (referenceDataFormatIdentifiersElement.getBold()) {
                                    value = "<b>" + value + "</b>";
                                }
                                if (referenceDataFormatIdentifiersElement.getItalic()) {
                                    value = "<i>" + value + "</i>";
                                }
                                if (referenceDataFormatIdentifiersElement.getUnderline()) {
                                    value = "<u>" + value + "</u>";
                                }
                            }
                            strBuf.append(value);
                        } else if (obj instanceof ReferenceDataFormatEscapeSequenceElement) {
                            ReferenceDataFormatEscapeSequenceElement referenceDataFormatEscapeSequenceElement = (ReferenceDataFormatEscapeSequenceElement)obj;
                            value = "";
                            if (referenceDataFormatEscapeSequenceElement.getEscapeSequence().equals(ReferenceDataFormatEscapeSequenceElement.escapesequences[0])) {
                                value = "<br>";
                            } else {
                                referenceDataFormatEscapeSequenceElement.getEscapeSequence().equals(ReferenceDataFormatEscapeSequenceElement.escapesequences[1]);
                            }
                            strBuf.append(value);
                        } else if (obj instanceof ReferenceDataFormatAuthorsElement) {
                            ReferenceDataFormatAuthorsElement referenceDataFormatAuthorsElement = (ReferenceDataFormatAuthorsElement)obj;
                            value = ReferenceDataFormatDomImpl.createAuthorsString(dataElem, referenceDataFormatAuthorsElement.toString(), referenceDataFormatAuthorsElement.getFirstAuthor(), referenceDataFormatAuthorsElement.getConnectionString(), referenceDataFormatAuthorsElement.getSecondAuthor(), referenceDataFormatAuthorsElement.getConnectionLastString(), referenceDataFormatAuthorsElement.getLastAuthor());
                            if ((value = ReferenceDataFormatDomImpl.htmlEncode(value)) != null && value.length() > 0) {
                                if (referenceDataFormatAuthorsElement.getBold()) {
                                    value = "<b>" + value + "</b>";
                                }
                                if (referenceDataFormatAuthorsElement.getItalic()) {
                                    value = "<i>" + value + "</i>";
                                }
                                if (referenceDataFormatAuthorsElement.getUnderline()) {
                                    value = "<u>" + value + "</u>";
                                }
                            }
                            strBuf.append(value);
                        } else if (obj instanceof ReferenceDataFormatElement) {
                            ReferenceDataFormatElement referenceDataFormatElement = (ReferenceDataFormatElement)obj;
                            value = ReferenceDataFormatDomImpl.createElementString(dataElem, referenceDataFormatElement.toString());
                            if (referenceDataFormatElement.getName().equalsIgnoreCase("Title") && value.endsWith(".")) {
                                value = value.substring(0, value.length() - 1);
                            }
                            if ((value = ReferenceDataFormatDomImpl.htmlEncode(value)) != null && value.length() > 0) {
                                if (referenceDataFormatElement.getBold()) {
                                    value = "<b>" + value + "</b>";
                                }
                                if (referenceDataFormatElement.getItalic()) {
                                    value = "<i>" + value + "</i>";
                                }
                                if (referenceDataFormatElement.getUnderline()) {
                                    value = "<u>" + value + "</u>";
                                }
                            }
                            strBuf.append(value);
                        }
                        ++j;
                    }
                    outBuf.append(strBuf);
                    outBuf.append("<br>");
                }
            }
            ++i;
        }
        if (outBuf.length() > 0) {
            outBuf.insert(0, "<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"></head><body>");
            outBuf.append("</body></html>");
        }
        return outBuf.toString();
    }

    public static String createHTMLText(Document datadoc, String typename) {
        StringBuffer outBuf = new StringBuffer();
        if (typename == null) {
            typename = DataDomImpl.getDefaultType((Document)datadoc);
        }
        if (typename == null || typename.length() == 0) {
            return null;
        }
        Element dataElem = DataDomImpl.getDataOfType((Document)datadoc, (String)typename);
        ReferenceDataFormat format = ReferenceDataFormatDomImpl.getCurrentFormat(typename);
        if (format == null) {
            return null;
        }
        StringBuffer strBuf = new StringBuffer();
        ArrayList<Object> elementList = format.getElementList();
        int j = 0;
        while (j < elementList.size()) {
            String value;
            Object obj = elementList.get(j);
            if (obj instanceof String) {
                String value2 = (String)obj;
                strBuf.append(value2);
            } else if (obj instanceof ReferenceDataFormatIdentifiersElement) {
                ReferenceDataFormatIdentifiersElement referenceDataFormatIdentifiersElement = (ReferenceDataFormatIdentifiersElement)obj;
                value = ReferenceDataFormatDomImpl.createIdentifiersString(dataElem, referenceDataFormatIdentifiersElement.toString(), referenceDataFormatIdentifiersElement.getIdentifier());
                if ((value = ReferenceDataFormatDomImpl.htmlEncode(value)) != null && value.length() > 0) {
                    if (referenceDataFormatIdentifiersElement.getBold()) {
                        value = "<b>" + value + "</b>";
                    }
                    if (referenceDataFormatIdentifiersElement.getItalic()) {
                        value = "<i>" + value + "</i>";
                    }
                    if (referenceDataFormatIdentifiersElement.getUnderline()) {
                        value = "<u>" + value + "</u>";
                    }
                }
                strBuf.append(value);
            } else if (obj instanceof ReferenceDataFormatEscapeSequenceElement) {
                ReferenceDataFormatEscapeSequenceElement referenceDataFormatEscapeSequenceElement = (ReferenceDataFormatEscapeSequenceElement)obj;
                value = "";
                if (referenceDataFormatEscapeSequenceElement.getEscapeSequence().equals(ReferenceDataFormatEscapeSequenceElement.escapesequences[0])) {
                    value = "<br>";
                } else {
                    referenceDataFormatEscapeSequenceElement.getEscapeSequence().equals(ReferenceDataFormatEscapeSequenceElement.escapesequences[1]);
                }
                strBuf.append(value);
            } else if (obj instanceof ReferenceDataFormatAuthorsElement) {
                ReferenceDataFormatAuthorsElement referenceDataFormatAuthorsElement = (ReferenceDataFormatAuthorsElement)obj;
                value = ReferenceDataFormatDomImpl.createAuthorsString(dataElem, referenceDataFormatAuthorsElement.toString(), referenceDataFormatAuthorsElement.getFirstAuthor(), referenceDataFormatAuthorsElement.getConnectionString(), referenceDataFormatAuthorsElement.getSecondAuthor(), referenceDataFormatAuthorsElement.getConnectionLastString(), referenceDataFormatAuthorsElement.getLastAuthor());
                if ((value = ReferenceDataFormatDomImpl.htmlEncode(value)) != null && value.length() > 0) {
                    if (referenceDataFormatAuthorsElement.getBold()) {
                        value = "<b>" + value + "</b>";
                    }
                    if (referenceDataFormatAuthorsElement.getItalic()) {
                        value = "<i>" + value + "</i>";
                    }
                    if (referenceDataFormatAuthorsElement.getUnderline()) {
                        value = "<u>" + value + "</u>";
                    }
                }
                strBuf.append(value);
            } else if (obj instanceof ReferenceDataFormatElement) {
                ReferenceDataFormatElement referenceDataFormatElement = (ReferenceDataFormatElement)obj;
                value = ReferenceDataFormatDomImpl.createElementString(dataElem, referenceDataFormatElement.toString());
                if (referenceDataFormatElement.getName().equalsIgnoreCase("Title") && value.endsWith(".")) {
                    value = value.substring(0, value.length() - 1);
                }
                if ((value = ReferenceDataFormatDomImpl.htmlEncode(value)) != null && value.length() > 0) {
                    if (referenceDataFormatElement.getBold()) {
                        value = "<b>" + value + "</b>";
                    }
                    if (referenceDataFormatElement.getItalic()) {
                        value = "<i>" + value + "</i>";
                    }
                    if (referenceDataFormatElement.getUnderline()) {
                        value = "<u>" + value + "</u>";
                    }
                }
                strBuf.append(value);
            }
            ++j;
        }
        outBuf.append(strBuf);
        outBuf.append("<br>");
        if (outBuf.length() > 0) {
            outBuf.insert(0, "<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"></head><body>");
            outBuf.append("</body></html>");
        }
        return outBuf.toString();
    }

    private static String createIdentifiersString(Element dataElem, String elemName, String type) {
        String parsername;
        ITypeParser p;
        ArrayList al = null;
        String value = null;
        Element elem = DataDomImpl.getElement((Element)dataElem, (String)elemName);
        if (elem != null && (p = FrameworkPlugin.getParser((String)(parsername = DataDomImpl.getParserName((Element)elem)))) != null && p instanceof IdentifiersParser && (al = p.getIndexValues(elem, type)) != null && al.size() > 0) {
            value = (String)al.get(0);
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    private static String createAuthorsString(Element dataElem, String elemName, String firstAuthor, String connectionString, String secondAuthor, String connectionLastString, String lastAuthor) {
        String value;
        String parsername;
        ITypeParser p;
        StringBuffer strBuf = new StringBuffer();
        ArrayList al = null;
        Element elem = DataDomImpl.getElement((Element)dataElem, (String)elemName);
        if (elem != null && (p = FrameworkPlugin.getParser((String)(parsername = DataDomImpl.getParserName((Element)elem)))) != null && p instanceof AuthorsParser) {
            al = p.getMultiText(elem);
        }
        if (al != null && (value = ReferenceDataFormatDomImpl.createAuthorsString(al, firstAuthor, connectionString, secondAuthor, connectionLastString, lastAuthor)) != null) {
            strBuf.append(value);
        }
        return strBuf.toString();
    }

    private static String createElementString(Element dataElem, String elemName) {
        String parsername;
        ITypeParser p;
        StringBuffer strBuf = new StringBuffer();
        Element elem = DataDomImpl.getElement((Element)dataElem, (String)elemName);
        if (elem != null && (p = FrameworkPlugin.getParser((String)(parsername = DataDomImpl.getParserName((Element)elem)))) != null) {
            strBuf.append(p.getSingleText(elem));
        }
        return strBuf.toString();
    }

    public static String rtfEncode(String rtfStr) {
        return ReferenceDataFormatDomImpl.rtfUTFEncode(rtfStr);
    }

    public static String rtfShiftJISEncode(String rtfStr) {
        try {
            byte[] data = rtfStr.getBytes("SJIS");
            StringBuffer strBuf = new StringBuffer();
            int i = 0;
            while (i < data.length) {
                int c = data[i] & 0xFF;
                if (129 <= c && c <= 159 || 224 <= c && c <= 239 || 240 <= c && c <= 252) {
                    strBuf.append("\\");
                    strBuf.append("'");
                    strBuf.append(Integer.toHexString(c));
                    c = data[++i] & 0xFF;
                    strBuf.append("\\");
                    strBuf.append("'");
                    strBuf.append(Integer.toHexString(c));
                } else if (c == 123 || c == 125 || c == 92) {
                    strBuf.append("\\");
                    strBuf.append((char)data[i]);
                } else {
                    strBuf.append((char)data[i]);
                }
                ++i;
            }
            return strBuf.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String rtfUTFEncode(String rtfStr) {
        try {
            StringBuffer strBuf = new StringBuffer();
            int i = 0;
            while (i < rtfStr.length()) {
                char c = rtfStr.charAt(i);
                int u = c & 0xFFFF;
                strBuf.append("\\");
                strBuf.append("u");
                strBuf.append(Integer.toString(u));
                strBuf.append(' ');
                ++i;
            }
            return strBuf.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String htmlEncode(String htmlStr) {
        htmlStr = htmlStr.replaceAll("&", "&amp;");
        htmlStr = htmlStr.replaceAll("<", "&lt;");
        htmlStr = htmlStr.replaceAll(">", "&gt;");
        htmlStr = htmlStr.replaceAll("\"", "&quot;");
        htmlStr = htmlStr.replaceAll("'", "&#39;");
        return htmlStr;
    }

    private static String createAuthorsString(ArrayList<String> authorList, String firstAuthor, String connectionString, String secondAuthor, String connetionLastString, String lastAuthor) {
        StringBuffer strBuf = new StringBuffer();
        int j = 0;
        while (j < authorList.size()) {
            char initial;
            int l;
            char c;
            int k;
            if (j > 0) {
                if (j < authorList.size() - 1) {
                    strBuf.append(connetionLastString);
                } else {
                    strBuf.append(connectionString);
                }
            }
            ArrayList<String> vl = new ArrayList<String>();
            String[] vals = authorList.get(j).split(" ");
            int i = 0;
            while (i < vals.length) {
                String val = vals[i].trim();
                if (val.length() > 0) {
                    vl.add(val);
                }
                ++i;
            }
            String lastname = "";
            if (vl.size() >= 2) {
                int i2 = 0;
                while (i2 < vl.size() - 1) {
                    if (i2 != 0) {
                        lastname = String.valueOf(lastname) + " ";
                    }
                    lastname = String.valueOf(lastname) + (String)vl.get(i2);
                    ++i2;
                }
            } else if (vl.size() == 1) {
                lastname = (String)vl.get(0);
            }
            String firstname = vl.size() > 1 ? (String)vl.get(vl.size() - 1) : "";
            String middlename = "";
            if (j == 0) {
                k = 0;
                while (k < firstAuthor.length()) {
                    c = firstAuthor.charAt(k);
                    if ('L' == c) {
                        if (firstAuthor.startsWith("LAST", k)) {
                            strBuf.append(lastname.toUpperCase());
                            k += 4;
                            continue;
                        }
                        if (firstAuthor.startsWith("Last", k)) {
                            strBuf.append(lastname);
                            k += 4;
                            continue;
                        }
                        l = 0;
                        while (l < lastname.length()) {
                            initial = lastname.charAt(l);
                            if ('A' > c || c > 'Z') break;
                            strBuf.append(initial);
                            ++l;
                        }
                        ++k;
                        continue;
                    }
                    if ('F' == c) {
                        if (firstAuthor.startsWith("FIRST", k)) {
                            strBuf.append(firstname.toUpperCase());
                            k += 4;
                            continue;
                        }
                        if (firstAuthor.startsWith("First", k)) {
                            strBuf.append(firstname);
                            k += 4;
                            continue;
                        }
                        l = 0;
                        while (l < firstname.length()) {
                            initial = firstname.charAt(l);
                            if ('A' > c || c > 'Z') break;
                            strBuf.append(initial);
                            ++l;
                        }
                        ++k;
                        continue;
                    }
                    if ('M' == c) {
                        if (firstAuthor.startsWith("MIDDLE", k)) {
                            strBuf.append(middlename.toUpperCase());
                            k += 4;
                            continue;
                        }
                        if (firstAuthor.startsWith("Middle", k)) {
                            strBuf.append(middlename);
                            k += 4;
                            continue;
                        }
                        l = 0;
                        while (l < middlename.length()) {
                            initial = middlename.charAt(l);
                            if ('A' > c || c > 'Z') break;
                            strBuf.append(initial);
                            ++l;
                        }
                        ++k;
                        continue;
                    }
                    strBuf.append(c);
                    ++k;
                }
            } else if (j == authorList.size() - 1) {
                k = 0;
                while (k < lastAuthor.length()) {
                    c = lastAuthor.charAt(k);
                    if ('L' == c) {
                        if (lastAuthor.startsWith("LAST", k)) {
                            strBuf.append(lastname.toUpperCase());
                            k += 4;
                            continue;
                        }
                        if (lastAuthor.startsWith("Last", k)) {
                            strBuf.append(lastname);
                            k += 4;
                            continue;
                        }
                        l = 0;
                        while (l < lastname.length()) {
                            initial = lastname.charAt(l);
                            if ('A' > c || c > 'Z') break;
                            strBuf.append(initial);
                            ++l;
                        }
                        ++k;
                        continue;
                    }
                    if ('F' == c) {
                        if (lastAuthor.startsWith("FIRST", k)) {
                            strBuf.append(firstname.toUpperCase());
                            k += 5;
                            continue;
                        }
                        if (lastAuthor.startsWith("First", k)) {
                            strBuf.append(firstname);
                            k += 5;
                            continue;
                        }
                        l = 0;
                        while (l < firstname.length()) {
                            initial = firstname.charAt(l);
                            if ('A' > c || c > 'Z') break;
                            strBuf.append(initial);
                            ++l;
                        }
                        ++k;
                        continue;
                    }
                    if ('M' == c) {
                        if (lastAuthor.startsWith("MIDDLE", k)) {
                            strBuf.append(middlename.toUpperCase());
                            k += 6;
                            continue;
                        }
                        if (lastAuthor.startsWith("Middle", k)) {
                            strBuf.append(middlename);
                            k += 6;
                            continue;
                        }
                        l = 0;
                        while (l < middlename.length()) {
                            initial = middlename.charAt(l);
                            if ('A' > c || c > 'Z') break;
                            strBuf.append(initial);
                            ++l;
                        }
                        ++k;
                        continue;
                    }
                    strBuf.append(c);
                    ++k;
                }
            } else {
                k = 0;
                while (k < secondAuthor.length()) {
                    c = secondAuthor.charAt(k);
                    if ('L' == c) {
                        if (secondAuthor.startsWith("LAST", k)) {
                            strBuf.append(lastname.toUpperCase());
                            k += 4;
                            continue;
                        }
                        if (secondAuthor.startsWith("Last", k)) {
                            strBuf.append(lastname);
                            k += 4;
                            continue;
                        }
                        l = 0;
                        while (l < lastname.length()) {
                            initial = lastname.charAt(l);
                            if ('A' > c || c > 'Z') break;
                            strBuf.append(initial);
                            ++l;
                        }
                        ++k;
                        continue;
                    }
                    if ('F' == c) {
                        if (secondAuthor.startsWith("FIRST", k)) {
                            strBuf.append(firstname.toUpperCase());
                            k += 5;
                            continue;
                        }
                        if (secondAuthor.startsWith("First", k)) {
                            strBuf.append(firstname);
                            k += 5;
                            continue;
                        }
                        l = 0;
                        while (l < firstname.length()) {
                            initial = firstname.charAt(l);
                            if ('A' > c || c > 'Z') break;
                            strBuf.append(initial);
                            ++l;
                        }
                        ++k;
                        continue;
                    }
                    if ('M' == c) {
                        if (secondAuthor.startsWith("MIDDLE", k)) {
                            strBuf.append(middlename.toUpperCase());
                            k += 6;
                            continue;
                        }
                        if (secondAuthor.startsWith("Middle", k)) {
                            strBuf.append(middlename);
                            k += 6;
                            continue;
                        }
                        l = 0;
                        while (l < middlename.length()) {
                            initial = middlename.charAt(l);
                            if ('A' > c || c > 'Z') break;
                            strBuf.append(initial);
                            ++l;
                        }
                        ++k;
                        continue;
                    }
                    strBuf.append(c);
                    ++k;
                }
            }
            ++j;
        }
        return strBuf.toString();
    }
}

