/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.ibooks;

import java.util.ArrayList;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.TypeDomImpl;
import jp.sourceforge.concierge.mdocument.TypeManager;
import jp.sourceforge.concierge.parser.ITypeParser;
import jp.sourceforge.concierge.plugin.iBooksPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConciergeAdapter {
    public static final String TYPEDOCNAME = "Book";
    public static final String REQUIRED_PARSERS = "text, authors, keywords";

    public static boolean isReady(Object sender) {
        String[] request = REQUIRED_PARSERS.split(",");
        int i = 0;
        while (i < request.length) {
            if (!FrameworkPlugin.containsParser((String)request[i].trim())) {
                return false;
            }
            ++i;
        }
        Document tdoc = TypeManager.getTypeDocument((String)TYPEDOCNAME);
        if (tdoc == null) {
            tdoc = TypeDomImpl.createDocument((String)TYPEDOCNAME);
            TypeDomImpl.setPluginID((Document)tdoc, (String)iBooksPlugin.getDefault().getBundle().getSymbolicName());
            TypeDomImpl.setVersion((Document)tdoc, (String)"0.0.0");
            TypeDomImpl.appendElement((Document)tdoc, (String)"Title", (String)"text", (boolean)true, (boolean)false, (boolean)true);
            TypeDomImpl.appendElement((Document)tdoc, (String)"Author", (String)"authors", (boolean)true, (boolean)false, (boolean)true);
            TypeDomImpl.appendElement((Document)tdoc, (String)"Publisher", (String)"text", (boolean)true, (boolean)false, (boolean)true);
            TypeDomImpl.appendElement((Document)tdoc, (String)"Year", (String)"text", (boolean)true, (boolean)false, (boolean)true);
            TypeDomImpl.appendElement((Document)tdoc, (String)"Category", (String)"text", (boolean)true, (boolean)false, (boolean)true);
            TypeDomImpl.appendElement((Document)tdoc, (String)"Price", (String)"text", (boolean)true, (boolean)false, (boolean)false);
            TypeDomImpl.appendElement((Document)tdoc, (String)"ISBN", (String)"text", (boolean)true, (boolean)false, (boolean)false);
            TypeDomImpl.appendElement((Document)tdoc, (String)"URL", (String)"text", (boolean)true, (boolean)false, (boolean)false);
            TypeDomImpl.appendElement((Document)tdoc, (String)"Keywords", (String)"keywords", (boolean)true, (boolean)true, (boolean)true);
            TypeDomImpl.appendElement((Document)tdoc, (String)"Comment", (String)"text", (boolean)true, (boolean)true, (boolean)false);
            TypeDomImpl.setImage((Document)tdoc, (String)iBooksPlugin.getPluginFilePath("icons/ibook.png"));
            Request rq = new Request(1, (Object)tdoc, "type");
            ArrayList<Request> rqs = new ArrayList<Request>();
            rqs.add(rq);
            FrameworkPlugin.updateDocuments(rqs, (Object)sender);
        } else {
            String version = TypeDomImpl.getVersion((Document)tdoc);
            if (version.length() == 0) {
                TypeDomImpl.setVersion((Document)tdoc, (String)"0.0.0");
                String pluginid = TypeDomImpl.getPluginID((Document)tdoc);
                if (pluginid == null) {
                    TypeDomImpl.setPluginID((Document)tdoc, (String)iBooksPlugin.getDefault().getBundle().getSymbolicName());
                } else if (pluginid.length() == 0) {
                    TypeDomImpl.setPluginID((Document)tdoc, (String)iBooksPlugin.getDefault().getBundle().getSymbolicName());
                }
                Element e = TypeDomImpl.getElement((Document)tdoc, (String)"URL");
                if (e != null) {
                    String typename = "text";
                    ITypeParser parser = FrameworkPlugin.getParser((String)typename);
                    String namespace = parser.getParserNS();
                    String ns_prefix = parser.getParserNSPrefix();
                    TypeDomImpl.setParser((Element)e, (String)typename);
                    TypeDomImpl.setParserNS((Element)e, (String)namespace);
                    TypeDomImpl.setParserNSPrefix((Element)e, (String)ns_prefix);
                }
                Request rq = new Request(3, (Object)tdoc, "type");
                ArrayList<Request> rqs = new ArrayList<Request>();
                rqs.add(rq);
                TypeDomImpl.setImage((Document)tdoc, (String)iBooksPlugin.getPluginFilePath("icons/ibook.png"));
                rq = new Request();
                rq.collection = "data";
                rq.command = 4;
                rq.options = 0;
                String xpath = "/mdata/data[@name='Book']";
                rq.data = xpath;
                ArrayList datas = FrameworkPlugin.getDocumentsOfQuery((Request)rq);
                int i2 = 0;
                while (i2 < datas.size()) {
                    Document ddoc = (Document)datas.get(i2);
                    DataDomImpl.addNamespace((Document)ddoc, (Document)tdoc);
                    Element elem1 = DataDomImpl.getElement((Document)ddoc, (String)"URL", (String)TYPEDOCNAME);
                    if (elem1 != null) {
                        ArrayList oldList = DataDomImpl.getElements((Element)elem1, (String)"address", (String)"url");
                        String out = "";
                        if (oldList.size() > 0) {
                            Element elem2 = (Element)oldList.get(0);
                            out = DataDomImpl.getElementText((Element)elem2);
                        }
                        DataDomImpl.removeAllChildren((Element)elem1);
                        elem1.setAttribute("parser", "text");
                        ITypeParser p = FrameworkPlugin.getParser((String)"text");
                        if (p != null) {
                            p.putToElement(elem1, out);
                        }
                    }
                    rq = new Request(3, (Object)ddoc, "data");
                    rqs.add(rq);
                    ++i2;
                }
                if (rqs.size() > 0) {
                    FrameworkPlugin.updateDocuments(rqs, (Object)sender);
                }
            }
        }
        return true;
    }
}

