/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.imageviewer;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;

public class ControlUtils {
    private static int getPositionFromScrollBar(int size, ScrollBar sb) {
        if (sb == null) {
            return 0;
        }
        return sb.getSelection();
    }

    public static Point getLeftTopPosition(Control ctrl) {
        if (ctrl instanceof StyledText) {
            int pos = ((StyledText)ctrl).getTopPixel();
            return new Point(0, pos);
        }
        if (ctrl instanceof Scrollable) {
            Scrollable sctrl = (Scrollable)ctrl;
            ScrollBar hsb = sctrl.getHorizontalBar();
            ScrollBar vsb = sctrl.getVerticalBar();
            Point sz = sctrl.getSize();
            int xpos = ControlUtils.getPositionFromScrollBar(sz.x, hsb);
            int ypos = ControlUtils.getPositionFromScrollBar(sz.y, vsb);
            return new Point(xpos, ypos);
        }
        return new Point(0, 0);
    }

    public static void setCursor(Control ctrl, Cursor cursor) {
        if (ctrl instanceof StyledText) {
            ((StyledText)ctrl).setCursor(cursor);
        } else {
            ctrl.setCursor(cursor);
        }
    }
}

