/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.comm;

import java.util.HashMap;
import jp.co.connectone.comm.CmdBase;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.IRecordObject;
import jp.co.connectone.store.ISearchDestination;
import jp.co.connectone.store.ISearchFormula;
import jp.co.connectone.store.pim.IAddressBookStore;
import jp.co.connectone.store.pim.IAddressDTO;
import jp.co.connectone.user.IAccountData;

public class AddressBookStoreCmd
extends CmdBase {
    public static final AddressBookStoreCmd createNewAddressBookItem = new AddressBookStoreCmd();
    public static final AddressBookStoreCmd getAddressBookItem = new AddressBookStoreCmd();
    public static final AddressBookStoreCmd getAddressBookItems = new AddressBookStoreCmd();
    public static final AddressBookStoreCmd searchAddressBook = new AddressBookStoreCmd();
    public static final AddressBookStoreCmd updateAddressBookItem = new AddressBookStoreCmd();
    public static final AddressBookStoreCmd deleteAddressBookItem = new AddressBookStoreCmd();

    protected AddressBookStoreCmd() {
    }

    public AddressBookStoreCmd(IAccountData accData, String remoteClassName, CmdBase cmd, HashMap params) {
        super(accData, remoteClassName, cmd, params);
    }

    public int getRetType() throws HandleException {
        try {
            return super.getRetType();
        }
        catch (HandleException handleException) {
            if (this.cmd == deleteAddressBookItem || this.cmd == updateAddressBookItem) {
                return 0;
            }
            if (this.cmd == getAddressBookItems || this.cmd == searchAddressBook) {
                return 2;
            }
            if (this.cmd == createNewAddressBookItem || this.cmd == getAddressBookItem) {
                return 1;
            }
            throw new HandleException("unknown cmd type.");
        }
    }

    public IRecordObject[] runMulti() throws HandleException {
        IRecordObject[] rc = null;
        IAddressBookStore remoteClass = (IAddressBookStore)this.getRemoteClass();
        if (this.cmd == searchAddressBook) {
            ISearchFormula param1 = (ISearchFormula)this.params.get("param1");
            rc = remoteClass.searchAddressBook(this.accData, param1);
        } else if (this.cmd == getAddressBookItems) {
            ISearchDestination param1 = (ISearchDestination)this.params.get("param1");
            rc = remoteClass.getAddressBookItems(this.accData, param1);
        } else {
            throw new HandleException("unknown cmd type.");
        }
        return rc;
    }

    public IRecordObject runSingle() throws HandleException {
        Object param2;
        ISearchDestination param1;
        IRecordObject rc = null;
        IAddressBookStore remoteClass = (IAddressBookStore)this.getRemoteClass();
        if (this.cmd == createNewAddressBookItem) {
            param1 = (ISearchDestination)this.params.get("param1");
            param2 = (IAddressDTO)this.params.get("param2");
            rc = remoteClass.createNewAddressBookItem(this.accData, param1, (IAddressDTO)param2);
        }
        if (this.cmd != getAddressBookItem) {
            throw new HandleException("unknown cmd type.");
        }
        param1 = (ISearchDestination)this.params.get("param1");
        param2 = (IObjectIndex)this.params.get("param2");
        rc = remoteClass.getAddressBookItem(this.accData, param1, (IObjectIndex)param2);
        return rc;
    }

    public void runVoid() throws HandleException {
        IAddressBookStore remoteClass = (IAddressBookStore)this.getRemoteClass();
        if (this.cmd == deleteAddressBookItem) {
            ISearchDestination param1 = (ISearchDestination)this.params.get("param1");
            IObjectIndex param2 = (IObjectIndex)this.params.get("param2");
            remoteClass.deleteAddressBookItem(this.accData, param1, param2);
        } else if (this.cmd == updateAddressBookItem) {
            ISearchDestination param1 = (ISearchDestination)this.params.get("param1");
            IAddressDTO param2 = (IAddressDTO)this.params.get("param2");
            remoteClass.updateAddressBookItem(this.accData, param1, param2);
        } else {
            throw new HandleException("unknown cmd type.");
        }
    }
}

