/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.common;

import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class ADTool {
    private DirContext ctx = null;

    public NamingEnumeration getExchServerContext(String serverName) throws Exception {
        NamingEnumeration rootDSN = this.getRootDSN(serverName);
        if (rootDSN == null) {
            return null;
        }
        SearchResult aResult = (SearchResult)rootDSN.nextElement();
        String contextLabel = aResult.getAttributes().get("configurationNamingContext").get(0).toString();
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://" + serverName + "/" + contextLabel);
        env.put("java.naming.referral", "throw");
        this.ctx = new InitialDirContext(env);
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        NamingEnumeration<SearchResult> results = this.ctx.search("", "objectCategory=msExchExchangeServer", constraints);
        return results;
    }

    public NamingEnumeration getRootDSN(String serverName) throws Exception {
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://" + serverName + "/");
        env.put("java.naming.referral", "throw");
        this.ctx = new InitialDirContext(env);
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(0);
        NamingEnumeration<SearchResult> results = this.ctx.search("", "objectclass=*", constraints);
        return results;
    }

    public NamingEnumeration getUserDatas(String userID, String password, String serverName, String domain, String whereStr) throws Exception {
        NamingEnumeration<SearchResult> retStr = null;
        if (userID == null) {
            return retStr;
        }
        if (password == null) {
            return retStr;
        }
        Properties env = new Properties();
        env.put("java.naming.security.principal", String.valueOf(userID) + "@" + domain);
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://" + serverName + "/");
        env.put("java.naming.referral", "follow");
        this.ctx = new InitialDirContext(env);
        SearchControls constraints = new SearchControls();
        constraints.setTimeLimit(10000);
        constraints.setSearchScope(2);
        String searchDomain = domain.replaceAll("\\.", ",dc=");
        String searchStr = "(& (mailnickname=*) (| (&(objectCategory=person)(objectClass=user)(!(homeMDB=*))(!(msExchHomeServerName=*)))(&(objectCategory=person)(objectClass=user)(|(homeMDB=*)(msExchHomeServerName=*)))(&(objectCategory=person)(objectClass=contact))(objectCategory=group)(objectCategory=publicFolder) )" + whereStr + ")";
        retStr = this.ctx.search("dc=" + searchDomain, searchStr, constraints);
        this.ctx.close();
        return retStr;
    }

    public NamingEnumeration getUserDetail(String userID, String password, String serverName, String domain) throws Exception {
        NamingEnumeration<SearchResult> retStr = null;
        if (userID == null) {
            return retStr;
        }
        if (password == null) {
            return retStr;
        }
        String searchDomain = domain.replaceAll("\\.", ",dc=");
        Properties env = new Properties();
        env.put("java.naming.security.principal", String.valueOf(userID) + "@" + domain);
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://" + serverName + "/");
        env.put("java.naming.referral", "follow");
        this.ctx = new InitialDirContext(env);
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        retStr = this.ctx.search("dc=" + searchDomain, "sAMAccountName=" + userID, constraints);
        return retStr;
    }

    public NamingEnumeration getOtherUserDetail(String idToSee, String userID, String password, String serverName, String domain) throws Exception {
        NamingEnumeration<SearchResult> retStr = null;
        if (userID == null) {
            return retStr;
        }
        if (password == null) {
            return retStr;
        }
        String searchDomain = domain.replaceAll("\\.", ",dc=");
        Properties env = new Properties();
        env.put("java.naming.security.principal", String.valueOf(userID) + "@" + domain);
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://" + serverName + "/");
        env.put("java.naming.referral", "follow");
        this.ctx = new InitialDirContext(env);
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        constraints.setCountLimit(1L);
        retStr = this.ctx.search("dc=" + searchDomain, "sAMAccountName=" + idToSee, constraints);
        return retStr;
    }
}

