/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.store.client;

import java.util.HashMap;
import jp.co.connectone.comm.AddressBookStoreCmd;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.IRecordObject;
import jp.co.connectone.store.ISearchDestination;
import jp.co.connectone.store.ISearchFormula;
import jp.co.connectone.store.client.IAddressBookStoreClient;
import jp.co.connectone.store.client.StoreClient;
import jp.co.connectone.store.pim.IAddressDTO;

public class AddressBookStoreClient
extends StoreClient
implements IAddressBookStoreClient {
    public IRecordObject createNewAddressBookItem(ISearchDestination dest, IAddressDTO addressBookDTO) throws Exception {
        HashMap<String, IRecordObject> params = new HashMap<String, IRecordObject>();
        params.put("param1", dest);
        params.put("param2", addressBookDTO);
        AddressBookStoreCmd cmd = new AddressBookStoreCmd(this.userAccount, this.remoteClassName, AddressBookStoreCmd.createNewAddressBookItem, params);
        this.protocol.functionCall(cmd);
        IRecordObject ret = this.protocol.getReturnSingle();
        return ret;
    }

    public IAddressDTO[] getAddressBookItems(ISearchDestination dest) throws Exception {
        HashMap<String, ISearchDestination> params = new HashMap<String, ISearchDestination>();
        params.put("param1", dest);
        AddressBookStoreCmd cmd = new AddressBookStoreCmd(this.userAccount, this.remoteClassName, AddressBookStoreCmd.getAddressBookItems, params);
        this.protocol.functionCall(cmd);
        IAddressDTO[] ret = (IAddressDTO[])this.protocol.getReturnMulti();
        return ret;
    }

    public IAddressDTO getAddressBookItem(ISearchDestination dest, IObjectIndex oid) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("param1", dest);
        params.put("param2", oid);
        AddressBookStoreCmd cmd = new AddressBookStoreCmd(this.userAccount, this.remoteClassName, AddressBookStoreCmd.getAddressBookItem, params);
        this.protocol.functionCall(cmd);
        IAddressDTO ret = (IAddressDTO)this.protocol.getReturnSingle();
        return ret;
    }

    public void updateAddressBookItem(ISearchDestination dest, IAddressDTO addressBookDTO) throws Exception {
        HashMap<String, IRecordObject> params = new HashMap<String, IRecordObject>();
        params.put("param1", dest);
        params.put("param2", addressBookDTO);
        AddressBookStoreCmd cmd = new AddressBookStoreCmd(this.userAccount, this.remoteClassName, AddressBookStoreCmd.updateAddressBookItem, params);
        this.protocol.functionCall(cmd);
    }

    public IAddressDTO[] searchAddressBook(ISearchFormula conds) throws Exception {
        HashMap<String, ISearchFormula> params = new HashMap<String, ISearchFormula>();
        params.put("param1", conds);
        AddressBookStoreCmd cmd = new AddressBookStoreCmd(this.userAccount, this.remoteClassName, AddressBookStoreCmd.searchAddressBook, params);
        this.protocol.functionCall(cmd);
        IAddressDTO[] ret = (IAddressDTO[])this.protocol.getReturnMulti();
        return ret;
    }

    public void deleteAddressBookItem(ISearchDestination dest, IObjectIndex oid) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("param1", dest);
        params.put("param2", oid);
        AddressBookStoreCmd cmd = new AddressBookStoreCmd(this.userAccount, this.remoteClassName, AddressBookStoreCmd.deleteAddressBookItem, params);
        this.protocol.functionCall(cmd);
    }
}

