/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.store.client;

import java.util.Date;
import java.util.HashMap;
import jp.co.connectone.comm.MailStoreCmd;
import jp.co.connectone.store.FolderMetadata;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.IRecordObject;
import jp.co.connectone.store.ISearchDestination;
import jp.co.connectone.store.client.IMailStoreClient;
import jp.co.connectone.store.client.StoreClient;
import jp.co.connectone.store.pim.IMailDTO;

public abstract class MailStoreClient
extends StoreClient
implements IMailStoreClient {
    public FolderMetadata[] getMailFolders(ISearchDestination dest) throws Exception {
        HashMap<String, ISearchDestination> params = new HashMap<String, ISearchDestination>();
        params.put("param1", dest);
        MailStoreCmd cmd = new MailStoreCmd(this.userAccount, this.remoteClassName, MailStoreCmd.getMailFolders, params);
        this.protocol.functionCall(cmd);
        FolderMetadata[] ret = (FolderMetadata[])this.protocol.getReturnMulti();
        return ret;
    }

    public IMailDTO[] getHeaders(ISearchDestination dest) throws Exception {
        HashMap<String, ISearchDestination> params = new HashMap<String, ISearchDestination>();
        params.put("param1", dest);
        MailStoreCmd cmd = new MailStoreCmd(this.userAccount, this.remoteClassName, MailStoreCmd.getHeaders, params);
        this.protocol.functionCall(cmd);
        IMailDTO[] ret = (IMailDTO[])this.protocol.getReturnMulti();
        return ret;
    }

    public IMailDTO[] getHeadersByDate(ISearchDestination dest, Date lastDate) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("param1", dest);
        params.put("param2", lastDate);
        MailStoreCmd cmd = new MailStoreCmd(this.userAccount, this.remoteClassName, MailStoreCmd.getHeadersByDate, params);
        this.protocol.functionCall(cmd);
        IMailDTO[] ret = (IMailDTO[])this.protocol.getReturnMulti();
        return ret;
    }

    public String[] getUIDLs(ISearchDestination dest) throws Exception {
        HashMap<String, ISearchDestination> params = new HashMap<String, ISearchDestination>();
        params.put("param1", dest);
        MailStoreCmd cmd = new MailStoreCmd(this.userAccount, this.remoteClassName, MailStoreCmd.getUIDLs, params);
        this.protocol.functionCall(cmd);
        IRecordObject[] ret = this.protocol.getReturnMulti();
        String[] ret2 = new String[ret.length];
        int i = 0;
        while (i < ret.length) {
            ret2[i] = (String)ret[i].getOid().getIndex();
            ++i;
        }
        return ret2;
    }

    public String[] getUIDLsByDate(ISearchDestination dest, Date lastDate) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("param1", dest);
        params.put("param2", lastDate);
        MailStoreCmd cmd = new MailStoreCmd(this.userAccount, this.remoteClassName, MailStoreCmd.getUIDLs, params);
        this.protocol.functionCall(cmd);
        IRecordObject[] ret = this.protocol.getReturnMulti();
        String[] ret2 = new String[ret.length];
        int i = 0;
        while (i < ret.length) {
            ret2[i] = (String)ret[i].getOid().getIndex();
            ++i;
        }
        return ret2;
    }

    public IMailDTO getMail(ISearchDestination dest, IObjectIndex oid) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("param1", dest);
        params.put("param2", oid);
        MailStoreCmd cmd = new MailStoreCmd(this.userAccount, this.remoteClassName, MailStoreCmd.getMail, params);
        this.protocol.functionCall(cmd);
        IMailDTO ret = (IMailDTO)this.protocol.getReturnSingle();
        return ret;
    }

    public IMailDTO[] getMailsByDate(ISearchDestination dest, Date dateObj) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("param1", dest);
        params.put("param2", dateObj);
        MailStoreCmd cmd = new MailStoreCmd(this.userAccount, this.remoteClassName, MailStoreCmd.getMailsByDate, params);
        this.protocol.functionCall(cmd);
        IMailDTO[] ret = (IMailDTO[])this.protocol.getReturnMulti();
        return ret;
    }

    public IMailDTO[] getSentMails() throws Exception {
        HashMap params = new HashMap();
        MailStoreCmd cmd = new MailStoreCmd(this.userAccount, this.remoteClassName, MailStoreCmd.getSentMails, params);
        this.protocol.functionCall(cmd);
        IMailDTO[] ret = (IMailDTO[])this.protocol.getReturnMulti();
        return ret;
    }

    public IMailDTO[] getSentMailsByDate(Date dateObj) throws Exception {
        HashMap<String, Date> params = new HashMap<String, Date>();
        params.put("param1", dateObj);
        MailStoreCmd cmd = new MailStoreCmd(this.userAccount, this.remoteClassName, MailStoreCmd.getSentMailsByDate, params);
        this.protocol.functionCall(cmd);
        IMailDTO[] ret = (IMailDTO[])this.protocol.getReturnMulti();
        return ret;
    }

    public void sendMail(IMailDTO mailDTOobj) throws Exception {
        HashMap<String, IMailDTO> params = new HashMap<String, IMailDTO>();
        params.put("param1", mailDTOobj);
        MailStoreCmd cmd = new MailStoreCmd(this.userAccount, this.remoteClassName, MailStoreCmd.sendMail, params);
        this.protocol.functionCall(cmd);
    }

    public void deleteMail(IObjectIndex oid) throws Exception {
        HashMap<String, IObjectIndex> params = new HashMap<String, IObjectIndex>();
        params.put("param1", oid);
        MailStoreCmd cmd = new MailStoreCmd(this.userAccount, this.remoteClassName, MailStoreCmd.deleteMail, params);
        this.protocol.functionCall(cmd);
    }
}

