/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.store.pim;

import java.util.Comparator;
import java.util.Date;
import jp.co.connectone.store.pim.IMemoDTO;

public class IMemoDTOComparator
implements Comparator {
    public static final int SUBJECT = 0;
    public static final int BODY = 1;
    public static final int UPDATEDATE = 2;
    private int sortKey = 0;
    private boolean reverce = false;

    public IMemoDTOComparator(int sortKey, boolean isReverce) {
        this.sortKey = sortKey;
        this.reverce = isReverce;
    }

    public int compare(Object o1, Object o2) {
        if (o1 == null) {
            return 0;
        }
        if (o2 == null) {
            return 0;
        }
        if (!(o1 instanceof IMemoDTO)) {
            return 0;
        }
        if (!(o2 instanceof IMemoDTO)) {
            return 0;
        }
        IMemoDTO src = (IMemoDTO)o1;
        IMemoDTO dst = (IMemoDTO)o2;
        switch (this.sortKey) {
            case 0: {
                String s1 = src.getSubject();
                String s2 = dst.getSubject();
                if (this.reverce) {
                    return s2.compareTo(s1);
                }
                return s1.compareTo(s2);
            }
            case 1: {
                String s1 = src.getBody();
                String s2 = dst.getBody();
                if (this.reverce) {
                    return s2.compareTo(s1);
                }
                return s1.compareTo(s2);
            }
            case 2: {
                Date d1 = src.getDate();
                Date d2 = dst.getDate();
                if (this.reverce) {
                    return d2.compareTo(d1);
                }
                return d1.compareTo(d2);
            }
        }
        return 0;
    }
}

