<?php
/**
 * CSSJ\u30c9\u30e9\u30a4\u30d0\u3067\u3059\u3002
 *
 * @package cssj
 * @subpackage driver
 * @example ../examples/client_resource.php \u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u5074\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u5909\u63db\u3059\u308b
 * @example ../examples/server_resource.php \u30b5\u30fc\u30d0\u30fc\u5074\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u5909\u63db\u3059\u308b
 * @example ../examples/ob.php \u51fa\u529b\u30d0\u30c3\u30d5\u30a1\u3092\u5909\u63db\u3059\u308b
 * @example ../examples/var.php \u5909\u6570\u304b\u3089\u5909\u6570\u3078\u5909\u63db\u3059\u308b
 * @example ../examples/file.php \u4e00\u65e6\u30d5\u30a1\u30a4\u30eb\u306b\u51fa\u529b\u3057\u3066\u30ea\u30c0\u30a4\u30ec\u30af\u30c8\u3059\u308b
 */

/**
 * \u30d7\u30ed\u30c8\u30b3\u30eb\u30ec\u30d9\u30eb\u306e\u51e6\u7406\u306fctip\u30b5\u30d6\u30d1\u30c3\u30b1\u30fc\u30b8\u304c\u884c\u3044\u307e\u3059\u3002
 */
require_once ('cssj_ctip.php');

/**
 * \u30a8\u30e9\u30fc\u30ec\u30d9\u30eb\u5b9a\u6570:\u8b66\u544a
 *
 * @access public
 */
define ('CSSJ_WARN', 1);
/**
 * \u30a8\u30e9\u30fc\u30ec\u30d9\u30eb\u5b9a\u6570:\u30a8\u30e9\u30fc
 *
 * @access public
 */
define ('CSSJ_ERROR', 2);
/**
 * \u30a8\u30e9\u30fc\u30ec\u30d9\u30eb\u5b9a\u6570:\u81f4\u547d\u7684\u30a8\u30e9\u30fc
 *
 * @access public
 */
define ('CSSJ_FATAL', 3);
/**
 * \u30a8\u30e9\u30fc\u30ec\u30d9\u30eb\u5b9a\u6570:\u60c5\u5831
 *
 * @access public
 */
define ('CSSJ_INFO', 4);

/**
 * \u6307\u5b9a\u3055\u308c\u305f\u30db\u30b9\u30c8\u30fb\u30dd\u30fc\u30c8\u306b\u63a5\u7d9a\u3059\u308b\u305f\u3081\u306e\u30c9\u30e9\u30a4\u30d0\u3092\u8fd4\u3057\u307e\u3059\u3002
 * 
 * @access public
 * @param $host string \u63a5\u7d9a\u5148\u30db\u30b9\u30c8
 * @param $port int \u63a5\u7d9a\u5148\u30dd\u30fc\u30c8
 * @param $encoding string \u6587\u5b57\u306e\u3084\u308a\u3068\u308a\u306b\u4f7f\u3046\u30ad\u30e3\u30e9\u30af\u30bf\u30fb\u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0\u540d
 * @return mixed \u30c9\u30e9\u30a4\u30d0
 */
function &cssj_create_driver_for($host, $port, $encoding = 'ISO-8859-1') {
  $driver = array(
    'host' => $host,
    'port' => $port,
    'encoding' => $encoding
  );
  return $driver;
}

/**
 * \u30bb\u30c3\u30b7\u30e7\u30f3\u3092\u4f5c\u6210\u3057\u307e\u3059\u3002
 * 
 * @access public
 * @param $driver mixed \u30c9\u30e9\u30a4\u30d0
 * @param $user string \u30e6\u30fc\u30b6\u30fcID
 * @param $password string \u30d1\u30b9\u30ef\u30fc\u30c9
 * @return mixed \u30bb\u30c3\u30b7\u30e7\u30f3,\u30a8\u30e9\u30fc\u306e\u5834\u5408\u306ffalse
 */
function &cssj_create_session(&$driver, $user, $password) {
  if (($fp = fsockopen($driver['host'], $driver['port'], $errno, $errmsg)) === false) {
    trigger_error (__FUNCTION__.": socket_connect() failed: $errno / $errmsg", E_USER_ERROR);
    return false;
  }
  $session = array(
    'state' => 1,
    'driver' => &$driver,
    'out' => null,
    'fp' => &$fp,
    'errorFunc' => null,
    'progressFunc' => null
  );
  if (cssj_ctip_connect($fp, $driver['encoding']) === false) {
    return false;
  }
  if (cssj_ctip_req_property($fp, 'ctip.auth', 'PLAIN:'.$user.chr(0x0A).$password) === false) {
	  return false;
  }
  if (($response = cssj_ctip_res_next($fp)) === false) {
	  return false;
  }
  if ($response['type'] !== CSSJ_CTIP_RES_ERROR) {
	  return false;
  }
  if ($response['error'] !== 'OK') {
	  trigger_error (__FUNCTION__.": Authentication failed.", E_USER_ERROR);
	  return false;
  }
  return $session;
}

/**
 * \u5909\u63db\u7d50\u679c\u306e\u51fa\u529b\u5148\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002
 *
 * cssj_format_main\u304a\u3088\u3073cssj_ob_start_main\u306e\u524d\u306b\u547c\u3073\u51fa\u3057\u3066\u304f\u3060\u3055\u3044\u3002
 * \u3053\u306e\u95a2\u6570\u3092\u547c\u3073\u51fa\u3055\u306a\u3044\u5834\u5408\u3001\u51fa\u529b\u5148\u306fnull(\u6a19\u6e96\u51fa\u529b)\u306b\u306a\u308a\u307e\u3059\u3002
 * \u51fa\u529b\u5148\u304cnull\u306e\u5834\u5408\u3001header()\u95a2\u6570\u306b\u3088\u308aContent-Length\u30d8\u30c3\u30c0\u304c\u8a2d\u5b9a\u3055\u308c\u307e\u3059\u3002
 * 
 * @access public
 * @param $session mixed \u30bb\u30c3\u30b7\u30e7\u30f3
 * @param $out mixed \u51fa\u529b\u5148\u30b9\u30c8\u30ea\u30fc\u30e0(resource),\u51fa\u529b\u5148\u5909\u6570(string),\u307e\u305f\u306f\u6a19\u6e96\u51fa\u529b\u3067\u3042\u308c\u3070null\u3002
 * @param $mimeType \u51fa\u529b\u5f62\u5f0f
 * @return boolean \u6210\u529f\u306a\u3089true,\u5931\u6557\u306a\u3089false
 */
function cssj_set_output(&$session, &$out, $mimeType = 'application/pdf') {
  if ($session['state'] >= 2) {
    trigger_error (__FUNCTION__.": Main content is already sent.", E_USER_WARNING);
    return false;
  }
  $session['out'] =& $out;
  return cssj_set_property($session, 'output.type', $mimeType);
}

/**
 * \u30a8\u30e9\u30fc\u30e1\u30c3\u30bb\u30fc\u30b8\u53d7\u4fe1\u306e\u305f\u3081\u306e\u30b3\u30fc\u30eb\u30d0\u30c3\u30af\u95a2\u6570\u3092\u8a2d\u5b9a\u3057\u307e\u3059\u3002
 *
 * cssj_format_main\u304a\u3088\u3073cssj_ob_start_main\u306e\u524d\u306b\u547c\u3073\u51fa\u3057\u3066\u304f\u3060\u3055\u3044\u3002
 * \u30b3\u30fc\u30eb\u30d0\u30c3\u30af\u95a2\u6570\u306e\u5f15\u6570\u306f\u3001\u30a8\u30e9\u30fc\u30ec\u30d9\u30eb(int)\u3001\u30e1\u30c3\u30bb\u30fc\u30b8(string)\u3067\u3059\u3002
 * 
 * @access public
 * @param $session mixed \u30bb\u30c3\u30b7\u30e7\u30f3
 * @param $errorFunc function \u30b3\u30fc\u30eb\u30d0\u30c3\u30af\u95a2\u6570
 * @return void
 */
function cssj_set_error_func(&$session, &$errorFunc) {
  if ($session['state'] >= 2) {
    trigger_error (__FUNCTION__.": Main content is already sent.", E_USER_WARNING);
    return;
  }
  $session['errorFunc'] =& $errorFunc;
}

/**
 * \u9032\u884c\u72b6\u6cc1\u53d7\u4fe1\u306e\u305f\u3081\u306e\u30b3\u30fc\u30eb\u30d0\u30c3\u30af\u95a2\u6570\u3092\u8a2d\u5b9a\u3057\u307e\u3059\u3002
 *
 * cssj_format_main\u304a\u3088\u3073cssj_ob_start_main\u306e\u524d\u306b\u547c\u3073\u51fa\u3057\u3066\u304f\u3060\u3055\u3044\u3002
 * \u30b3\u30fc\u30eb\u30d0\u30c3\u30af\u95a2\u6570\u306e\u5f15\u6570\u306f\u3001\u8aad\u307f\u8fbc\u307f\u6e08\u307f\u30d0\u30a4\u30c8\u6570(int)\u3067\u3059\u3002
 * 
 * @access public
 * @param $session mixed \u30bb\u30c3\u30b7\u30e7\u30f3
 * @param $progressFunc function \u30b3\u30fc\u30eb\u30d0\u30c3\u30af\u95a2\u6570
 * @return void
 */
function cssj_set_progress_func(&$session, &$progressFunc) {
  if ($session['state'] >= 2) {
    trigger_error (__FUNCTION__.": Main content is already sent.", E_USER_WARNING);
    return;
  }
  $session['progressFunc'] =& $progressFunc;
}

/**
 * \u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u8a2d\u5b9a\u3057\u307e\u3059\u3002
 *
 * \u30bb\u30c3\u30b7\u30e7\u30f3\u3092\u4f5c\u6210\u3057\u305f\u76f4\u5f8c\u306b\u547c\u3073\u51fa\u3057\u3066\u304f\u3060\u3055\u3044\u3002
 * \u5229\u7528\u53ef\u80fd\u306a\u30d7\u30ed\u30d1\u30c6\u30a3\u306e\u4e00\u89a7\u306f\u300c\u958b\u767a\u8005\u30ac\u30a4\u30c9\u300d\u3092\u53c2\u7167\u3057\u3066\u304f\u3060\u3055\u3044\u3002
 * 
 * @access public
 * @param $session mixed \u30bb\u30c3\u30b7\u30e7\u30f3
 * @param $name string \u540d\u524d
 * @param $value string \u5024
 * @return boolean \u6210\u529f\u306a\u3089true,\u5931\u6557\u306a\u3089false
 */
function cssj_set_property(&$session, $name, $value) {
  if ($session['state'] >= 2) {
    trigger_error (__FUNCTION__.": Main content is already sent.", E_USER_WARNING);
    return false;
  }
  return cssj_ctip_req_property($session['fp'], $name, $value);
}

/**
 * \u30a2\u30af\u30bb\u30b9\u53ef\u80fd\u306a\u30b5\u30fc\u30d0\u30fc\u5074\u30ea\u30bd\u30fc\u30b9\u3092\u8a2d\u5b9a\u3057\u307e\u3059\u3002
 *
 * cssj_format_main\u304a\u3088\u3073cssj_ob_start_main\u306e\u524d\u306b\u547c\u3073\u51fa\u3057\u3066\u304f\u3060\u3055\u3044\u3002
 * 
 * @access public
 * @param $session mixed \u30bb\u30c3\u30b7\u30e7\u30f3
 * @param $uriPattern string URI\u30d1\u30bf\u30fc\u30f3
 * @return boolean \u6210\u529f\u306a\u3089true,\u5931\u6557\u306a\u3089false
 */
function cssj_include_resource(&$session, $uriPattern) {
  if ($session['state'] >= 2) {
    trigger_error (__FUNCTION__.": Main content is already sent.", E_USER_WARNING);
    return false;
  }
  return cssj_set_property($session, 'ctip.include', $uriPattern);
}

/**
 * \u9664\u5916\u3059\u308b\u30b5\u30fc\u30d0\u30fc\u5074\u30ea\u30bd\u30fc\u30b9\u3092\u8a2d\u5b9a\u3057\u307e\u3059\u3002
 *
 * cssj_format_main\u304a\u3088\u3073cssj_ob_start_main\u306e\u524d\u306b\u547c\u3073\u51fa\u3057\u3066\u304f\u3060\u3055\u3044\u3002
 * 
 * @access public
 * @param $session mixed \u30bb\u30c3\u30b7\u30e7\u30f3
 * @param $uriPattern string URI\u30d1\u30bf\u30fc\u30f3
 * @return boolean \u6210\u529f\u306a\u3089true,\u5931\u6557\u306a\u3089false
 */
function cssj_exclude_resource(&$session, $uriPattern) {
  if ($session['state'] >= 2) {
    trigger_error (__FUNCTION__.": Main content is already sent.", E_USER_WARNING);
    return false;
  }
  return cssj_set_property($session, 'ctip.exclude', $uriPattern);
}

/**
 * \u30b5\u30fc\u30d0\u30fc\u5074\u30ea\u30bd\u30fc\u30b9\u3092\u5909\u63db\u3057\u307e\u3059\u3002
 *
 * \u3053\u306e\u95a2\u6570\u306f1\u3064\u306e\u30bb\u30c3\u30b7\u30e7\u30f3\u306b\u3064\u304d1\u5ea6\u3060\u3051\u547c\u3076\u3053\u3068\u304c\u3067\u304d\u307e\u3059\u3002
 * \u305d\u306e\u5f8c\u3001\u5bfe\u8c61\u306e\u30bb\u30c3\u30b7\u30e7\u30f3\u306b\u5bfe\u3057\u3066cssj_close\u4ee5\u5916\u306e\u64cd\u4f5c\u306f\u3067\u304d\u307e\u305b\u3093\u3002
 * 
 * @access public
 * @param $session mixed \u30bb\u30c3\u30b7\u30e7\u30f3
 * @param $uri string URI
 * @return boolean \u6210\u529f\u306a\u3089true,\u5931\u6557\u306a\u3089false
 */
function cssj_format_main(&$session, $uri) {
  if ($session['state'] >= 2) {
    trigger_error (__FUNCTION__.": Main content is already sent.", E_USER_WARNING);
    return false;
  }
  if (cssj_include_resource($session, $uri) === false) {
    return false;
  }
  if (cssj_set_property($session, 'ctip.main', $uri) === false) {
    return false;
  }
  $session['state'] = 2;
  if (cssj_ctip_req_end($session['fp']) === false) {
    return false;
  }
  return cssj_ctip_res_build($session['fp'], $session['out'], $session['errorFunc'], $session['progressFunc']);
  }

/**
 * \u30ea\u30bd\u30fc\u30b9\u9001\u4fe1\u306e\u305f\u3081\u306e\u51fa\u529b\u306e\u30d0\u30c3\u30d5\u30a1\u30ea\u30f3\u30b0\u3092\u6709\u52b9\u306b\u3057\u307e\u3059\u3002
 *
 * cssj_ob_start_resource,cssj_ob_end_flush_resource\u306f\u5bfe\u3068\u306a\u308a\u307e\u3059\u3002
 * \u3053\u308c\u3089\u306e\u95a2\u6570\u306fcssj_format_main\u304a\u3088\u3073cssj_ob_start_main\u306e\u524d\u306b\u547c\u3073\u51fa\u3057\u3066\u304f\u3060\u3055\u3044\u3002
 * 
 * @access public
 * @param $session mixed \u30bb\u30c3\u30b7\u30e7\u30f3
 * @param $uri string \u4eee\u60f3URI
 * @param $mimeType MIME\u578b
 * @param $encoding \u30ad\u30e3\u30e9\u30af\u30bf\u30fb\u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0
 * @return boolean \u6210\u529f\u306a\u3089true,\u5931\u6557\u306a\u3089false
 */
function cssj_ob_start_resource(&$session, $uri, $mimeType = 'text/css', $encoding = '') {
  if ($session['state'] >= 2) {
    trigger_error (__FUNCTION__.": Main content is already sent.", E_USER_WARNING);
    return false;
  }
  $fp =& $session['fp'];
  if (cssj_ctip_req_resource($fp, $uri, $mimeType, $encoding) === false) {
    return false;
  }
  $GLOBALS['cssj_ob_session'] =& $session;
  // HACK ob_start\u306echunk_size\u6307\u5b9a\u306b\u3088\u308a\u30d8\u30c3\u30c0\u304c\u9001\u4fe1\u3055\u308c\u308b\u306e\u3092\u9632\u3050\u305f\u3081\u3001\uff12\u91cd\u306b\u30d0\u30c3\u30d5\u30a1\u3057\u3066\u3044\u307e\u3059\u3002
  ob_start();
  return ob_start('_cssj_ob_resource_handler', CSSJ_BUFFER_SIZE);
}

/**
 * \u30d0\u30c3\u30d5\u30a1\u306e\u5185\u5bb9\u3092\u9001\u4fe1\u3057\u3001\u30ea\u30bd\u30fc\u30b9\u9001\u4fe1\u306e\u305f\u3081\u306e\u30d0\u30c3\u30d5\u30a1\u30ea\u30f3\u30b0\u3092\u7d42\u4e86\u3057\u307e\u3059\u3002
 *
 * cssj_ob_start_resource,cssj_ob_end_flush_resource\u306f\u5bfe\u3068\u306a\u308a\u307e\u3059\u3002
 * \u3053\u308c\u3089\u306e\u95a2\u6570\u306fcssj_format_main\u304a\u3088\u3073cssj_ob_start_main\u306e\u524d\u306b\u547c\u3073\u51fa\u3057\u3066\u304f\u3060\u3055\u3044\u3002
 * 
 * @access public
 * @return boolean \u6210\u529f\u306a\u3089true,\u5931\u6557\u306a\u3089false
 */
function cssj_ob_end_flush_resource() {
  if (!isset($GLOBALS['cssj_ob_session']) || $GLOBALS['cssj_ob_session']['state'] >= 2) {
    trigger_error (__FUNCTION__.": cssj_ob_start_resource() was not called.", E_USER_WARNING);
    return false;
  }
  $err = ob_end_clean();
  ob_end_clean();
  if (isset($GLOBALS['cssj_ob_err'])) {
    $err = true;
  }
  unset($GLOBALS['cssj_ob_session']);
  unset($GLOBALS['cssj_ob_err']);
  return $err;
}

/**
 * \u30ea\u30bd\u30fc\u30b9\u306e\u9001\u4fe1\u306e\u305f\u3081\u306e\u30b3\u30fc\u30eb\u30d0\u30c3\u30af\u95a2\u6570\u3067\u3059\u3002
 * 
 * @access private
 * @param $buffer
 * @return string
 */
function _cssj_ob_resource_handler($buffer) {
  if (isset($GLOBALS['cssj_ob_err'])) {
    return '';
  }
  $fp =& $GLOBALS['cssj_ob_session']['fp'];
  for (;;) {
    $buff = substr($buffer, 0, CSSJ_BUFFER_SIZE);
    $len = strlen($buff);
    if ($len <= 0) {
      break;
    }
    $buffer = substr($buffer, $len);
    if (cssj_ctip_req_write($fp, $buff) === false) {
      $GLOBALS['cssj_ob_err'] = true;
      return '';
    }
  }
  return '';
}

/**
 * \u672c\u4f53\u306e\u5909\u63db\u306e\u305f\u3081\u306e\u51fa\u529b\u306e\u30d0\u30c3\u30d5\u30a1\u30ea\u30f3\u30b0\u3092\u6709\u52b9\u306b\u3057\u307e\u3059\u3002
 *
 * cssj_ob_start_main,cssj_ob_end_flush_main\u306f\u5bfe\u3068\u306a\u308a\u307e\u3059\u3002
 * \u672c\u4f53\u306e\u9001\u4fe1\u306f1\u3064\u306e\u30bb\u30c3\u30b7\u30e7\u30f3\u306b\u3064\u304d1\u5ea6\u3060\u3051\u3067\u3059\u3002
 * \u305d\u306e\u5f8c\u3001\u5bfe\u8c61\u306e\u30bb\u30c3\u30b7\u30e7\u30f3\u306b\u5bfe\u3057\u3066cssj_close\u4ee5\u5916\u306e\u64cd\u4f5c\u306f\u3067\u304d\u307e\u305b\u3093\u3002
 * 
 * @access public
 * @param $session mixed \u30bb\u30c3\u30b7\u30e7\u30f3
 * @param $uri string \u4eee\u60f3URI
 * @param $mimeType MIME\u578b
 * @param $encoding \u30ad\u30e3\u30e9\u30af\u30bf\u30fb\u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0
 * @return boolean \u6210\u529f\u306a\u3089true,\u5931\u6557\u306a\u3089false
 */
function cssj_ob_start_main(&$session, $uri, $mimeType = 'text/html', $encoding = '') {
  if ($session['state'] >= 2) {
    trigger_error (__FUNCTION__.": Main content is already sent.", E_USER_WARNING);
    return false;
  }
  $session['state'] = 2;
  $fp =& $session['fp'];
  if (cssj_ctip_req_main($fp, $uri, $mimeType, $encoding) === false) {
    return false;
  }
  $GLOBALS['cssj_ob_builder'] = cssj_ctip_res_create_builder($fp, $session['out'], $session['errorFunc'], $session['progressFunc']);
  $GLOBALS['cssj_ob_session'] =& $session;
  // HACK ob_start\u306echunk_size\u6307\u5b9a\u306b\u3088\u308a\u30d8\u30c3\u30c0\u304c\u9001\u4fe1\u3055\u308c\u308b\u306e\u3092\u9632\u3050\u305f\u3081\u3001\uff12\u91cd\u306b\u30d0\u30c3\u30d5\u30a1\u3057\u3066\u3044\u307e\u3059\u3002
  ob_start();
  return ob_start('_cssj_ob_main_handler', CSSJ_BUFFER_SIZE);
}

/**
 * \u5909\u63db\u7d50\u679c\u3092\u9001\u4fe1\u3057\u3001\u672c\u4f53\u306e\u5909\u63db\u306e\u305f\u3081\u306e\u30d0\u30c3\u30d5\u30a1\u30ea\u30f3\u30b0\u3092\u7d42\u4e86\u3057\u307e\u3059\u3002
 *
 * cssj_ob_start_main,cssj_ob_end_flush_main\u306f\u5bfe\u3068\u306a\u308a\u307e\u3059\u3002
 * \u672c\u4f53\u306e\u9001\u4fe1\u306f1\u3064\u306e\u30bb\u30c3\u30b7\u30e7\u30f3\u306b\u3064\u304d1\u5ea6\u3060\u3051\u3067\u3059\u3002
 * \u305d\u306e\u5f8c\u3001\u5bfe\u8c61\u306e\u30bb\u30c3\u30b7\u30e7\u30f3\u306b\u5bfe\u3057\u3066cssj_close\u4ee5\u5916\u306e\u64cd\u4f5c\u306f\u3067\u304d\u307e\u305b\u3093\u3002
 * 
 * @access public
 * @return boolean \u6210\u529f\u306a\u3089true,\u5931\u6557\u306a\u3089false
 */
function cssj_ob_end_flush_main() {
  if (!isset($GLOBALS['cssj_ob_session']) || $GLOBALS['cssj_ob_session']['state'] != 2) {
    trigger_error (__FUNCTION__.": cssj_ob_start_main() was not called.", E_USER_WARNING);
    return false;
  }
  ob_end_clean();
  ob_end_clean();
  if (isset($GLOBALS['cssj_ob_err'])) {
    $err = false;
  }
  else {
    $fp =& $GLOBALS['cssj_ob_session']['fp'];
    cssj_ctip_req_end($fp);
    while (($err = cssj_ctip_res_build_next($GLOBALS['cssj_ob_builder'])) === true)
      ; 
  }
  unset($GLOBALS['cssj_ob_builder']);
  unset($GLOBALS['cssj_ob_session']);
  unset($GLOBALS['cssj_ob_err']);
  return ($err === false) ? false : true;
}

/**
 * \u672c\u4f53\u306e\u5909\u63db\u306e\u305f\u3081\u306e\u30b3\u30fc\u30eb\u30d0\u30c3\u30af\u95a2\u6570\u3067\u3059\u3002
 * 
 * @access private
 * @param $buffer
 * @return string
 */
function _cssj_ob_main_handler($buffer) {
  if (isset($GLOBALS['cssj_ob_err'])) {
    return '';
  }
  $fp =& $GLOBALS['cssj_ob_session']['fp'];
  for (;;) {
    $buff = substr($buffer, 0, CSSJ_BUFFER_SIZE);
    $len = strlen($buff);
    if ($len <= 0) {
      break;
    }
    $buffer = substr($buffer, $len);
    $packet = pack('NC', $len + 1, CSSJ_CTIP_REQ_DATA).$buff;
    $len = strlen($packet);
    for (;;) {
      $r = array($fp);
      $w = array($fp);
      $ex = null;
      if (($status = stream_select($r, $w, $ex, 0)) === false) {
        $GLOBALS['cssj_ob_err'] = true;
        return '';
      }
      if ($len > 0 && !empty($w)) {
        stream_set_blocking($fp, 0);
        if (($rlen = fwrite($fp, $packet)) === false) {
          $GLOBALS['cssj_ob_err'] = true;
          stream_set_blocking($fp, 1);
          return '';
        }
        stream_set_blocking($fp, 1);
      	$packet = substr($packet, $rlen);
        $len -= $rlen;
      }
      if (!empty($r)) {
        if (cssj_ctip_res_build_next($GLOBALS['cssj_ob_builder']) === false) {
          $GLOBALS['cssj_ob_err'] = true;
          return '';
        }
      }
	  if ($len <= 0) {
        break;
      }
    }
  }
  return '';
}

/**
 * \u30bb\u30c3\u30b7\u30e7\u30f3\u3092\u9589\u3058\u307e\u3059\u3002
 *
 * \u3053\u306e\u95a2\u6570\u306e\u547c\u51fa\u3057\u5f8c\u3001\u5bfe\u8c61\u3068\u306a\u3063\u305f\u30bb\u30c3\u30b7\u30e7\u30f3\u306b\u5bfe\u3059\u308b\u3044\u304b\u306a\u308b\u64cd\u4f5c\u3082\u3067\u304d\u307e\u305b\u3093\u3002
 * 
 * @access public
 * @param $session
 * @return boolean \u6210\u529f\u306a\u3089true,\u5931\u6557\u306a\u3089false
 */
function cssj_close(&$session) {
  if ($session['state'] >= 3) {
    trigger_error (__FUNCTION__.": The session is already closed.", E_USER_WARNING);
    return false;
  }
  $session['state'] = 3;
  return fclose($session['fp']);
}

?>
