<?php
/**
 * CSSJžץȥ(CTIP)٥ʬ򰷤ޤ
 * 
 * ̾ץޤΥѥåľܻȤɬפϤޤ
 * 
 * @package cssj
 * @subpackage ctip
 */

/**
 * 桼ƥƥǤ
 */
require_once ('cssj_helpers.php');

/**
 * ꥯȥѥåȥ:ץѥƥ
 * @access public
 */
define ('CSSJ_CTIP_REQ_PROPERTY', 1);
/**
 * ꥯȥѥåȥ:꥽
 * @access public
 */
define ('CSSJ_CTIP_REQ_RESOURCE', 2);
/**
 * ꥯȥѥåȥ:
 * @access public
 */
define ('CSSJ_CTIP_REQ_MAIN', 3);
/**
 * ꥯȥѥåȥ:ǡ
 * @access public
 */
define ('CSSJ_CTIP_REQ_DATA', 4);
/**
 * ꥯȥѥåȥ:λ
 * @access public
 */
define ('CSSJ_CTIP_REQ_END', 5);

/**
 * 쥹ݥ󥹥ѥåȥ:ե饰ɲ
 * @access public
 */
define ('CSSJ_CTIP_RES_ADD', 1);
/**
 * 쥹ݥ󥹥ѥåȥ:ե饰
 * @access public
 */
define ('CSSJ_CTIP_RES_INSERT', 2);
/**
 * 쥹ݥ󥹥ѥåȥ:顼å
 * @access public
 */
define ('CSSJ_CTIP_RES_ERROR', 3);
/**
 * 쥹ݥ󥹥ѥåȥ:ǡ
 * @access public
 */
define ('CSSJ_CTIP_RES_DATA', 4);

/**
 * Υե饰Ȥκ祵Ǥ
 * 
 * ե饰Ȥ礭Ķȥǥ˽񤭹ߤޤ
 * 
 * @access private
 */
define ('CSSJ_CTIP_FRG_MEM_SIZE', 256);

/**
 * ֤ǡκ祵Ǥ
 * 
 * ΥǡΥĶȡ
 * CSSJ_CTIP_FRG_MEM_SIZEȤ̵ط˥ǥ˽񤭹ޤޤ
 * 
 * @access private
 */
define ('CSSJ_CTIP_ON_MEMORY', 1024 * 1024);

/**
 * եΥȥǤ
 *
 * @access private
 */
define ('CSSJ_CTIP_SEGMENT_SIZE', 8192);

/**
 * å򳫻Ϥޤ
 * 
 * @param $fp resource ȥ꡼
 * @param $encoding string ̿Ѥ륨󥳡ǥ
 * @return boolean ʤtrue,Ԥʤfalse
 * @access public
 */
function cssj_ctip_connect(&$fp, $encoding) {
  $err = fwrite($fp, "CTIP/1.0 $encoding\n");
  return ($err === false) ? false : true; 
}

/**
 * ץѥƥޤ
 * 
 * @param $fp resource ȥ꡼
 * @param $name string ̾
 * @param $value string 
 * @return boolean ʤtrue,Ԥʤfalse
 * @access public
 */
function cssj_ctip_req_property(&$fp, $name, $value) {
  $payload = strlen($name) + strlen($value) + 5;
  if (cssj_utils_write_int($fp, $payload) === false) {
    return false;
  }
  if (cssj_utils_write_byte($fp, CSSJ_CTIP_REQ_PROPERTY) === false) {
    return false;
  }
  if (cssj_utils_write_bytes($fp, $name) === false) {
    return false;
  }
  if (cssj_utils_write_bytes($fp, $value) === false) {
    return false;
  }
  return fflush($fp);
}

/**
 * ꥽γϤΤޤ
 * 
 * @param $fp resource ȥ꡼
 * @param $uri string URI
 * @param $mimeType string MIME
 * @param $encoding string 󥳡ǥ
 * @return boolean ʤtrue,Ԥʤfalse
 * @access public
 */
function cssj_ctip_req_resource(&$fp, $uri, $mimeType = 'text/css', $encoding = '') {
  $payload = strlen($uri) + strlen($mimeType) + strlen($encoding) + 5;
  if (cssj_utils_write_int($fp, $payload) === false) {
    return false;
  }
  if (cssj_utils_write_byte($fp, CSSJ_CTIP_REQ_RESOURCE) === false) {
    return false;
  }
  if (cssj_utils_write_bytes($fp, $uri) === false) {
    return false;
  }
  if (cssj_utils_write_bytes($fp, $mimeType) === false) {
    return false;
  }
  if (cssj_utils_write_bytes($fp, $encoding) === false) {
    return false;
  }
  return fflush($fp);
}

/**
 * ΤγϤΤޤ
 * 
 * @param $fp resource ȥ꡼
 * @param $uri string URI
 * @param $mimeType string MIME
 * @param $encoding string 󥳡ǥ
 * @return boolean ʤtrue,Ԥʤfalse
 * @access public
 */
function cssj_ctip_req_main(&$fp, $uri, $mimeType = 'text/html', $encoding = '') {
  $payload = strlen($uri) + strlen($mimeType) + strlen($encoding) + 5;
  if (cssj_utils_write_int($fp, $payload) === false) {
    return false;
  }
  if (cssj_utils_write_byte($fp, CSSJ_CTIP_REQ_MAIN) === false) {
    return false;
  }
  if (cssj_utils_write_bytes($fp, $uri) === false) {
    return false;
  }
  if (cssj_utils_write_bytes($fp, $mimeType) === false) {
    return false;
  }
  if (cssj_utils_write_bytes($fp, $encoding) === false) {
    return false;
  }
  return fflush($fp);
}

/**
 * ǡޤ
 * 
 * @param $fp resource ȥ꡼
 * @param $b string ǡ
 * @param $len int ǡĹ
 * @return boolean ʤtrue,Ԥʤfalse
 * @access public
 */
function cssj_ctip_req_write(&$fp, &$b, $len = -1) {
  if ($len == -1) {
    $len = strlen($b);
  }
  else {
    $len = min(strlen($b), $len);
  }
  $payload = $len + 1;
  if (cssj_utils_write_int($fp, $payload) === false) {
    return false;
  }
  if (cssj_utils_write_byte($fp, CSSJ_CTIP_REQ_DATA) === false) {
    return false;
  }
  if (fwrite($fp, $b, $len) === false) {
    return false;
  }
  return fflush($fp);
}

/**
 * λΤޤ
 * 
 * @param $fp resource ȥ꡼
 * @return boolean ʤtrue,Ԥʤfalse
 * @access public
 */
function cssj_ctip_req_end(&$fp) {
  if (cssj_utils_write_int($fp, 0) === false) {
    return false;
  }
  return fflush($fp);
}

/**
 * Υ쥹ݥ󥹤ޤ
 * 
 * 쥹ݥ(array)ˤϼΥǡޤޤޤ
 * 
 * - 'type' 쥹ݥ󥹥
 * - 'anchorId' ľΥե饰ID
 * - 'level' 顼٥
 * - 'error' 顼å
 * - 'id' ID
 * - 'progress' ѥХȿ
 * - 'bytes' ǡΥХ
 * 
 * @param $fp resource ȥ꡼
 * @return mixed 쥹ݥ,쥹ݥ󥹤νλʤnull,Ԥʤfalse
 * @access public
 */
function cssj_ctip_res_next(&$fp) {
  if (($payload = cssj_utils_read_int($fp)) === false) {
    return false;
  }
  if ($payload === 0) {
    return null;
  }
  if (($type = cssj_utils_read_byte($fp)) === false) {
    return false;
  }
  
  switch ($type) {
      case CSSJ_CTIP_RES_ADD:
      return array(
        'type' => $type,
      );
      
      case CSSJ_CTIP_RES_INSERT:
      if (($anchorId = cssj_utils_read_int($fp)) === false) {
        return false;
      }
      return array(
        'type' => $type,
        'anchorId' => $anchorId
      );
      
      case CSSJ_CTIP_RES_ERROR:
      if (($level = cssj_utils_read_byte($fp)) === false) {
        return false;
      }
      if (($error = cssj_utils_read_bytes($fp)) === false) {
        return false;
      }
      return array(
        'type' => $type,
        'level' => $level,
        'error' => $error
      );
      
      case CSSJ_CTIP_RES_DATA:
      if (($id = cssj_utils_read_int($fp)) === false) {
        return false;
      }
      if (($progress = cssj_utils_read_int($fp)) === false) {
        return false;
      }
      if (($bytes = _cssj_read($fp, $payload - 9)) === false) {
        return false;
      }
      return array(
        'type' => $type,
        'id' => $id,
        'progress' => $progress,
        'bytes' => &$bytes
      );
      
      default:
      trigger_error ("Bad response type:$type", E_USER_ERROR);
      return false;
  }
}

/**
 * 쥹ݥ󥹤ǡۤޤ
 * 
 * @param $fp resource ȥ꡼
 * @param $out mixed 襹ȥ꡼(resource),ѿ(string),ޤɸϤǤnull
 * @param $errorFunc 顼Хåؿ
 * @param $progressFunc ʹԾХåؿ
 * @return boolean ʤtrue,Ԥʤfalse
 * @access public
 */
function cssj_ctip_res_build(&$fp, &$out, &$errorFunc, &$progressFunc) {
  $builder = cssj_ctip_res_create_builder($fp, $out, $errorFunc, $progressFunc);
  while (($err = cssj_ctip_res_build_next($builder)) === true)
    ;
  return ($err === null) ? true : false;
}

/**
 * ӥۤޤ
 * 
 * @param $fp resource ȥ꡼
 * @param $out mixed 襹ȥ꡼(resource),ѿ(string),ޤɸϤǤnull
 * @param $errorFunc 顼Хåؿ
 * @param $progressFunc ʹԾХåؿ
 * @return mixed ӥ,顼ξfalse
 * @access public
 */
function &cssj_ctip_res_create_builder(&$fp, &$out, &$errorFunc, &$progressFunc) {
  if (($tempFile = tmpfile()) === false) {
    return false;
  }
  $builder = array(
    'fp' => &$fp,
    'out' => &$out,
    'errorFunc' => &$errorFunc,
    'progressFunc' => &$progressFunc,
    'tempFile' => &$tempFile,
    'frgs' => array(),
    'first' => null,
    'last' => null,
    'onMemory' => 0,
    'length' => 0,
    'segment' => 0
  );
  return $builder;
}

/**
 * Υӥɥ¹Ԥޤ
 * 
 * @param $builder array ӥ
 * @return mixed true,änull,顼ξfalse
 */
function cssj_ctip_res_build_next(&$builder) {
  $fp =& $builder['fp'];
  $out =& $builder['out'];
  $errorFunc =& $builder['errorFunc'];
  $progressFunc =& $builder['progressFunc'];
  $tempFile =& $builder['tempFile'];
  $frgs =& $builder['frgs'];
  $first =& $builder['first'];
  $last =& $builder['last'];
  $onMemory =& $builder['onMemory'];
  $length =& $builder['length'];
  $segment =& $builder['segment'];
  
  if (($next = cssj_ctip_res_next($fp)) !== null) {
    if ($next === false) {
      fclose($tempFile);
      return false;
    }
    $type = $next['type'];
    switch ($type) {
      case CSSJ_CTIP_RES_ADD:
      $id = count($frgs);
      $frg =& _cssj_new_frg($id);
      $frgs[$id] =& $frg;
      if (is_null($first)) {
        $first =& $frg;
      }
      else {
        $last['next'] =& $frg;
        $frg['prev'] =& $last;
      }
      $last =& $frg;
      break;
      
      case CSSJ_CTIP_RES_INSERT:
      $anchorId = $next['anchorId'];
      $id = count($frgs);
      $anchor =& $frgs[$anchorId];
      $frg =& _cssj_new_frg($id);
      $frgs[$id] =& $frg;
      $frg['prev'] =& $anchor['prev'];
      $frg['next'] =& $anchor;
      $anchor['prev']['next'] =& $frg;
      $anchor['prev'] =& $frg;
      if ($first['id'] === $anchor['id']) {
        $first =& $frg;
      }
      break;
      
      case CSSJ_CTIP_RES_ERROR:
      if (isset($errorFunc)) {
        $errorFunc($next['level'], $next['error']);
      }
      break;
      
      case CSSJ_CTIP_RES_DATA:
      if (isset($progressFunc)) {
        $progressFunc($next['progress']);
      }
      $frg =& $frgs[$next['id']];
      if (($length += _cssj_write_frg($tempFile, $onMemory, $segment, $frg, $next['bytes'])) === false) {
        fclose($tempFile);
        return false;
      }
      break;
    }
    
    $builder['first'] =& $first;
    $builder['last'] =& $last;
    return true;
  }
  else {
    //ۤλƥǡФޤ
    if ($out === null) {
      header("Content-Length: $length");
    }
    
    $frg =& $first;
    while (!is_null($frg)) {
      if (_cssj_flush_frg($tempFile, $frg, $out) === false) {
        fclose($tempFile);
        return false;
      }
      $frg =& $frg['next'];
    }
    
    fclose($tempFile);
    return null;
  }
}

/**
 * ե饰Ȥޤ
 * 
 * @param $id int ե饰ID
 * @return array ե饰
 * @access private
 */
function &_cssj_new_frg($id) {
  $frg = array(
    'id' => $id,
    'prev' => null,
    'next' => null,
    'length' => 0,
    'buffer' => ''
  );
  return $frg;
}

/**
 * ե饰Ȥ˥ǡ񤭹ߤޤ
 * 
 * @param $tempFile resource ե
 * @param $onMemory int ֤줿ǡιץ
 * @param $segment int ֹ楷
 * @param $frg array ե饰
 * @param $bytes string ǡ
 * @return mixed ʤ񤭹Хȿ,Ԥʤfalse
 * @access private
 */
function _cssj_write_frg(&$tempFile, &$onMemory, &$segment, &$frg, &$bytes) {
  $len = strlen($bytes);
  if (!isset($frg['segments']) &&
           ($frg['length'] + $len) <= CSSJ_CTIP_FRG_MEM_SIZE &&
           ($onMemory + $len) <= CSSJ_CTIP_ON_MEMORY) {
    $frg['buffer'] .= $bytes;
    $onMemory += $len;
  }
  else {
    if (isset($frg['buffer'])) {
      if (($wlen = _cssj_raf_write($tempFile, $segment, $frg, $frg['buffer'])) === false) {
          return false;
      }
      $onMemory -= $wlen;
      unset($frg['buffer']);
    }
    if (($len = _cssj_raf_write($tempFile, $segment, $frg, $bytes)) === false) {
      return false;
    }
  }
  $frg['length'] += $len;
  return $len;
}

/**
 * ե˽񤭹ߤޤ
 *
 * @param $tempFile resource ե
 * @param $segment int ֹ楷
 * @param $frg array ե饰
 * @param $bytes string ǡ
 * @return mixed 񤭹ХȿԤfalse
 * @access private
 */
function _cssj_raf_write(&$tempFile, &$segment, &$frg, $bytes) {
  if (!isset($frg['segments'])) {
    $frg['segments'] = array($segment++);
    $frg['segLen'] = 0;
  }
  $segments =& $frg['segments'];
  $segLen =& $frg['segLen'];
  $written = 0;
  while (($len = strlen($bytes)) > 0) {
	if ($segLen == CSSJ_CTIP_SEGMENT_SIZE) {
		$segments[] = $segment++;
		$segLen = 0;
	}
	$seg = $segments[count($segments) - 1];
	$wlen = min($len, CSSJ_CTIP_SEGMENT_SIZE - $segLen);
	$wpos = $seg * CSSJ_CTIP_SEGMENT_SIZE + $segLen;
	if (fseek($tempFile, $wpos) === -1) {
	  return false;
	}
	if (($wlen = fwrite($tempFile, $bytes, $wlen)) === false) {
	  return false;
	}
	$segLen += $wlen;
	$written += $wlen;
	$bytes = substr($bytes, $wlen);
  }
  return $written;
}

/**
 * ե饰ȤƤǤФơե饰Ȥ˴ޤ
 * 
 * @param $tempFile resource ե
 * @param $frg array ե饰
 * @param $out mixed 襹ȥ꡼(resource),ѿ(string),ޤɸϤǤnull
 * @return boolean ʤtrue,Ԥʤfalse
 * @access private
 */
function _cssj_flush_frg(&$tempFile, &$frg, &$out) {
  if (!isset($frg['segments'])) {
    if (_cssj_output($out, $frg['buffer']) === false) {
      return false;
    }
    unset($frg['buffer']);
  }
  else {
    $segments =& $frg['segments'];
    $segcount = count($segments);
    for ($i = 0; $i < $segcount - 1; ++$i) {
      $seg = $segments[$i];
      $rpos = $seg * CSSJ_CTIP_SEGMENT_SIZE;
      if (fseek($tempFile, $rpos) == -1) {
        return false;
      }
      if (($buff = _cssj_read($tempFile, CSSJ_CTIP_SEGMENT_SIZE)) === false) {
        return false;
      }
      if (_cssj_output($out, $buff) === false) {
        return false;
      }
    }
    $seg = $segments[$segcount - 1];
    $rpos = $seg * CSSJ_CTIP_SEGMENT_SIZE;
    if (fseek($tempFile, $rpos) == -1) {
      return false;
    }
    if (($buff = _cssj_read($tempFile, $frg['segLen'])) === false) {
      return false;
    }
    if (_cssj_output($out, $buff) === false) {
      return false;
    }
  }
  return true;
}

/**
 * ɸϡȥ꡼ࡢѿΤ줫˽Ϥޤ
 *
 * @param $out mixed 
 * @param $buff string ǡ
 * @return boolean ʤtrue,Ԥʤfalse
 * @access private
 */
function _cssj_output(&$out, &$buff) {
  if ($out === null) {
    //ɸ
    echo $buff;
  }
  elseif (is_resource($out)) {
    //ȥ꡼
    if (fwrite($out, $buff) === false) {
      return false;
    }
  }
  else {
    //ѿ
    $out .= $buff;
  }
  return true;
}

?>