/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.sakae.opentype.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import jp.cssj.sakae.opentype.table.CmapFormat;
import jp.cssj.sakae.opentype.table.CmapIndexEntry;
import jp.cssj.sakae.opentype.table.DirectoryEntry;
import jp.cssj.sakae.opentype.table.Table;

public class CmapTable
implements Table {
    private int numTables;
    private CmapIndexEntry[] entries;
    private CmapFormat[] formats;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CmapTable(DirectoryEntry de, RandomAccessFile raf) throws IOException {
        RandomAccessFile randomAccessFile = raf;
        synchronized (randomAccessFile) {
            int i;
            raf.seek(de.getOffset());
            long fp = raf.getFilePointer();
            raf.readUnsignedShort();
            this.numTables = raf.readUnsignedShort();
            this.entries = new CmapIndexEntry[this.numTables];
            this.formats = new CmapFormat[this.numTables];
            for (i = 0; i < this.numTables; ++i) {
                this.entries[i] = new CmapIndexEntry(raf);
            }
            for (i = 0; i < this.numTables; ++i) {
                raf.seek(fp + (long)this.entries[i].getOffset());
                int format = raf.readUnsignedShort();
                this.formats[i] = CmapFormat.create(format, raf);
            }
        }
    }

    public CmapFormat getCmapFormat(short platformId, short encodingId) {
        for (int i = 0; i < this.numTables; ++i) {
            if (this.entries[i].getPlatformId() != platformId || this.entries[i].getEncodingId() != encodingId) continue;
            return this.formats[i];
        }
        return null;
    }

    public int getType() {
        return 1668112752;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer().append("cmap\n");
        for (i = 0; i < this.numTables; ++i) {
            sb.append("\t").append(this.entries[i].toString()).append("\n");
        }
        for (i = 0; i < this.numTables; ++i) {
            sb.append("\t").append(this.formats[i].toString()).append("\n");
        }
        return sb.toString();
    }
}

