/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.sakae.opentype.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import jp.cssj.sakae.opentype.table.DirectoryEntry;
import jp.cssj.sakae.opentype.table.FeatureList;
import jp.cssj.sakae.opentype.table.LigatureSubst;
import jp.cssj.sakae.opentype.table.LookupList;
import jp.cssj.sakae.opentype.table.LookupSubtable;
import jp.cssj.sakae.opentype.table.LookupSubtableFactory;
import jp.cssj.sakae.opentype.table.ScriptList;
import jp.cssj.sakae.opentype.table.SingleSubst;
import jp.cssj.sakae.opentype.table.Table;

public class GsubTable
implements Table,
LookupSubtableFactory {
    private ScriptList scriptList;
    private FeatureList featureList;
    private LookupList lookupList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GsubTable(DirectoryEntry de, RandomAccessFile raf) throws IOException {
        RandomAccessFile randomAccessFile = raf;
        synchronized (randomAccessFile) {
            raf.seek(de.getOffset());
            raf.readInt();
            int scriptListOffset = raf.readUnsignedShort();
            int featureListOffset = raf.readUnsignedShort();
            int lookupListOffset = raf.readUnsignedShort();
            this.scriptList = new ScriptList(raf, de.getOffset() + scriptListOffset);
            this.featureList = new FeatureList(raf, de.getOffset() + featureListOffset);
            this.lookupList = new LookupList(raf, de.getOffset() + lookupListOffset, this);
        }
    }

    public LookupSubtable read(int type, RandomAccessFile raf, int offset) throws IOException {
        LookupSubtable s = null;
        switch (type) {
            case 1: {
                s = SingleSubst.read(raf, offset);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                s = LigatureSubst.read(raf, offset);
                break;
            }
            case 5: {
                break;
            }
        }
        return s;
    }

    public int getType() {
        return 1196643650;
    }

    public ScriptList getScriptList() {
        return this.scriptList;
    }

    public FeatureList getFeatureList() {
        return this.featureList;
    }

    public LookupList getLookupList() {
        return this.lookupList;
    }

    public String toString() {
        return "GSUB";
    }
}

