/*

 Copyright 2001  The Apache Software Foundation 

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 */
package jp.cssj.sakae.opentype.table;

import java.io.IOException;
import java.io.RandomAccessFile;

/**
 * Simple Macintosh cmap table, mapping only the ASCII character set to glyphs.
 * 
 * @version $Id: CmapFormat0.java,v 1.2 2007-05-06 04:27:01 miyabe Exp $
 * @author <a href="mailto:david@steadystate.co.uk">David Schweinsberg</a>
 */
public class CmapFormat0 extends CmapFormat {

	private byte[] glyphIdArray = new byte[256];

	private int first, last;

	protected CmapFormat0(RandomAccessFile raf) throws IOException {
		super(raf);
		raf.read(this.glyphIdArray);
		this.format = 0;
		this.first = -1;
		for (int i = 0; i < 256; i++) {
			if (this.glyphIdArray[i] > 0) {
				if (this.first == -1)
					this.first = i;
				this.last = i;
			}
		}
	}

	public int getFirst() {
		return this.first;
	}

	public int getLast() {
		return this.last;
	}

	public int mapCharCode(int charCode) {
		if (0 <= charCode && charCode < 256) {
			return (int) this.glyphIdArray[charCode] & 0xFF;
		} else {
			return 0;
		}
	}
}
