/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.sakae.opentype;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.cssj.sakae.opentype.Glyph;
import jp.cssj.sakae.opentype.GlyphList;
import jp.cssj.sakae.opentype.cff.CffGlyphList;
import jp.cssj.sakae.opentype.cff.CffTable;
import jp.cssj.sakae.opentype.table.DirectoryEntry;
import jp.cssj.sakae.opentype.table.GlyfTable;
import jp.cssj.sakae.opentype.table.HeadTable;
import jp.cssj.sakae.opentype.table.HheaTable;
import jp.cssj.sakae.opentype.table.HmtxTable;
import jp.cssj.sakae.opentype.table.LocaTable;
import jp.cssj.sakae.opentype.table.MaxpTable;
import jp.cssj.sakae.opentype.table.Table;
import jp.cssj.sakae.opentype.table.TableDirectory;
import jp.cssj.sakae.opentype.table.TableFactory;
import jp.cssj.sakae.opentype.table.VheaTable;
import jp.cssj.sakae.opentype.table.VmtxTable;
import jp.cssj.sakae.opentype.truetype.TrueTypeGlyphList;

public class OpenTypeFont {
    private Logger LOG = Logger.getLogger(OpenTypeFont.class.getName());
    private TableDirectory tableDirectory = null;
    private Table[] tables;
    private HeadTable head;
    private HheaTable hhea;
    private HmtxTable hmtx;
    private VheaTable vhea;
    private VmtxTable vmtx;
    private MaxpTable maxp;
    private GlyphList glyphList;
    private RandomAccessFile raf;

    public OpenTypeFont(RandomAccessFile raf) throws IOException {
        GlyfTable glyf;
        this.raf = raf;
        this.tableDirectory = new TableDirectory(raf);
        this.tables = new Table[this.tableDirectory.getNumTables()];
        this.head = (HeadTable)this.getTable(1751474532);
        this.hhea = (HheaTable)this.getTable(1751672161);
        this.hmtx = (HmtxTable)this.getTable(1752003704);
        this.vhea = (VheaTable)this.getTable(1986553185);
        this.vmtx = (VmtxTable)this.getTable(1986884728);
        this.maxp = (MaxpTable)this.getTable(1835104368);
        this.hmtx.init(this.hhea.getNumberOfHMetrics(), this.maxp.getNumGlyphs() - this.hhea.getNumberOfHMetrics());
        if (this.vmtx != null) {
            this.vmtx.init(this.vhea.getNumberOfHMetrics(), this.maxp.getNumGlyphs() - this.vhea.getNumberOfHMetrics());
        }
        if ((glyf = (GlyfTable)this.getTable(1735162214)) != null) {
            LocaTable loca = (LocaTable)this.getTable(1819239265);
            glyf.init(loca);
            loca.init(this.maxp.getNumGlyphs(), this.head.getIndexToLocFormat() == 0);
            this.glyphList = new TrueTypeGlyphList(glyf, this.head, this.maxp);
        } else {
            CffTable cff = (CffTable)this.getTable(1128678944);
            if (cff != null) {
                cff.init();
                this.glyphList = new CffGlyphList(cff, this.head, this.maxp);
            } else {
                throw new IOException("Unsupported font file format.");
            }
        }
    }

    public Table getTable(int tableType) {
        for (int i = 0; i < this.tableDirectory.getNumTables(); ++i) {
            DirectoryEntry entry = this.tableDirectory.getEntry(i);
            if (entry.getTag() != tableType) continue;
            if (this.tables[i] == null) {
                try {
                    this.tables[i] = TableFactory.create(entry, this.raf);
                }
                catch (IOException e) {
                    this.LOG.log(Level.WARNING, "Can't read font file.", e);
                    return null;
                }
            }
            return this.tables[i];
        }
        return null;
    }

    public int getAscent() {
        return this.hhea.getAscender();
    }

    public int getDescent() {
        return this.hhea.getDescender();
    }

    public int getNumGlyphs() {
        return this.maxp.getNumGlyphs();
    }

    public Glyph getGlyph(int i) {
        return this.glyphList.getGlyph(i);
    }

    public TableDirectory getTableDirectory() {
        return this.tableDirectory;
    }
}

