/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.sakae.opentype.cff;

import java.awt.geom.GeneralPath;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import jp.cssj.sakae.opentype.Glyph;
import jp.cssj.sakae.opentype.cff.Type2Stack;

public class Type2CharString {
    public static final int HSTEM = 1;
    public static final int VSTEM = 3;
    public static final int VMOVETO = 4;
    public static final int RLINETO = 5;
    public static final int HLINETO = 6;
    public static final int VLINETO = 7;
    public static final int RRCURVETO = 8;
    public static final int CALLSUBR = 10;
    public static final int RETURN = 11;
    public static final int ESCAPE = 12;
    public static final int ENDCHAR = 14;
    public static final int BLEND = 16;
    public static final int HSTEMHM = 18;
    public static final int HINTMASK = 19;
    public static final int CNTRMASK = 20;
    public static final int RMOVETO = 21;
    public static final int HMOVETO = 22;
    public static final int VSTEMHM = 23;
    public static final int RCURVELINE = 24;
    public static final int RLINECURVE = 25;
    public static final int VVCURVETO = 26;
    public static final int HHCURVETO = 27;
    public static final int SHORTINT = 28;
    public static final int CALLGSUBR = 29;
    public static final int VHCURVETO = 30;
    public static final int HVCURVETO = 31;
    public static final int AND = 3075;
    public static final int OR = 3076;
    public static final int NOT = 3077;
    public static final int STORE = 3080;
    public static final int ABS = 3081;
    public static final int ADD = 3082;
    public static final int SUB = 3083;
    public static final int DIV = 3084;
    public static final int LOAD = 3085;
    public static final int NEG = 3086;
    public static final int EQ = 3087;
    public static final int DROP = 3090;
    public static final int PUT = 3092;
    public static final int GET = 3093;
    public static final int IFELSE = 3094;
    public static final int RANDOM = 3095;
    public static final int MUL = 3096;
    public static final int SQRT = 3098;
    public static final int DUP = 3099;
    public static final int EXCH = 3100;
    public static final int INDEX = 3101;
    public static final int ROLL = 3102;
    public static final int HFLEX = 3106;
    public static final int FLEX = 3107;
    public static final int HFLEX1 = 3108;
    public static final int FLEX1 = 3109;
    public static final byte TYPE_OPERATOR = 1;
    public static final byte TYPE_INTEGER = 2;
    private static final boolean DEBUG = false;
    private final RandomAccessFile raf;
    private final Type2Stack operandStack = new Type2Stack();
    private final int[] execStack = new int[10];
    private int execDepth = 0;
    private int b0 = -1;

    public Type2CharString(RandomAccessFile raf) {
        this.raf = raf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Glyph getGlyph(int ix, int offset, short upm, int[] globalSubrOffsets, int[] localSubrOffsets) {
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        GeneralPath path = new GeneralPath();
        path.moveTo(0.0f, 0.0f);
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            try {
                int op;
                this.raf.seek(offset);
                int cx = 0;
                int cy = 0;
                int hintCount = 0;
                boolean closed = true;
                this.operandStack.clear();
                this.execDepth = 0;
                boolean k = false;
                block29: while ((op = this.scanOperator()) != 14) {
                    switch (op) {
                        case 21: {
                            if (!closed) {
                                path.closePath();
                                closed = true;
                            }
                            path.moveTo(cx += this.operandStack.get(0), cy += -this.operandStack.get(1));
                            this.operandStack.writeTo(buff, op);
                            this.operandStack.clear();
                            continue block29;
                        }
                        case 22: {
                            if (!closed) {
                                path.closePath();
                                closed = true;
                            }
                            path.moveTo(cx += this.operandStack.get(0), cy);
                            this.operandStack.writeTo(buff, op);
                            this.operandStack.clear();
                            continue block29;
                        }
                        case 4: {
                            if (!closed) {
                                path.closePath();
                                closed = true;
                            }
                            path.moveTo(cx, cy += -this.operandStack.get(0));
                            this.operandStack.writeTo(buff, op);
                            this.operandStack.clear();
                            continue block29;
                        }
                        case 5: {
                            int i;
                            if (this.operandStack.size() < 2 || this.operandStack.size() % 2 == 1) {
                                throw new ArrayIndexOutOfBoundsException(this.operandStack.size());
                            }
                            for (i = 0; i < this.operandStack.size() - 1; i += 2) {
                                path.lineTo(cx += this.operandStack.get(i), cy += -this.operandStack.get(i + 1));
                            }
                            this.operandStack.writeTo(buff, op);
                            this.operandStack.clear();
                            closed = false;
                            continue block29;
                        }
                        case 6: {
                            int i;
                            if (this.operandStack.size() < 1) {
                                throw new ArrayIndexOutOfBoundsException(this.operandStack.size());
                            }
                            for (i = 0; i < this.operandStack.size(); ++i) {
                                if (i % 2 == 0) {
                                    cx += this.operandStack.get(i);
                                } else {
                                    cy += -this.operandStack.get(i);
                                }
                                path.lineTo(cx, cy);
                            }
                            this.operandStack.writeTo(buff, op);
                            this.operandStack.clear();
                            closed = false;
                            continue block29;
                        }
                        case 7: {
                            int i;
                            if (this.operandStack.size() < 1) {
                                throw new ArrayIndexOutOfBoundsException(this.operandStack.size());
                            }
                            for (i = 0; i < this.operandStack.size(); ++i) {
                                if (i % 2 == 0) {
                                    cy += -this.operandStack.get(i);
                                } else {
                                    cx += this.operandStack.get(i);
                                }
                                path.lineTo(cx, cy);
                            }
                            this.operandStack.writeTo(buff, op);
                            this.operandStack.clear();
                            closed = false;
                            continue block29;
                        }
                        case 8: {
                            float y3;
                            float x3;
                            float y2;
                            float x2;
                            float y1;
                            int i;
                            if (this.operandStack.size() < 1 || this.operandStack.size() % 6 != 0) {
                                throw new ArrayIndexOutOfBoundsException(this.operandStack.size());
                            }
                            for (i = 0; i < this.operandStack.size() - 5; i += 6) {
                                float x1 = cx += this.operandStack.get(i);
                                y1 = cy += -this.operandStack.get(i + 1);
                                x2 = cx += this.operandStack.get(i + 2);
                                y2 = cy += -this.operandStack.get(i + 3);
                                x3 = cx += this.operandStack.get(i + 4);
                                y3 = cy += -this.operandStack.get(i + 5);
                                path.curveTo(x1, y1, x2, y2, x3, y3);
                            }
                            this.operandStack.writeTo(buff, op);
                            this.operandStack.clear();
                            closed = false;
                            continue block29;
                        }
                        case 27: {
                            float y3;
                            float x3;
                            float y2;
                            float x2;
                            float y1;
                            if (this.operandStack.size() < 2 || this.operandStack.size() % 4 != 0 && (this.operandStack.size() - 1) % 4 != 0) {
                                throw new ArrayIndexOutOfBoundsException(this.operandStack.size());
                            }
                            int i = 0;
                            if (this.operandStack.size() % 2 == 1) {
                                cy += -this.operandStack.get(i);
                                ++i;
                            }
                            while (i < this.operandStack.size() - 3) {
                                float x1 = cx += this.operandStack.get(i);
                                y1 = cy;
                                x2 = cx += this.operandStack.get(i + 1);
                                y2 = cy += -this.operandStack.get(i + 2);
                                x3 = cx += this.operandStack.get(i + 3);
                                y3 = cy;
                                path.curveTo(x1, y1, x2, y2, x3, y3);
                                i += 4;
                            }
                            this.operandStack.writeTo(buff, op);
                            this.operandStack.clear();
                            closed = false;
                            continue block29;
                        }
                        case 31: {
                            float y3;
                            float x3;
                            float y2;
                            float x2;
                            float y1;
                            int i;
                            if (this.operandStack.size() < 1 || this.operandStack.size() % 4 > 1) {
                                throw new ArrayIndexOutOfBoundsException(this.operandStack.size());
                            }
                            for (i = 0; i < this.operandStack.size() - 3; i += 4) {
                                float x1;
                                if (i / 4 % 2 == 1) {
                                    x1 = cx;
                                    y1 = cy += -this.operandStack.get(i);
                                    x2 = cx += this.operandStack.get(i + 1);
                                    y2 = cy += -this.operandStack.get(i + 2);
                                    x3 = cx += this.operandStack.get(i + 3);
                                    y3 = i + 4 == this.operandStack.size() - 1 ? (float)(cy += -this.operandStack.get(i + 4)) : (float)cy;
                                } else {
                                    x1 = cx += this.operandStack.get(i);
                                    y1 = cy;
                                    x2 = cx += this.operandStack.get(i + 1);
                                    y2 = cy += -this.operandStack.get(i + 2);
                                    y3 = cy += -this.operandStack.get(i + 3);
                                    x3 = i + 4 == this.operandStack.size() - 1 ? (float)(cx += this.operandStack.get(i + 4)) : (float)cx;
                                }
                                path.curveTo(x1, y1, x2, y2, x3, y3);
                            }
                            this.operandStack.writeTo(buff, op);
                            this.operandStack.clear();
                            closed = false;
                            continue block29;
                        }
                        case 24: {
                            float y3;
                            float x3;
                            float y2;
                            float x2;
                            float y1;
                            int i;
                            if (this.operandStack.size() < 1 || (this.operandStack.size() - 2) % 6 != 0) {
                                throw new ArrayIndexOutOfBoundsException(this.operandStack.size());
                            }
                            for (i = 0; i < this.operandStack.size() - 7; i += 6) {
                                float x1 = cx += this.operandStack.get(i);
                                y1 = cy += -this.operandStack.get(i + 1);
                                x2 = cx += this.operandStack.get(i + 2);
                                y2 = cy += -this.operandStack.get(i + 3);
                                x3 = cx += this.operandStack.get(i + 4);
                                y3 = cy += -this.operandStack.get(i + 5);
                                path.curveTo(x1, y1, x2, y2, x3, y3);
                            }
                            path.lineTo(cx += this.operandStack.get(this.operandStack.size() - 2), cy += -this.operandStack.get(this.operandStack.size() - 1));
                            this.operandStack.writeTo(buff, op);
                            this.operandStack.clear();
                            closed = false;
                            continue block29;
                        }
                        case 25: {
                            int i;
                            if (this.operandStack.size() < 1 || (this.operandStack.size() - 6) % 2 != 0) {
                                throw new ArrayIndexOutOfBoundsException(this.operandStack.size());
                            }
                            for (i = 0; i < this.operandStack.size() - 6; i += 2) {
                                path.lineTo(cx += this.operandStack.get(i), cy += -this.operandStack.get(i + 1));
                            }
                            float x1 = cx += this.operandStack.get(i);
                            float y1 = cy += -this.operandStack.get(i + 1);
                            float x2 = cx += this.operandStack.get(i + 2);
                            float y2 = cy += -this.operandStack.get(i + 3);
                            float x3 = cx += this.operandStack.get(i + 4);
                            float y3 = cy += -this.operandStack.get(i + 5);
                            path.curveTo(x1, y1, x2, y2, x3, y3);
                            this.operandStack.writeTo(buff, op);
                            this.operandStack.clear();
                            closed = false;
                            continue block29;
                        }
                        case 30: {
                            float y3;
                            float x3;
                            float y2;
                            float x2;
                            float y1;
                            int i;
                            if (this.operandStack.size() < 1 || this.operandStack.size() % 4 > 1) {
                                throw new ArrayIndexOutOfBoundsException(this.operandStack.size());
                            }
                            for (i = 0; i < this.operandStack.size() - 3; i += 4) {
                                float x1;
                                if (i / 4 % 2 == 0) {
                                    x1 = cx;
                                    y1 = cy += -this.operandStack.get(i);
                                    x2 = cx += this.operandStack.get(i + 1);
                                    y2 = cy += -this.operandStack.get(i + 2);
                                    x3 = cx += this.operandStack.get(i + 3);
                                    y3 = i + 4 == this.operandStack.size() - 1 ? (float)(cy += -this.operandStack.get(i + 4)) : (float)cy;
                                } else {
                                    x1 = cx += this.operandStack.get(i);
                                    y1 = cy;
                                    x2 = cx += this.operandStack.get(i + 1);
                                    y2 = cy += -this.operandStack.get(i + 2);
                                    y3 = cy += -this.operandStack.get(i + 3);
                                    x3 = i + 4 == this.operandStack.size() - 1 ? (float)(cx += this.operandStack.get(i + 4)) : (float)cx;
                                }
                                path.curveTo(x1, y1, x2, y2, x3, y3);
                            }
                            this.operandStack.writeTo(buff, op);
                            this.operandStack.clear();
                            closed = false;
                            continue block29;
                        }
                        case 26: {
                            float y3;
                            float x3;
                            float y2;
                            float x2;
                            float y1;
                            if (this.operandStack.size() < 2 || this.operandStack.size() % 4 != 0 && (this.operandStack.size() - 1) % 4 != 0) {
                                throw new ArrayIndexOutOfBoundsException(this.operandStack.size());
                            }
                            int i = 0;
                            if (this.operandStack.size() % 2 == 1) {
                                cx += this.operandStack.get(i);
                                ++i;
                            }
                            while (i < this.operandStack.size() - 3) {
                                float x1 = cx;
                                y1 = cy += -this.operandStack.get(i);
                                x2 = cx += this.operandStack.get(i + 1);
                                y2 = cy += -this.operandStack.get(i + 2);
                                x3 = cx;
                                y3 = cy += -this.operandStack.get(i + 3);
                                path.curveTo(x1, y1, x2, y2, x3, y3);
                                i += 4;
                            }
                            this.operandStack.writeTo(buff, op);
                            this.operandStack.clear();
                            closed = false;
                            continue block29;
                        }
                        case 3107: {
                            int i = this.operandStack.size();
                            float x1 = cx += this.operandStack.get(i);
                            float y1 = cy += -this.operandStack.get(i + 1);
                            float x2 = cx += this.operandStack.get(i + 2);
                            float y2 = cy += -this.operandStack.get(i + 3);
                            float x3 = cx += this.operandStack.get(i + 4);
                            float y3 = cy += -this.operandStack.get(i + 5);
                            float x4 = cx += this.operandStack.get(i + 6);
                            float y4 = cy += -this.operandStack.get(i + 7);
                            float x5 = cx += this.operandStack.get(i + 8);
                            float y5 = cy += -this.operandStack.get(i + 9);
                            float x6 = cx += this.operandStack.get(i + 10);
                            float y6 = cy += -this.operandStack.get(i + 11);
                            path.curveTo(x1, y1, x2, y2, x3, y3);
                            path.curveTo(x4, y4, x5, y5, x6, y6);
                            this.operandStack.writeTo(buff, op);
                            this.operandStack.clear();
                            closed = false;
                            continue block29;
                        }
                        case 3106: {
                            int i = this.operandStack.size();
                            float x1 = cx += this.operandStack.get(i);
                            float y1 = cy;
                            float x2 = cx += this.operandStack.get(i + 1);
                            float y2 = cy += -this.operandStack.get(i + 2);
                            float x3 = cx += this.operandStack.get(i + 3);
                            float y3 = cy;
                            float x4 = cx += this.operandStack.get(i + 4);
                            float y4 = cy;
                            float x5 = cx += this.operandStack.get(i + 5);
                            float y5 = cy;
                            float x6 = cx += this.operandStack.get(i + 6);
                            float y6 = cy;
                            path.curveTo(x1, y1, x2, y2, x3, y3);
                            path.curveTo(x4, y4, x5, y5, x6, y6);
                            this.operandStack.writeTo(buff, op);
                            this.operandStack.clear();
                            closed = false;
                            continue block29;
                        }
                        case 3108: {
                            int i = this.operandStack.size();
                            float x1 = cx += this.operandStack.get(i);
                            float y1 = cy += -this.operandStack.get(i + 1);
                            float x2 = cx += this.operandStack.get(i + 2);
                            float y2 = cy += -this.operandStack.get(i + 3);
                            float x3 = cx += this.operandStack.get(i + 4);
                            float y3 = cy;
                            float x4 = cx += this.operandStack.get(i + 5);
                            float y4 = cy;
                            float x5 = cx += this.operandStack.get(i + 6);
                            float y5 = cy += -this.operandStack.get(i + 7);
                            float x6 = cx += this.operandStack.get(i + 8);
                            float y6 = cy;
                            path.curveTo(x1, y1, x2, y2, x3, y3);
                            path.curveTo(x4, y4, x5, y5, x6, y6);
                            this.operandStack.writeTo(buff, op);
                            this.operandStack.clear();
                            closed = false;
                            continue block29;
                        }
                        case 3109: {
                            int i = this.operandStack.size();
                            float x1 = cx += this.operandStack.get(i);
                            float y1 = cy += -this.operandStack.get(i + 1);
                            float x2 = cx += this.operandStack.get(i + 2);
                            float y2 = cy += -this.operandStack.get(i + 3);
                            float x3 = cx += this.operandStack.get(i + 4);
                            float y3 = cy += -this.operandStack.get(i + 5);
                            float x4 = cx += this.operandStack.get(i + 6);
                            float y4 = cy += -this.operandStack.get(i + 7);
                            float x5 = cx += this.operandStack.get(i + 8);
                            float y5 = cy += -this.operandStack.get(i + 9);
                            float x6 = cx += this.operandStack.get(i + 10);
                            float y6 = cy += -this.operandStack.get(i + 11);
                            path.curveTo(x1, y1, x2, y2, x3, y3);
                            path.curveTo(x4, y4, x5, y5, x6, y6);
                            this.operandStack.writeTo(buff, op);
                            this.operandStack.clear();
                            closed = false;
                            continue block29;
                        }
                        case 1: 
                        case 3: 
                        case 18: 
                        case 23: {
                            hintCount += this.operandStack.size() / 2;
                            this.operandStack.writeTo(buff, op);
                            this.operandStack.clear();
                            continue block29;
                        }
                        case 19: 
                        case 20: {
                            this.operandStack.writeTo(buff, op);
                            this.operandStack.clear();
                            int maskBytes = ((hintCount += this.operandStack.size() / 2) + 7) / 8;
                            for (int i = 0; i < maskBytes; ++i) {
                                buff.write(this.raf.read());
                            }
                            continue block29;
                        }
                        case 10: {
                            int six = this.operandStack.pop();
                            six = localSubrOffsets.length < 1240 ? (six += 107) : (localSubrOffsets.length < 33900 ? (six += 1131) : (six += 32768));
                            this.execStack[this.execDepth++] = (int)this.raf.getFilePointer();
                            this.raf.seek(localSubrOffsets[six]);
                            continue block29;
                        }
                        case 29: {
                            int six = this.operandStack.pop();
                            six = globalSubrOffsets.length < 1240 ? (six += 107) : (globalSubrOffsets.length < 33900 ? (six += 1131) : (six += 32768));
                            this.execStack[this.execDepth++] = (int)this.raf.getFilePointer();
                            this.raf.seek(globalSubrOffsets[six]);
                            continue block29;
                        }
                        case 11: {
                            this.raf.seek(this.execStack[--this.execDepth]);
                            continue block29;
                        }
                    }
                    throw new UnsupportedOperationException(Integer.toHexString(op));
                }
                if (!closed) {
                    path.closePath();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        buff.write(14);
        byte[] charString = buff.toByteArray();
        return new Glyph(path, charString);
    }

    private int scanOperator() throws IOException {
        block4: while (true) {
            byte type = this.nextType();
            switch (type) {
                case 1: {
                    return this.readOperator();
                }
                case 2: {
                    this.operandStack.push(this.readInteger());
                    continue block4;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    private byte nextType() throws IOException {
        this.b0 = this.raf.read();
        if (this.b0 <= 31 && this.b0 != 28) {
            return 1;
        }
        return 2;
    }

    private int readOperator() throws IOException {
        if (this.b0 == -1 && this.nextType() != 1) {
            throw new IOException("Operator\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        int b = this.b0;
        this.b0 = -1;
        if (b == 12) {
            b <<= 8;
            int a = this.raf.read();
            b |= a;
        }
        return b;
    }

    private int readInteger() throws IOException {
        if (this.b0 == -1 && this.nextType() != 2) {
            throw new IOException("Integer\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        int b0 = this.b0;
        this.b0 = -1;
        if (b0 >= 32 && b0 <= 246) {
            return b0 - 139;
        }
        if (b0 >= 247 && b0 <= 250) {
            int b1 = this.raf.read();
            return (b0 - 247) * 256 + b1 + 108;
        }
        if (b0 >= 251 && b0 <= 254) {
            int b1 = this.raf.read();
            return -(b0 - 251) * 256 - b1 - 108;
        }
        if (b0 == 28) {
            int b1 = this.raf.read();
            int b2 = this.raf.read();
            return b1 << 8 | b2;
        }
        if (b0 == 255) {
            int b1 = this.raf.read();
            int b2 = this.raf.read();
            int b3 = this.raf.read();
            int b4 = this.raf.read();
            return b1 << 24 | b2 << 16 | b3 << 8 | b4;
        }
        throw new IOException("\u4e0d\u6b63\u306aInteger\u3067\u3059\u3002:" + b0);
    }
}

