/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.sakae.opentype.table;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import jp.cssj.sakae.opentype.table.CmapFormat0;
import jp.cssj.sakae.opentype.table.CmapFormat2;
import jp.cssj.sakae.opentype.table.CmapFormat4;
import jp.cssj.sakae.opentype.table.CmapFormat6;

public abstract class CmapFormat
implements Serializable {
    protected int format;
    protected int length;
    protected int version;

    protected CmapFormat(DataInputStream in) throws IOException {
        this.length = in.readUnsignedShort();
        this.version = in.readUnsignedShort();
    }

    protected static CmapFormat create(int format, DataInputStream in) throws IOException {
        switch (format) {
            case 0: {
                return new CmapFormat0(in);
            }
            case 2: {
                return new CmapFormat2(in);
            }
            case 4: {
                return new CmapFormat4(in);
            }
            case 6: {
                return new CmapFormat6(in);
            }
        }
        return null;
    }

    public int getFormat() {
        return this.format;
    }

    public int getLength() {
        return this.length;
    }

    public int getVersion() {
        return this.version;
    }

    public abstract int mapCharCode(int var1);

    public abstract int getFirst();

    public abstract int getLast();

    public String toString() {
        return "format: " + this.format + ", length: " + this.length + ", version: " + this.version;
    }
}

