/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.sakae.opentype.table;

import java.io.DataInputStream;
import java.io.IOException;
import jp.cssj.sakae.opentype.table.CmapFormat;

public class CmapFormat0
extends CmapFormat {
    private byte[] glyphIdArray = new byte[256];
    private int first;
    private int last;

    protected CmapFormat0(DataInputStream in) throws IOException {
        super(in);
        in.read(this.glyphIdArray);
        this.format = 0;
        this.first = -1;
        for (int i = 0; i < 256; ++i) {
            if (this.glyphIdArray[i] <= 0) continue;
            if (this.first == -1) {
                this.first = i;
            }
            this.last = i;
        }
    }

    public int getFirst() {
        return this.first;
    }

    public int getLast() {
        return this.last;
    }

    public int mapCharCode(int charCode) {
        if (0 <= charCode && charCode < 256) {
            return this.glyphIdArray[charCode] & 0xFF;
        }
        return 0;
    }
}

