/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.sakae.opentype.table;

import java.io.DataInputStream;
import java.io.IOException;

public class CmapIndexEntry {
    private int platformId;
    private int encodingId;
    private int offset;

    protected CmapIndexEntry(DataInputStream in) throws IOException {
        this.platformId = in.readUnsignedShort();
        this.encodingId = in.readUnsignedShort();
        this.offset = in.readInt();
    }

    public int getEncodingId() {
        return this.encodingId;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getPlatformId() {
        return this.platformId;
    }

    public String toString() {
        String platform;
        String encoding = "";
        switch (this.platformId) {
            case 1: {
                platform = " (Macintosh)";
                break;
            }
            case 3: {
                platform = " (Windows)";
                break;
            }
            default: {
                platform = "";
            }
        }
        if (this.platformId == 3) {
            switch (this.encodingId) {
                case 0: {
                    encoding = " (Symbol)";
                    break;
                }
                case 1: {
                    encoding = " (Unicode)";
                    break;
                }
                case 2: {
                    encoding = " (ShiftJIS)";
                    break;
                }
                case 3: {
                    encoding = " (Big5)";
                    break;
                }
                case 4: {
                    encoding = " (PRC)";
                    break;
                }
                case 5: {
                    encoding = " (Wansung)";
                    break;
                }
                case 6: {
                    encoding = " (Johab)";
                    break;
                }
                default: {
                    encoding = "";
                }
            }
        }
        return "platform id: " + this.platformId + platform + ", encoding id: " + this.encodingId + encoding + ", offset: " + this.offset;
    }
}

