/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.sakae.opentype.table;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import jp.cssj.sakae.opentype.table.CmapFormat;
import jp.cssj.sakae.opentype.table.CmapIndexEntry;
import jp.cssj.sakae.opentype.table.DirectoryEntry;
import jp.cssj.sakae.opentype.table.Table;
import jp.cssj.sakae.opentype.util.RandomAccessFileInputStream;

public class CmapTable
implements Table {
    private final int numTables;
    private final CmapIndexEntry[] entries;
    private final CmapFormat[] formats;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CmapTable(DirectoryEntry de, RandomAccessFile raf) throws IOException {
        RandomAccessFile randomAccessFile = raf;
        synchronized (randomAccessFile) {
            int i;
            raf.seek(de.getOffset());
            long fp = raf.getFilePointer();
            DataInputStream in = new DataInputStream(new BufferedInputStream(new RandomAccessFileInputStream(raf)));
            try {
                in.readUnsignedShort();
                this.numTables = in.readUnsignedShort();
                this.entries = new CmapIndexEntry[this.numTables];
                this.formats = new CmapFormat[this.numTables];
                for (i = 0; i < this.numTables; ++i) {
                    this.entries[i] = new CmapIndexEntry(in);
                }
            }
            finally {
                in.close();
            }
            for (i = 0; i < this.numTables; ++i) {
                raf.seek(fp + (long)this.entries[i].getOffset());
                in = new DataInputStream(new BufferedInputStream(new RandomAccessFileInputStream(raf)));
                try {
                    int format = in.readUnsignedShort();
                    this.formats[i] = CmapFormat.create(format, in);
                    continue;
                }
                finally {
                    in.close();
                }
            }
        }
    }

    public CmapFormat getCmapFormat(short platformId, short encodingId) {
        for (int i = 0; i < this.numTables; ++i) {
            if (this.entries[i].getPlatformId() != platformId || this.entries[i].getEncodingId() != encodingId) continue;
            return this.formats[i];
        }
        return null;
    }

    public int getType() {
        return 1668112752;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer().append("cmap\n");
        for (i = 0; i < this.numTables; ++i) {
            sb.append("\t").append(this.entries[i]).append("\n");
        }
        for (i = 0; i < this.numTables; ++i) {
            sb.append("\t").append(this.formats[i]).append("\n");
        }
        return sb.toString();
    }
}

