/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.sakae.opentype.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import jp.cssj.sakae.opentype.table.Feature;
import jp.cssj.sakae.opentype.table.FeatureRecord;
import jp.cssj.sakae.opentype.table.LangSys;

public class FeatureList {
    private final int featureCount;
    private final FeatureRecord[] featureRecords;
    private final Feature[] features;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeatureList(RandomAccessFile raf, int offset) throws IOException {
        RandomAccessFile randomAccessFile = raf;
        synchronized (randomAccessFile) {
            int i;
            raf.seek(offset);
            this.featureCount = raf.readUnsignedShort();
            this.featureRecords = new FeatureRecord[this.featureCount];
            this.features = new Feature[this.featureCount];
            for (i = 0; i < this.featureCount; ++i) {
                this.featureRecords[i] = new FeatureRecord(raf);
            }
            for (i = 0; i < this.featureCount; ++i) {
                this.features[i] = new Feature(raf, offset + this.featureRecords[i].getOffset());
            }
        }
    }

    public Feature findFeature(LangSys langSys, String tag) {
        if (tag.length() != 4) {
            return null;
        }
        int tagVal = tag.charAt(0) << 24 | tag.charAt(1) << 16 | tag.charAt(2) << 8 | tag.charAt(3);
        for (int i = 0; i < this.featureCount; ++i) {
            if (this.featureRecords[i].getTag() != tagVal || !langSys.isFeatureIndexed(i)) continue;
            return this.features[i];
        }
        return null;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this.featureRecords.length; ++i) {
            int tag = this.featureRecords[i].getTag();
            buff.append((char)(tag >> 24 & 0xFF)).append((char)(tag >> 16 & 0xFF)).append((char)(tag >> 8 & 0xFF)).append((char)(tag & 0xFF)).append('/');
        }
        return buff.toString();
    }
}

