/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.sakae.opentype.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import jp.cssj.sakae.opentype.table.Script;
import jp.cssj.sakae.opentype.table.ScriptRecord;

public class ScriptList {
    private final int scriptCount;
    private final ScriptRecord[] scriptRecords;
    private final Script[] scripts;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScriptList(RandomAccessFile raf, int offset) throws IOException {
        RandomAccessFile randomAccessFile = raf;
        synchronized (randomAccessFile) {
            int i;
            raf.seek(offset);
            this.scriptCount = raf.readUnsignedShort();
            this.scriptRecords = new ScriptRecord[this.scriptCount];
            this.scripts = new Script[this.scriptCount];
            for (i = 0; i < this.scriptCount; ++i) {
                this.scriptRecords[i] = new ScriptRecord(raf);
            }
            for (i = 0; i < this.scriptCount; ++i) {
                this.scripts[i] = new Script(raf, offset + this.scriptRecords[i].getOffset());
            }
        }
    }

    public int getScriptCount() {
        return this.scriptCount;
    }

    public ScriptRecord getScriptRecord(int i) {
        return this.scriptRecords[i];
    }

    public Script findScript(String tag) {
        if (tag.length() != 4) {
            return null;
        }
        int tagVal = tag.charAt(0) << 24 | tag.charAt(1) << 16 | tag.charAt(2) << 8 | tag.charAt(3);
        for (int i = 0; i < this.scriptCount; ++i) {
            if (this.scriptRecords[i].getTag() != tagVal) continue;
            return this.scripts[i];
        }
        return null;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this.scriptCount; ++i) {
            int tag = this.scriptRecords[i].getTag();
            buff.append((char)(tag >> 24 & 0xFF)).append((char)(tag >> 16 & 0xFF)).append((char)(tag >> 8 & 0xFF)).append((char)(tag & 0xFF)).append('/');
        }
        return buff.toString();
    }
}

