/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.sakae.opentype.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;
import jp.cssj.sakae.opentype.table.DirectoryEntry;
import jp.cssj.sakae.opentype.table.Table;

public class VorgTable
implements Table {
    private DirectoryEntry de;
    private RandomAccessFile raf;
    private short defaultVertOriginY;
    private int numVertOriginYMetrics;
    private Map indexToVertY = null;

    protected VorgTable(DirectoryEntry de, RandomAccessFile raf) throws IOException {
        this.de = de;
        this.raf = raf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load() {
        if (this.raf == null) {
            return;
        }
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            try {
                this.raf.seek(this.de.getOffset());
                this.raf.readUnsignedShort();
                this.raf.readUnsignedShort();
                this.defaultVertOriginY = this.raf.readShort();
                this.numVertOriginYMetrics = this.raf.readUnsignedShort();
                this.indexToVertY = new HashMap();
                for (int i = 0; i < this.numVertOriginYMetrics; ++i) {
                    int glyphIndex = this.raf.readUnsignedShort();
                    short vertOriginY = this.raf.readShort();
                    this.indexToVertY.put(new Integer(glyphIndex), new Short(vertOriginY));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.raf = null;
        }
    }

    public short getDefaultVertOriginY() {
        this.load();
        return this.defaultVertOriginY;
    }

    public short getVertOrigunY(int ix) {
        this.load();
        Short y = (Short)this.indexToVertY.get(new Integer(ix));
        if (y == null) {
            return this.defaultVertOriginY;
        }
        return y;
    }

    public int getType() {
        return 1448038983;
    }
}

