/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.sakae.opentype.table;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import jp.cssj.sakae.opentype.table.DirectoryEntry;
import jp.cssj.sakae.opentype.table.Table;
import jp.cssj.sakae.opentype.util.RandomAccessFileInputStream;

public abstract class XmtxTable
implements Table {
    private DirectoryEntry de;
    private RandomAccessFile raf;
    private int numberOfHMetrics;
    private int lsbCount;
    private int[] xMetrics = null;
    private short[] leftSideBearing = null;

    protected XmtxTable(DirectoryEntry de, RandomAccessFile raf) throws IOException {
        this.de = de;
        this.raf = raf;
    }

    public void init(int numberOfHMetrics, int lsbCount) throws IOException {
        this.numberOfHMetrics = numberOfHMetrics;
        this.lsbCount = lsbCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        if (this.raf == null) {
            return;
        }
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            try {
                this.xMetrics = new int[this.numberOfHMetrics];
                this.raf.seek(this.de.getOffset());
                DataInputStream in = new DataInputStream(new BufferedInputStream(new RandomAccessFileInputStream(this.raf)));
                try {
                    int i;
                    for (i = 0; i < this.numberOfHMetrics; ++i) {
                        this.xMetrics[i] = in.read() << 24 | in.read() << 16 | in.read() << 8 | in.read();
                    }
                    if (this.lsbCount > 0) {
                        this.leftSideBearing = new short[this.lsbCount];
                        for (i = 0; i < this.lsbCount; ++i) {
                            this.leftSideBearing[i] = (short)(in.read() << 8 | in.read());
                        }
                    }
                }
                finally {
                    in.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.raf = null;
        }
    }

    public synchronized int getAdvanceWidth(int i) {
        this.load();
        int advance = i < this.xMetrics.length ? this.xMetrics[i] >> 16 : this.xMetrics[this.xMetrics.length - 1] >> 16;
        return advance;
    }

    public synchronized short getLeftSideBearing(int i) {
        this.load();
        short lsb = i < this.xMetrics.length ? (short)(this.xMetrics[i] & 0xFFFF) : this.leftSideBearing[i -= this.xMetrics.length];
        return lsb;
    }
}

