/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.sakae.opentype.truetype;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import jp.cssj.sakae.opentype.table.GlyfTable;
import jp.cssj.sakae.opentype.truetype.GlyfCompositeComp;
import jp.cssj.sakae.opentype.truetype.GlyfDescript;

public class GlyfCompositeDescript
extends GlyfDescript {
    private List components = new ArrayList();

    public GlyfCompositeDescript(GlyfTable parentTable, RandomAccessFile raf) throws IOException {
        super(parentTable, -1, raf);
        GlyfCompositeComp comp;
        int firstIndex = 0;
        int firstContour = 0;
        do {
            comp = new GlyfCompositeComp(firstIndex, firstContour, raf);
            this.components.add(comp);
            GlyfDescript desc = parentTable.getDescription(comp.getGlyphIndex());
            if (desc == null) continue;
            firstIndex += desc.getPointCount();
            firstContour += desc.getContourCount();
        } while ((comp.getFlags() & 0x20) != 0);
        if ((comp.getFlags() & 0x100) != 0) {
            this.readInstructions(raf, raf.read() << 8 | raf.read());
        }
    }

    public int getEndPtOfContours(int i) {
        GlyfCompositeComp c = this.getCompositeCompEndPt(i);
        if (c != null) {
            GlyfDescript gd = this.parentTable.getDescription(c.getGlyphIndex());
            return gd.getEndPtOfContours(i - c.getFirstContour()) + c.getFirstIndex();
        }
        return 0;
    }

    public byte getFlags(int i) {
        GlyfCompositeComp c = this.getCompositeComp(i);
        if (c != null) {
            GlyfDescript gd = this.parentTable.getDescription(c.getGlyphIndex());
            return gd.getFlags(i - c.getFirstIndex());
        }
        return 0;
    }

    public short getXCoordinate(int i) {
        GlyfCompositeComp c = this.getCompositeComp(i);
        if (c != null) {
            GlyfDescript gd = this.parentTable.getDescription(c.getGlyphIndex());
            int n = i - c.getFirstIndex();
            short x = gd.getXCoordinate(n);
            short y = gd.getYCoordinate(n);
            short x1 = (short)c.scaleX(x, y);
            x1 = (short)(x1 + c.getXTranslate());
            return x1;
        }
        return 0;
    }

    public short getYCoordinate(int i) {
        GlyfCompositeComp c = this.getCompositeComp(i);
        if (c != null) {
            GlyfDescript gd = this.parentTable.getDescription(c.getGlyphIndex());
            int n = i - c.getFirstIndex();
            short x = gd.getXCoordinate(n);
            short y = gd.getYCoordinate(n);
            short y1 = (short)c.scaleY(x, y);
            y1 = (short)(y1 + c.getYTranslate());
            return y1;
        }
        return 0;
    }

    public boolean isComposite() {
        return true;
    }

    public int getPointCount() {
        GlyfCompositeComp c = (GlyfCompositeComp)this.components.get(this.components.size() - 1);
        return c.getFirstIndex() + this.parentTable.getDescription(c.getGlyphIndex()).getPointCount();
    }

    public int getContourCount() {
        GlyfCompositeComp c = (GlyfCompositeComp)this.components.get(this.components.size() - 1);
        return c.getFirstContour() + this.parentTable.getDescription(c.getGlyphIndex()).getContourCount();
    }

    public int getComponentIndex(int i) {
        return ((GlyfCompositeComp)this.components.get(i)).getFirstIndex();
    }

    public int getComponentCount() {
        return this.components.size();
    }

    protected GlyfCompositeComp getCompositeComp(int i) {
        for (int n = 0; n < this.components.size(); ++n) {
            GlyfCompositeComp c = (GlyfCompositeComp)this.components.get(n);
            GlyfDescript gd = this.parentTable.getDescription(c.getGlyphIndex());
            if (c.getFirstIndex() > i || i >= c.getFirstIndex() + gd.getPointCount()) continue;
            return c;
        }
        return null;
    }

    protected GlyfCompositeComp getCompositeCompEndPt(int i) {
        for (int j = 0; j < this.components.size(); ++j) {
            GlyfCompositeComp c = (GlyfCompositeComp)this.components.get(j);
            GlyfDescript gd = this.parentTable.getDescription(c.getGlyphIndex());
            if (c.getFirstContour() > i || i >= c.getFirstContour() + gd.getContourCount()) continue;
            return c;
        }
        return null;
    }
}

