/*

 Copyright 2001,2003  The Apache Software Foundation 

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 */
package jp.cssj.sakae.opentype;

import java.awt.geom.GeneralPath;

/**
 * An individual glyph within a font.
 * 
 * @version $Id: Glyph.java,v 1.2 2007-05-06 04:27:02 miyabe Exp $
 * @author <a href="mailto:david@steadystate.co.uk">David Schweinsberg</a>
 */
public class Glyph {
	private final GeneralPath path;

	private final byte[] charString;

	public Glyph(GeneralPath path, byte[] charString) {
		this.path = path;
		this.charString = charString;
	}

	public GeneralPath getPath() {
		return this.path;
	}

	public byte[] getCharString() {
		return this.charString;
	}
}
