package jp.cssj.sakae.opentype.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class RandomAccessFileInputStream extends InputStream {
	private RandomAccessFile raf;

	public RandomAccessFileInputStream(RandomAccessFile raf) {
		this.raf = raf;
	}

	public int available() throws IOException {
		return (int) (this.raf.length() - this.raf.getFilePointer());
	}

	public int read() throws IOException {
		return this.raf.read();
	}

	public int read(byte[] b, int off, int len) throws IOException {
		return this.raf.read(b, off, len);
	}

	public int read(byte[] b) throws IOException {
		return this.raf.read(b);
	}
}
