/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.driver.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jp.cssj.resolver.Source;
import org.apache.commons.io.IOUtils;
import org.apache.http.entity.mime.content.AbstractContentBody;

class SourceBody
extends AbstractContentBody {
    protected final Source source;

    public SourceBody(Source source) throws IOException {
        super(source.getMimeType() == null ? "application/octet-stream" : source.getMimeType());
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out) throws IOException {
        InputStream in = this.source.getInputStream();
        try {
            IOUtils.copy(in, out);
        }
        finally {
            in.close();
        }
    }

    public String getFilename() {
        return null;
    }

    public String getCharset() {
        try {
            return this.source.getEncoding();
        }
        catch (IOException e) {
            return null;
        }
    }

    public long getContentLength() {
        try {
            return this.source.getLength();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public String getTransferEncoding() {
        return "8bit";
    }
}

