/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.rsr.helpers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jp.cssj.rsr.RandomBuilder;
import jp.cssj.rsr.helpers.RandomBuilderWrapper;

public class RandomBuilderPositionSupport
extends RandomBuilderWrapper
implements RandomBuilder {
    private static final boolean DEBUG = false;
    private List<Fragment> frgs = new ArrayList<Fragment>();
    private Fragment first = null;
    private Fragment last = null;

    public RandomBuilderPositionSupport(RandomBuilder builder) {
        super(builder);
        assert (!builder.supportsPositionInfo());
    }

    protected int nextId() {
        return this.frgs.size();
    }

    protected Fragment getFragment(int id) {
        return this.frgs.get(id);
    }

    protected void putFragment(int id, Fragment frg) {
        assert (id == this.frgs.size());
        this.frgs.add(frg);
    }

    public RandomBuilder.PositionInfo getPositionInfo() {
        final long[] idToPosition = new long[this.frgs.size()];
        long position = 0L;
        Fragment frg = this.first;
        while (frg != null) {
            idToPosition[frg.id] = position;
            position += frg.length;
            frg = frg.next;
        }
        return new RandomBuilder.PositionInfo(){

            public long getPosition(int id) {
                long position = idToPosition[id];
                return position;
            }
        };
    }

    public void addBlock() throws IOException {
        int id = this.nextId();
        Fragment frg = new Fragment(id);
        if (this.first == null) {
            this.first = frg;
        } else {
            this.last.next = frg;
            frg.prev = this.last;
        }
        this.putFragment(id, frg);
        this.last = frg;
        super.addBlock();
    }

    public void insertBlockBefore(int anchorId) throws IOException {
        int id = this.nextId();
        Fragment anchor = this.getFragment(anchorId);
        Fragment frg = new Fragment(id);
        this.putFragment(id, frg);
        frg.prev = anchor.prev;
        frg.next = anchor;
        anchor.prev.next = frg;
        anchor.prev = frg;
        if (this.first == anchor) {
            this.first = frg;
        }
        super.insertBlockBefore(anchorId);
    }

    public void write(int id, byte[] b, int off, int len) throws IOException {
        Fragment frg = this.getFragment(id);
        frg.length += (long)len;
        super.write(id, b, off, len);
    }

    public void closeBlock(int id) throws IOException {
        super.closeBlock(id);
    }

    public void finish() throws IOException {
        this.first = null;
        this.last = null;
        this.frgs.clear();
        super.finish();
    }

    private class Fragment {
        public final int id;
        public Fragment prev = null;
        public Fragment next = null;
        public long length = 0L;

        public Fragment(int id) {
            this.id = id;
        }
    }
}

