/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.cssj.plugin.Plugin;

public class PluginLoader {
    private static final Logger LOG = Logger.getLogger(PluginLoader.class.getName());
    private static final File[] EMPTY_FILES = new File[0];
    private static final PluginLoader INSTANCE = new PluginLoader();
    private URLClassLoader loader = null;
    private Map<Class<Plugin<?>>, List<Plugin<?>>> roles = null;
    private File[] libs = null;
    private long[] times = null;

    public static final PluginLoader getPluginLoader() {
        return INSTANCE;
    }

    private PluginLoader() {
        this.reload();
        Thread th = new Thread(PluginLoader.class.getName()){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            PluginLoader.this.reload();
                            Thread.sleep(180000L);
                        }
                    }
                    catch (Throwable throwable) {
                        continue;
                    }
                    break;
                }
            }
        };
        th.setDaemon(true);
        th.start();
    }

    public synchronized void reload() {
        int i;
        File libDir = new File(System.getProperty("jp.cssj.plugin.lib", "plugins"));
        Object[] libs = libDir.listFiles();
        if (libs == null) {
            libs = EMPTY_FILES;
        }
        if (this.libs != null && this.libs.length == libs.length) {
            Arrays.sort(libs);
            boolean same = true;
            i = 0;
            while (i < libs.length) {
                File a = this.libs[i];
                Object b = libs[i];
                if (!a.equals(b)) {
                    same = false;
                    break;
                }
                if (this.times[i] != ((File)b).lastModified()) {
                    same = false;
                    break;
                }
                ++i;
            }
            if (same) {
                return;
            }
        }
        this.libs = libs;
        this.times = new long[libs.length];
        int i2 = 0;
        while (i2 < libs.length) {
            this.times[i2] = ((File)libs[i2]).lastModified();
            ++i2;
        }
        ArrayList<URL> urlList = new ArrayList<URL>();
        i = 0;
        while (i < this.libs.length) {
            File lib = this.libs[i];
            if (lib.getName().endsWith(".jar")) {
                try {
                    urlList.add(lib.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        URL[] urls = urlList.toArray(new URL[urlList.size()]);
        ClassLoader loader = this.getClass().getClassLoader();
        this.loader = new URLClassLoader(urls, loader);
        this.roles = new HashMap();
    }

    private void loadImpl(List<Plugin<?>> plugins, String name) throws IOException {
        Enumeration<URL> i = this.loader.getResources(name);
        while (i.hasMoreElements()) {
            URL url = i.nextElement();
            Throwable throwable = null;
            Object var6_7 = null;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));){
                String line = in.readLine();
                while (line != null) {
                    if ((line = line.trim()).length() > 0 && !line.startsWith("#")) {
                        try {
                            Class<?> clazz = this.loader.loadClass(line);
                            Plugin plugin = (Plugin)clazz.newInstance();
                            plugins.add(plugin);
                        }
                        catch (Exception e) {
                            LOG.log(Level.WARNING, "\u30d7\u30e9\u30b0\u30a4\u30f3\u30af\u30e9\u30b9\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f:" + line, e);
                        }
                    }
                    line = in.readLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public synchronized Iterator<Plugin<?>> plugins(Class role) {
        String name = role.getName();
        List<Plugin<?>> plugins = this.roles.get(role);
        if (plugins == null) {
            plugins = new ArrayList();
            this.roles.put(role, plugins);
            try {
                this.loadImpl(plugins, "META-INF/plugin/" + name + ".user");
                this.loadImpl(plugins, "META-INF/plugin/" + name + ".vendor");
                this.loadImpl(plugins, "META-INF/plugin/" + name + ".impl");
                this.loadImpl(plugins, "META-INF/plugin/" + name + ".default");
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "\u30d7\u30e9\u30b0\u30a4\u30f3\u30d5\u30a1\u30a4\u30eb\u3092\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3067\u3057\u305f", e);
            }
        }
        return plugins.iterator();
    }

    public synchronized void add(Class role, Plugin<?> plugin) {
        List<Plugin<?>> plugins = this.roles.get(role);
        if (plugins == null) {
            plugins = new ArrayList();
            this.roles.put(role, plugins);
        }
        plugins.add(plugin);
    }

    public synchronized Plugin<?> search(Class role, Object key) {
        Iterator<Plugin<?>> i = this.plugins(role);
        while (i.hasNext()) {
            Plugin<?> plugin = i.next();
            if (!plugin.match(key)) continue;
            return plugin;
        }
        return null;
    }

    public synchronized ClassLoader getClassLoader() {
        return this.loader;
    }
}

