/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.cti2.helpers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import jp.cssj.cti2.CTISession;
import jp.cssj.cti2.TranscoderException;
import jp.cssj.cti2.results.SingleResult;
import jp.cssj.resolver.file.FileSource;
import jp.cssj.resolver.stream.StreamSource;
import jp.cssj.resolver.url.URLSource;

public final class CTISessionHelper {
    private CTISessionHelper() {
    }

    public static void setResultFile(CTISession session, File file) throws IOException {
        SingleResult results = new SingleResult(file);
        session.setResults(results);
    }

    public static void setResultStream(CTISession session, OutputStream out) throws IOException {
        SingleResult results = new SingleResult(out);
        session.setResults(results);
    }

    public static void properties(CTISession session, Properties props) throws IOException {
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            session.property((String)e.getKey(), (String)e.getValue());
        }
    }

    public static void sendResourceFile(CTISession session, File file, String mimeType, String encoding) throws IOException {
        session.resource(new FileSource(file, mimeType, encoding));
    }

    public static void sendResourceURL(CTISession session, URL url, String mimeType, String encoding) throws IOException {
        try {
            session.resource(new URLSource(url, mimeType, encoding));
        }
        catch (URISyntaxException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    public static void sendResourceStream(CTISession session, InputStream in, URI uri, String mimeType, String encoding) throws IOException {
        session.resource(new StreamSource(uri, in, mimeType, encoding, -1L));
    }

    public static void sendResourceDir(CTISession session, File dir, String mimeType, String encoding) throws IOException {
        if (dir.isDirectory()) {
            File[] files = dir.listFiles();
            if (files != null) {
                int i = 0;
                while (i < files.length) {
                    CTISessionHelper.sendResourceDir(session, files[i], mimeType, encoding);
                    ++i;
                }
            }
        } else {
            CTISessionHelper.sendResourceFile(session, dir, mimeType, encoding);
        }
    }

    public static void transcodeFile(CTISession session, File file, String mimeType, String encoding) throws IOException, TranscoderException {
        session.transcode(new FileSource(file, mimeType, encoding));
    }

    public static void transcodeURL(CTISession session, URL url, String mimeType, String encoding) throws IOException, TranscoderException {
        try {
            session.transcode(new URLSource(url, mimeType, encoding));
        }
        catch (URISyntaxException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    public static void transcodeStream(CTISession session, InputStream in, URI uri, String mimeType, String encoding) throws IOException, TranscoderException {
        session.transcode(new StreamSource(uri, in, mimeType, encoding, -1L));
    }
}

