/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.resolver.http;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import jp.cssj.resolver.SourceValidity;
import jp.cssj.resolver.helpers.AbstractSource;
import jp.cssj.resolver.http.HttpSourceValidity;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.impl.client.CloseableHttpClient;

public class HttpSource
extends AbstractSource {
    private final CloseableHttpClient httpClient;
    private String mimeType;
    private String encoding;
    private HttpUriRequest req;
    private HttpResponse res;
    private InputStream in;
    private boolean exists;
    private long lastModified = -1L;
    private long contentLength = -1L;

    public HttpSource(URI uri, CloseableHttpClient httpClient) {
        super(uri);
        this.httpClient = httpClient;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public String getMimeType() throws IOException {
        this.tryConnect();
        return this.mimeType;
    }

    @Override
    public String getEncoding() throws IOException {
        this.tryConnect();
        return this.encoding;
    }

    @Override
    public boolean exists() throws IOException {
        this.tryConnect();
        return this.exists;
    }

    @Override
    public boolean isInputStream() throws IOException {
        return true;
    }

    @Override
    public boolean isReader() throws IOException {
        this.tryConnect();
        return this.encoding != null;
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        if (this.in != null) {
            if (this.res != null) {
                try {
                    InputStream in;
                    HttpEntity e = this.res.getEntity();
                    if (e != null && (in = e.getContent()) != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.res = null;
            }
            this.req = null;
            this.in = null;
        }
        this.tryConnect();
        HttpEntity entity = this.res.getEntity();
        if (entity == null) {
            throw new FileNotFoundException();
        }
        this.in = entity.getContent();
        return this.in;
    }

    protected void tryConnect() throws IOException {
        Header contentLength;
        Header lastModified;
        int status;
        if (this.req != null) {
            return;
        }
        this.req = this.createHttpRequest();
        try {
            this.res = this.httpClient.execute(this.req);
            status = this.res.getStatusLine().getStatusCode();
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        this.exists = status != 404;
        HttpEntity entity = this.res.getEntity();
        this.encoding = null;
        if (entity != null) {
            Header mimeType;
            Header encodingHeader = entity.getContentEncoding();
            if (encodingHeader != null) {
                this.encoding = encodingHeader.getValue();
                try {
                    if (this.encoding.equalsIgnoreCase("ISO-8859-1") || !Charset.isSupported(this.encoding)) {
                        this.encoding = null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((mimeType = entity.getContentType()) != null) {
                this.mimeType = mimeType.getValue();
            }
        }
        if ((lastModified = this.res.getLastHeader("Last-Modified")) != null) {
            this.lastModified = DateUtils.parseDate(lastModified.getValue()).getTime();
        }
        if ((contentLength = this.res.getLastHeader("Content-Length")) != null) {
            try {
                this.contentLength = Long.parseLong(contentLength.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected HttpUriRequest createHttpRequest() {
        HttpGet method = new HttpGet(this.uri);
        return method;
    }

    @Override
    public Reader getReader() throws IOException {
        if (this.encoding == null) {
            throw new UnsupportedOperationException();
        }
        return new InputStreamReader(this.getInputStream(), this.encoding);
    }

    @Override
    public File getFile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLength() throws IOException {
        this.tryConnect();
        return this.contentLength;
    }

    @Override
    public SourceValidity getValidity() {
        return new HttpSourceValidity(this.lastModified);
    }

    @Override
    public void close() {
        if (this.req != null) {
            try {
                if (this.in != null) {
                    try {
                        this.in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                this.res = null;
                this.req = null;
                this.in = null;
                try {
                    this.httpClient.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

